/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.license.json;

import de.sep.sesam.model.license.dto.BackupClientsDto;
import de.sep.sesam.model.license.dto.ClientsDto;
import de.sep.sesam.model.license.utils.LicenseUtils;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class ClientsResult {
    private int configured = 0;
    private int used;
    private int max;
    private List<ClientsDto> clients;
    private List<BackupClientsDto> backupClients;

    public ClientsResult(List<ClientsDto> clients, int used, int max, boolean obfuscate) {
        this.used = used;
        this.max = max;
        if (clients != null) {
            this.clients = obfuscate ? Collections.nCopies(clients.size(), new ClientsDto("client-")) : clients;
            this.configured = clients.size();
        } else {
            this.clients = Collections.emptyList();
        }
    }

    public ClientsResult(List<BackupClientsDto> backupClients, String used, String max, boolean obfuscate) {
        this.used = LicenseUtils.parseInt(used);
        this.max = LicenseUtils.parseInt(max);
        if (backupClients != null) {
            if (obfuscate) {
                backupClients.forEach(b -> b.setName("client-"));
                this.backupClients = backupClients;
            } else {
                this.backupClients = backupClients;
            }
            this.configured = backupClients.size();
        } else {
            this.backupClients = Collections.emptyList();
        }
    }

    @Generated
    public int getConfigured() {
        return this.configured;
    }

    @Generated
    public int getUsed() {
        return this.used;
    }

    @Generated
    public int getMax() {
        return this.max;
    }

    @Generated
    public List<ClientsDto> getClients() {
        return this.clients;
    }

    @Generated
    public List<BackupClientsDto> getBackupClients() {
        return this.backupClients;
    }

    @Generated
    public ClientsResult() {
    }
}

