/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.formatter;

import de.sep.sesam.model.formatter.ByteFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class TransferRateFormatter {
    private static final Pattern pattern = Pattern.compile("^\\s*([0-9.]+)\\s*([\\w]+)\\/(\\w)$");

    private static double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    public static Double fromString(String s) {
        if (StringUtils.isBlank(s)) {
            return null;
        }
        Matcher matcher = pattern.matcher(s);
        if (!matcher.matches()) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                return 0.0;
            }
        }
        double initial = Double.parseDouble(matcher.group(1));
        initial *= TransferRateFormatter.toByte(matcher.group(2));
        return initial *= TransferRateFormatter.toSecond(matcher.group(3));
    }

    private static double toSecond(String unit) {
        if (StringUtils.equals(unit, "h")) {
            return 2.777777777777778E-4;
        }
        if (StringUtils.equals(unit, "m")) {
            return 0.016666666666666666;
        }
        if (StringUtils.equals(unit, "ms")) {
            return 1000.0;
        }
        if (StringUtils.equals(unit, "ns")) {
            return 1000000.0;
        }
        return 1.0;
    }

    private static double toByte(String unit) {
        int multiplier = 32;
        int symbol = 32;
        double multiple = 1.0;
        double factor = 1000.0;
        if (StringUtils.length(unit) == 1) {
            symbol = unit.charAt(0);
        }
        if (StringUtils.length(unit) >= 2) {
            multiplier = unit.charAt(0);
            symbol = unit.charAt(1);
        }
        if (StringUtils.length(unit) >= 3 && StringUtils.lowerCase(unit).charAt(1) == 'i') {
            factor = 1024.0;
            symbol = unit.charAt(2);
        }
        switch (multiplier) {
            case 80: 
            case 112: {
                multiple *= factor;
            }
            case 84: 
            case 116: {
                multiple *= factor;
            }
            case 71: 
            case 103: {
                multiple *= factor;
            }
            case 77: 
            case 109: {
                multiple *= factor;
            }
            case 75: 
            case 107: {
                multiple *= factor;
            }
        }
        switch (symbol) {
            case 98: {
                multiple /= 8.0;
            }
        }
        return multiple;
    }

    public static Double fromStringGiBPerHour(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        try {
            double d = Double.parseDouble(value);
            return d * 1.073741824E9 / 3600.0;
        }
        catch (NumberFormatException numberFormatException) {
            return TransferRateFormatter.fromString(value);
        }
    }

    public static Double fromStringMiBPerHour(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        try {
            double d = Double.parseDouble(value);
            return d * 1048576.0 / 3600.0;
        }
        catch (NumberFormatException numberFormatException) {
            return TransferRateFormatter.fromString(value);
        }
    }

    public static String toBytesPerSecond(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf((Object)TransferRateFormatter.round(value, 1));
        if (appendUnit) {
            result = (String)result + " B/s";
        }
        return result;
    }

    public static String toBytesPerHour(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(Double.valueOf(TransferRateFormatter.round(value * 3600.0, 1)).longValue());
        if (appendUnit) {
            result = (String)result + " B/h";
        }
        return result;
    }

    public static String toKiBPerHour(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1024.0 * 3600.0, 1));
        if (appendUnit) {
            result = (String)result + " KiB/h";
        }
        return result;
    }

    public static String toKiBPerSecond(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1024.0, 1));
        if (appendUnit) {
            result = (String)result + " KiB/s";
        }
        return result;
    }

    public static String toKBPerHour(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1000.0 * 3600.0, 1));
        if (appendUnit) {
            result = (String)result + " KB/h";
        }
        return result;
    }

    public static String toKBPerSecond(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1000.0, 1));
        if (appendUnit) {
            result = (String)result + " KB/s";
        }
        return result;
    }

    public static String toMiBPerHour(Double value, boolean appendUnit) {
        return TransferRateFormatter.toMiBPerHour(value, appendUnit, 1);
    }

    public static String toMiBPerHour(Double value, boolean appendUnit, int precision) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1024.0 / 1024.0 * 3600.0, precision));
        if (appendUnit) {
            result = (String)result + " MiB/h";
        }
        return result;
    }

    public static String toMiBPerSecond(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1024.0 / 1024.0, 1));
        if (appendUnit) {
            result = (String)result + " MiB/s";
        }
        return result;
    }

    public static String toMBPerHour(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1000.0 / 1000.0 * 3600.0, 1));
        if (appendUnit) {
            result = (String)result + " MB/h";
        }
        return result;
    }

    public static String toMBPerSecond(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1000.0 / 1000.0, 1));
        if (appendUnit) {
            result = (String)result + " MB/s";
        }
        return result;
    }

    public static String toGiBPerHour(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1024.0 / 1024.0 / 1024.0 * 3600.0, 1));
        if (appendUnit) {
            result = (String)result + " GiB/h";
        }
        return result;
    }

    public static String toGBPerHour(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1000.0 / 1000.0 / 1000.0 * 3600.0, 1));
        if (appendUnit) {
            result = (String)result + " GB/h";
        }
        return result;
    }

    public static String toTiBPerHour(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1024.0 / 1024.0 / 1024.0 / 1024.0 * 3600.0, 1));
        if (appendUnit) {
            result = (String)result + " TiB/h";
        }
        return result;
    }

    public static String toTBPerHour(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1000.0 / 1000.0 / 1000.0 / 1000.0 * 3600.0, 1));
        if (appendUnit) {
            result = (String)result + " TB/h";
        }
        return result;
    }

    public static String toPiBPerHour(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1024.0 / 1024.0 / 1024.0 / 1024.0 / 1024.0 * 3600.0, 1));
        if (appendUnit) {
            result = (String)result + " PiB/h";
        }
        return result;
    }

    public static String toPBPerHour(Double value, boolean appendUnit) {
        Object result;
        Object object = result = value == null ? "0" : String.valueOf(TransferRateFormatter.round(value / 1000.0 / 1000.0 / 1000.0 / 1000.0 / 1000.0 * 3600.0, 1));
        if (appendUnit) {
            result = (String)result + " PB/h";
        }
        return result;
    }

    public static String toAutoBinaryPerHour(Double value, boolean appendUnit) {
        Double bytesPerHour;
        String result = null;
        Double d = bytesPerHour = value != null ? Double.valueOf(value * 3600.0) : null;
        result = bytesPerHour == null ? "0 B/h" : (bytesPerHour < ByteFormatter.A_KIBI ? TransferRateFormatter.toBytesPerHour(value, appendUnit) : (bytesPerHour < ByteFormatter.A_MEBI ? TransferRateFormatter.toKiBPerHour(value, appendUnit) : (bytesPerHour < ByteFormatter.A_GIBI ? TransferRateFormatter.toMiBPerHour(value, appendUnit) : (bytesPerHour < ByteFormatter.A_TEBI ? TransferRateFormatter.toGiBPerHour(value, appendUnit) : (bytesPerHour < ByteFormatter.A_PEBI ? TransferRateFormatter.toTiBPerHour(value, appendUnit) : TransferRateFormatter.toPiBPerHour(value, appendUnit))))));
        return result;
    }

    public static String toAutoDecimalPerHour(Double value, boolean appendUnit) {
        Double bytesPerHour;
        String result = null;
        Double d = bytesPerHour = value != null ? Double.valueOf(value * 3600.0) : null;
        result = bytesPerHour == null ? "0 B/h" : (bytesPerHour < ByteFormatter.A_KILOBYTE ? TransferRateFormatter.toBytesPerHour(value, appendUnit) : (bytesPerHour < ByteFormatter.A_MEGABYTE ? TransferRateFormatter.toKBPerHour(value, appendUnit) : (bytesPerHour < ByteFormatter.A_GIGABYTE ? TransferRateFormatter.toMBPerHour(value, appendUnit) : (bytesPerHour < 4.0 ? TransferRateFormatter.toGBPerHour(value, appendUnit) : (bytesPerHour < ByteFormatter.A_PETABYTE ? TransferRateFormatter.toTBPerHour(value, appendUnit) : TransferRateFormatter.toPBPerHour(value, appendUnit))))));
        return result;
    }

    public static String toBestFittingMegaBytes(Double value) {
        if (value == null) {
            return "0 B/h";
        }
        if (value < 1024.0) {
            return TransferRateFormatter.toMiBPerHour(value, true);
        }
        if (value < 1048576.0) {
            return TransferRateFormatter.toGiBPerHour(value, true);
        }
        if (value < 1.073741824E9) {
            return TransferRateFormatter.toTiBPerHour(value, true);
        }
        if (value < 0.0) {
            return String.valueOf((double)Math.round(value / 1024.0 / 1024.0 / 1024.0 * 3600.0 * 1000.0) / 1000.0) + " PB/h";
        }
        return String.valueOf((double)Math.round(value / 1024.0 / 1024.0 / 1024.0 * 3600.0 * 1000.0) / 1000.0) + " EB/h";
    }
}

