/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.formatter;

import de.sep.sesam.common.date.DateUtils;
import de.sep.sesam.common.date.HumanDate;
import de.sep.sesam.common.text.I18n;
import de.sep.sesam.model.formatter.ByteFormatter;
import de.sep.sesam.model.formatter.TransferRateFormatter;
import de.sep.sesam.model.type.DataSizeFormats;
import java.util.Date;

public class FieldFormatter {
    private static final ByteFormatter byteFormatter = new ByteFormatter();
    private final FieldFormatterType type;
    private String defaultDataSize = null;

    public FieldFormatter(FieldFormatterType type) {
        assert (type != null);
        this.type = type;
    }

    public final void setDefaultDataSize(String defaultDataSize) {
        this.defaultDataSize = defaultDataSize;
    }

    protected Double getValueInBytes(Number value) {
        assert (value != null);
        return value.doubleValue();
    }

    protected String getValueYesNo(Boolean value) {
        assert (value != null);
        return Boolean.TRUE.equals(value) ? I18n.get("Label.Yes", new Object[0]) : I18n.get("Label.No", new Object[0]);
    }

    protected String getValueOnOff(Boolean value) {
        assert (value != null);
        return Boolean.TRUE.equals(value) ? I18n.get("Label.On", new Object[0]) : I18n.get("Label.Off", new Object[0]);
    }

    public final String format(Object value) {
        if (value == null) {
            return "";
        }
        if (this.type.equals((Object)FieldFormatterType.RATE)) {
            return TransferRateFormatter.toBestFittingMegaBytes(((Number)value).doubleValue());
        }
        if (this.type.equals((Object)FieldFormatterType.THROUGHPUT)) {
            return TransferRateFormatter.toMiBPerHour(((Number)value).doubleValue(), true);
        }
        if (this.type.equals((Object)FieldFormatterType.SIZE)) {
            if (((Number)value).doubleValue() < 0.0) {
                return "";
            }
            if (DataSizeFormats.BINARY.name.equals(this.defaultDataSize)) {
                return byteFormatter.formatBytesAutoRangeBn(this.getValueInBytes((Number)value));
            }
            return byteFormatter.formatBytesAutoRange(this.getValueInBytes((Number)value));
        }
        if (this.type.equals((Object)FieldFormatterType.NODEC)) {
            return String.valueOf(((Number)value).longValue());
        }
        if (this.type.equals((Object)FieldFormatterType.DATE)) {
            if (value instanceof Date) {
                return DateUtils.dateToTableFormatStr((Date)value);
            }
            if (value instanceof String) {
                return DateUtils.dateToTableFormatStr(HumanDate.toDate((String)value));
            }
        } else if (this.type.equals((Object)FieldFormatterType.TIME)) {
            if (value instanceof Date) {
                return DateUtils.dateToTimeNoSecondsStr((Date)value);
            }
            if (value instanceof String) {
                return DateUtils.dateToTimeNoSecondsStr(HumanDate.toDate((String)value));
            }
        } else {
            if (this.type.equals((Object)FieldFormatterType.YES)) {
                Boolean b;
                Boolean bl = b = value instanceof Boolean ? (Boolean)value : Boolean.FALSE;
                if (value instanceof Long) {
                    b = (Long)value > 0L;
                }
                return this.getValueYesNo(b);
            }
            if (this.type.equals((Object)FieldFormatterType.ON)) {
                assert (value instanceof Boolean);
                return this.getValueOnOff((Boolean)value);
            }
        }
        return value.toString();
    }

    public static enum FieldFormatterType {
        RATE,
        THROUGHPUT,
        SIZE,
        DATE,
        TIME,
        YES,
        ON,
        NODEC;

    }
}

