/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.formatter;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.apache.commons.lang3.StringUtils;

public class ByteFormatter
extends Format {
    private static final long serialVersionUID = 3072952098652532364L;
    public static final int BYTE = 0;
    public static final int KILOBYTE = 1;
    public static final int MEGABYTE = 2;
    public static final int GIGABYTE = 3;
    public static final int TERABYTE = 4;
    public static final int PETABYTE = 5;
    public static final int EXABYTE = 6;
    public static final int KIBI = 7;
    public static final int MEBI = 8;
    public static final int GIBI = 9;
    public static final int TEBI = 10;
    public static final int PEBI = 11;
    public static final int EXBI = 12;
    public static final String STR_BYTE = "B ";
    public static final String STR_KILOBYTE = "KB";
    public static final String STR_MEGABYTE = "MB";
    public static final String STR_GIGABYTE = "GB";
    public static final String STR_TERABYTE = "TB";
    public static final String STR_PETABYTE = "PB";
    public static final String STR_EXABYTE = "EB";
    public static final String STR_KIBI = "KiB";
    public static final String STR_MEBI = "MiB";
    public static final String STR_GIBI = "GiB";
    public static final String STR_TEBI = "TiB";
    public static final String STR_PEBI = "PiB";
    public static final String STR_EXBI = "EiB";
    public static final Double A_KILOBYTE = 1000.0;
    public static final Double A_MEGABYTE = A_KILOBYTE * A_KILOBYTE;
    public static final Double A_GIGABYTE = A_MEGABYTE * A_KILOBYTE;
    public static final Double A_TERABYTE = A_GIGABYTE * A_KILOBYTE;
    public static final Double A_PETABYTE = A_TERABYTE * A_KILOBYTE;
    public static final Double A_EXABYTE = A_PETABYTE * A_KILOBYTE;
    public static final Double A_KIBI = 1024.0;
    public static final Double A_MEBI = A_KIBI * A_KIBI;
    public static final Double A_GIBI = A_MEBI * A_KIBI;
    public static final Double A_TEBI = A_GIBI * A_KIBI;
    public static final Double A_PEBI = A_TEBI * A_KIBI;
    public static final Double A_EXBI = A_PEBI * A_KIBI;
    private final AutoRangeBinary binaryFormatter = new AutoRangeBinary();

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        if (StringUtils.isBlank(source)) {
            return null;
        }
        int type = 0;
        if (StringUtils.contains((CharSequence)source, STR_BYTE)) {
            type = 0;
        }
        if (StringUtils.contains((CharSequence)source, STR_KILOBYTE)) {
            type = 1;
        }
        if (StringUtils.contains((CharSequence)source, STR_MEGABYTE)) {
            type = 2;
        }
        if (StringUtils.contains((CharSequence)source, STR_GIGABYTE)) {
            type = 3;
        }
        if (StringUtils.contains((CharSequence)source, STR_TERABYTE)) {
            type = 4;
        }
        if (StringUtils.contains((CharSequence)source, STR_PETABYTE)) {
            type = 5;
        }
        if (StringUtils.contains((CharSequence)source, STR_EXABYTE)) {
            type = 6;
        }
        if (StringUtils.contains((CharSequence)source, STR_KIBI)) {
            type = 7;
        }
        if (StringUtils.contains((CharSequence)source, STR_MEBI)) {
            type = 8;
        }
        if (StringUtils.contains((CharSequence)source, STR_GIBI)) {
            type = 9;
        }
        if (StringUtils.contains((CharSequence)source, STR_TEBI)) {
            type = 10;
        }
        if (StringUtils.contains((CharSequence)source, STR_PEBI)) {
            type = 11;
        }
        if (StringUtils.contains((CharSequence)source, STR_EXBI)) {
            type = 12;
        }
        String temp = source.replaceAll(STR_BYTE, "").replaceAll(STR_KILOBYTE, "").replaceAll(STR_MEGABYTE, "").replaceAll(STR_GIGABYTE, "").replaceAll(STR_TERABYTE, "").replaceAll(STR_PETABYTE, "").replaceAll(STR_EXABYTE, "").replaceAll(STR_KIBI, "").replaceAll(STR_MEBI, "").replaceAll(STR_GIBI, "").replaceAll(STR_TEBI, "").replaceAll(STR_PEBI, "").replaceAll(STR_EXBI, "");
        Double dt = Double.valueOf(temp);
        switch (type) {
            case 0: {
                return (double)dt;
            }
            case 1: {
                return dt * A_KILOBYTE;
            }
            case 2: {
                return dt * A_MEGABYTE;
            }
            case 3: {
                return dt * A_GIGABYTE;
            }
            case 4: {
                return dt * A_TERABYTE;
            }
            case 5: {
                return dt * A_PETABYTE;
            }
            case 6: {
                return dt * A_EXABYTE;
            }
            case 7: {
                return dt * A_KIBI;
            }
            case 8: {
                return dt * A_MEBI;
            }
            case 9: {
                return dt * A_GIBI;
            }
            case 10: {
                return dt * A_TEBI;
            }
            case 11: {
                return dt * A_PEBI;
            }
            case 12: {
                return dt * A_EXBI;
            }
        }
        return dt;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer sb, FieldPosition pos) {
        Double bytes = (Double)obj;
        pos.setBeginIndex(sb.length());
        if (bytes != null) {
            NumberFormat form = NumberFormat.getNumberInstance();
            form.setGroupingUsed(false);
            form.setMinimumFractionDigits(1);
            form.setMaximumFractionDigits(1);
            double absBytes = Math.abs(bytes);
            String formatted = absBytes < A_KILOBYTE ? this.formatInBytes(form, bytes) : (absBytes < A_MEGABYTE ? this.formatInKiloBytes(form, bytes) : (absBytes < A_GIGABYTE ? this.formatInMegaBytes(form, bytes) : (absBytes < A_TERABYTE ? this.formatInGigaBytes(form, bytes, true) : (absBytes < A_PETABYTE ? this.formatInTeraBytes(form, bytes, true) : (absBytes < A_EXABYTE ? this.formatInPetaBytes(form, bytes) : (absBytes < A_KIBI ? this.formatInBytes(form, bytes) : (absBytes < A_MEBI ? this.formatInKIBI(form, bytes) : (absBytes < A_GIBI ? this.formatInMEBI(form, bytes) : (absBytes < A_TEBI ? this.formatInGIBI(form, bytes, true) : (absBytes < A_PEBI ? this.formatInTEBI(form, bytes, true) : (absBytes < A_EXBI ? this.formatInPEBI(form, bytes) : (absBytes < Double.MAX_VALUE ? this.formatInPetaBytes(form, bytes) : "???"))))))))))));
            sb.append(formatted);
            sb.append(" ");
            pos.setEndIndex(sb.length() + formatted.length());
        } else {
            pos.setEndIndex(sb.length());
        }
        return sb;
    }

    public String formatInBytes(NumberFormat form, Double bytes) {
        String s = bytes.longValue() + "   B ";
        return s;
    }

    public String formatInKiloBytes(NumberFormat form, Double bytes) {
        if (bytes / A_KILOBYTE < 0.1 && bytes > 0.0) {
            return "0.1 KB ";
        }
        return form.format(bytes / A_KILOBYTE) + " KB ";
    }

    public String formatInMegaBytes(NumberFormat form, Double bytes) {
        if (bytes / A_MEGABYTE < 0.1 && bytes > 0.0) {
            return "0.1 MB ";
        }
        return form.format(bytes / A_MEGABYTE) + " MB ";
    }

    public String formatInGigaBytes(NumberFormat form, Double bytes, boolean showUnit) {
        if (bytes / A_GIGABYTE < 0.1 && bytes > 0.0) {
            if (showUnit) {
                return "0.1 GB ";
            }
            return "0.1";
        }
        if (showUnit) {
            return form.format(bytes / A_GIGABYTE) + " GB ";
        }
        return form.format(bytes / A_GIGABYTE);
    }

    public String formatInTeraBytes(NumberFormat form, Double bytes, boolean showUnit) {
        if (bytes / A_TERABYTE < 0.1 && bytes > 0.0) {
            if (showUnit) {
                return "0.1 TB ";
            }
            return "0.1";
        }
        if (showUnit) {
            return form.format(bytes / A_TERABYTE) + " TB ";
        }
        return form.format(bytes / A_TERABYTE);
    }

    public String formatInPetaBytes(NumberFormat form, Double bytes) {
        if (bytes / A_PETABYTE < 0.1 && bytes > 0.0) {
            return "0.1 PB ";
        }
        return form.format(bytes / A_PETABYTE) + " PB ";
    }

    public String formatInExaBytes(NumberFormat form, Double bytes) {
        if (bytes / A_EXABYTE < 0.1 && bytes > 0.0) {
            return "0.1 EB ";
        }
        return form.format(bytes / A_EXABYTE) + " EB ";
    }

    public String formatInKIBI(NumberFormat form, Double bytes) {
        if (bytes / A_KIBI < 0.1 && bytes > 0.0) {
            return "0.1 KiB ";
        }
        return form.format(bytes / A_KIBI) + " KiB ";
    }

    public String formatInMEBI(NumberFormat form, Double bytes) {
        if (bytes / A_MEBI < 0.1 && bytes > 0.0) {
            return "0.1 MiB ";
        }
        return form.format(bytes / A_MEBI) + " MiB ";
    }

    public String formatInGIBI(NumberFormat form, Double bytes, boolean showUnit) {
        if (bytes / A_GIBI < 0.1 && bytes > 0.0) {
            if (showUnit) {
                return "0.1 GiB ";
            }
            return "0.1";
        }
        if (showUnit) {
            return form.format(bytes / A_GIBI) + " GiB ";
        }
        return form.format(bytes / A_GIBI);
    }

    public String formatInTEBI(NumberFormat form, Double bytes, boolean showUnit) {
        if (bytes / A_TEBI < 0.1 && bytes > 0.0) {
            if (showUnit) {
                return "0.1 TiB ";
            }
            return "0.1";
        }
        if (showUnit) {
            return form.format(bytes / A_TEBI) + " TiB ";
        }
        return form.format(bytes / A_TEBI);
    }

    public String formatInPEBI(NumberFormat form, Double bytes) {
        if (bytes / A_PEBI < 0.1 && bytes > 0.0) {
            return "0.1 PiB ";
        }
        return form.format(bytes / A_PEBI) + " PiB ";
    }

    public String formatInEXBI(NumberFormat form, Double bytes) {
        if (bytes / A_EXBI < 0.1 && bytes > 0.0) {
            return "0.1 EiB ";
        }
        return form.format(bytes / A_EXBI) + " EiB ";
    }

    public String formatBytesAutoRangeBn(Double bytes) {
        String result = this.binaryFormatter.format(bytes);
        return result;
    }

    public String formatBytesAutoRangeBn(Long bytes) {
        String result = this.binaryFormatter.format(bytes.doubleValue());
        return result;
    }

    public String formatBytesAutoRange(Double bytes) {
        String result = this.format(bytes);
        return result;
    }

    public String formatBytesAutoRange(Long bytes) {
        String result = this.format(bytes.doubleValue());
        return result;
    }

    private class AutoRangeBinary
    extends Format {
        private static final long serialVersionUID = 6871154988853235840L;

        private AutoRangeBinary() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer sb, FieldPosition pos) {
            Double bytes = (Double)obj;
            pos.setBeginIndex(sb.length());
            if (bytes != null) {
                NumberFormat form = NumberFormat.getNumberInstance();
                form.setMinimumFractionDigits(1);
                form.setMaximumFractionDigits(1);
                Double absBytes = Math.abs(bytes);
                String formatted = absBytes < A_KIBI ? ByteFormatter.this.formatInBytes(form, bytes) : (absBytes < A_MEBI ? ByteFormatter.this.formatInKIBI(form, bytes) : (absBytes < A_GIBI ? ByteFormatter.this.formatInMEBI(form, bytes) : (absBytes < A_TEBI ? ByteFormatter.this.formatInGIBI(form, bytes, true) : (absBytes < A_PEBI ? ByteFormatter.this.formatInTEBI(form, bytes, true) : (absBytes < A_EXBI ? ByteFormatter.this.formatInPEBI(form, bytes) : (absBytes < Double.MAX_VALUE ? ByteFormatter.this.formatInEXBI(form, bytes) : "???"))))));
                sb.append(formatted);
                sb.append(" ");
                pos.setEndIndex(sb.length() + formatted.length());
            } else {
                pos.setEndIndex(sb.length());
            }
            return sb;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            int type = 0;
            type = 7;
            if (StringUtils.contains((CharSequence)source, ByteFormatter.STR_MEBI)) {
                type = 8;
            }
            if (StringUtils.contains((CharSequence)source, ByteFormatter.STR_GIBI)) {
                type = 9;
            }
            if (StringUtils.contains((CharSequence)source, ByteFormatter.STR_TEBI)) {
                type = 10;
            }
            if (StringUtils.contains((CharSequence)source, ByteFormatter.STR_PEBI)) {
                type = 11;
            }
            if (StringUtils.contains((CharSequence)source, ByteFormatter.STR_EXBI)) {
                type = 12;
            }
            String temp = source.replaceAll(ByteFormatter.STR_KIBI, "").replaceAll(ByteFormatter.STR_MEBI, "").replaceAll(ByteFormatter.STR_GIBI, "").replaceAll(ByteFormatter.STR_TEBI, "").replaceAll(ByteFormatter.STR_PEBI, "").replaceAll(ByteFormatter.STR_EXBI, "");
            Double dt = Double.valueOf(temp);
            switch (type) {
                case 7: {
                    return dt * A_KIBI;
                }
                case 8: {
                    return dt * A_MEBI;
                }
                case 9: {
                    return dt * A_GIBI;
                }
                case 10: {
                    return dt * A_TEBI;
                }
                case 11: {
                    return dt * A_PEBI;
                }
                case 12: {
                    return dt * A_EXBI;
                }
            }
            return dt;
        }
    }
}

