/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import de.sep.sesam.common.security.EncryptUtils;
import de.sep.sesam.model.Clients;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class VMServer
implements Serializable {
    private static final long serialVersionUID = -8065828839160503531L;
    String url;
    String username;
    String password;
    String vm;
    String dataCenter;

    public VMServer() {
    }

    public VMServer(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.setPassword(password);
    }

    public VMServer(Clients client) {
        this.url = "https://" + client.getName() + "/sdk/";
        this.username = client.getUserName();
        this.setPassword(client.getPassword());
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        String pw;
        if (StringUtils.isNotBlank(password) && StringUtils.isNotBlank(pw = EncryptUtils.getInstance().decrypt(password))) {
            password = pw;
        }
        this.password = password;
    }

    public String getVm() {
        return this.vm;
    }

    public void setVm(String vm) {
        this.vm = vm;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public void setDataCenter(String datacenter) {
        this.dataCenter = datacenter;
    }

    public String[] toArray() {
        return new String[]{this.url, this.username, this.password, this.vm, this.dataCenter};
    }

    public String getServer() {
        String retVal = this.url;
        retVal = retVal.replaceAll("https://", "");
        retVal = retVal.replaceAll("/.*", "");
        return retVal;
    }
}

