/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSerializableObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;

@Schema(description="UploadedFileItem")
public class UploadedFileItem
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = -1500996097416304455L;
    @Schema(description="The name of the file.", example="test.txt")
    private String name;
    @Schema(description="The size of the file in bytes.", example="1024")
    private long size;
    @Schema(description="The data of the file.", example="[\"1234\"]")
    private byte[] data;

    public void writeData(OutputStream fout) throws IOException {
        if (fout != null && ArrayUtils.isNotEmpty(this.data)) {
            fout.write(this.data);
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public byte[] getData() {
        return this.data;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSize(long size) {
        this.size = size;
    }

    @Generated
    public void setData(byte[] data) {
        this.data = data;
    }

    @Generated
    public UploadedFileItem() {
    }
}

