/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import de.sep.sesam.model.auth.SessionType;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import net.sf.oval.constraint.NotNull;

@Schema(description="Session data transfer object.")
public class SessionDto
extends AbstractSerializableObject
implements INamedEntity,
IDisplayLabelProvider {
    private static final long serialVersionUID = 5022533442063472322L;
    @NotNull
    @Schema(description="The session ID.", example="1234567890")
    private String id;
    @NotNull
    @Schema(description="The name of the user logged in to this session.", example="User1")
    private String name;
    @Schema(description="The original login name.", example="User1")
    private String loginName;
    @Schema(description="The session type.", example="WEB")
    private SessionType type;
    @Schema(description="The client remote address.", example="127.0.0.1:8080")
    private String address;
    @Schema(description="The list of roles assigned to the user.", example="[\"COMMON_READ\"]")
    private List<String> roles;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        assert (id != null);
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        assert (name != null);
        this.name = name;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public SessionType getSessionType() {
        return this.type;
    }

    public void setSessionType(SessionType type) {
        this.type = type;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles != null ? new ArrayList<String>(roles) : null;
    }

    @Override
    public String getDisplayLabel() {
        return this.name;
    }
}

