/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.update.UpdateRecommendation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@Schema(description="Server information")
public class ServerInfoDto
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = -5418150596317929129L;
    @Schema(description="The name of the server.", example="server1")
    private String name;
    @Schema(description="The host name of the server.", example="server1.example.com")
    private String ip;
    @Schema(description="The port of the REST API.", example="11401")
    private int restPort;
    @Schema(description="The operation system", example="Windows 10")
    private String os;
    @Schema(description="The id of the server.", example="1")
    private String id;
    @Schema(description="The git ID.", example="1235567u8")
    private String gitId;
    @Schema(description="The git branch.", example="temp")
    private String gitBranch;
    @Schema(description="The date string.", example="2020-04-27 15:25:00")
    private String dateString;
    @Schema(description="The string for the full build.", example="V.1.5.401 27.04.2001 15:25:00 (temp)")
    private String fullBuildString;
    @Schema(description="The string for the full build of the web UI.", example="V.1.5.401 27.04.2001 15:25:00 (temp) (web-ui)")
    private String fullBuildStringWebUi;
    @Schema(description="The string for the full build of the restore assistant.", example="V.1.5.401 27.04.2001 15:25:00 (temp) (restore-assistant)")
    private String fullBuildStringRestoreAssistant;
    @Schema(description="The recommendation for the update.", example="UPDATE_RMI_GUI", defaultValue="NO_UPDATE_NEEDED")
    private UpdateRecommendation updateRecommendation = UpdateRecommendation.NO_UPDATE_NEEDED;
    @Schema(description="If false, then DB/LDAP/AD based authentication is disabled and the server is using Java policy based security.", example="true")
    private boolean requireAuth;
    @Schema(description="If true, then every user can log in to the server (only valid for Java policy-based security).", example="true")
    private boolean allPermission;
    @Schema(description="Flag to mark if the eula for this server has been accepted or not.", example="true")
    private boolean eulaAccepted;
    @Schema(description="The message.", example="Blubber")
    private String message;
    @Schema(description="The file to be updated, can more than one.", example="file1.txt")
    private List<String> filesToUpdate;
    @Schema(description="The list of available languages.", example="de")
    private String lang;
    @Schema(description="All the java version.", example="1.8.0_241")
    private String javaVersion;
    @Schema(description="The java vendor.", example="Oracle Corporation")
    private String javaRuntime;
    private String javaVm;
    private String javaVendor;
    private String javaOs;
    private String release;
    private String previousRelease;
    private String kernel;
    private String kernelGitId;
    private String packageName;
    private String installationDate;
    private String updateDate;
    private String brand;
    private String encoding;
    private String buildHost;
    @Schema(description="The type of the database.", example="Oracle")
    private String dbType;
    private String serverOs;
    private String servicepackDate;
    private String servicepackNumber;
    private String servicepackPackage;
    @JsonIgnore
    @Schema(description="The version of the kit", example="1.5.401")
    private String kitVersion;
    private String currentBackupDay;
    private String timeZone;
    private Integer tzOffset;
    private String sessionId;
    private Map<String, Object> capabilities;

    public String getFullBuildString() {
        if (this.fullBuildString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.id);
            if (this.dateString != null) {
                sb.append(" ").append(this.dateString);
            }
            if (this.gitId != null) {
                sb.append(" ").append(this.gitId);
            }
            if (this.gitBranch != null) {
                sb.append(" (").append(this.gitBranch).append(")");
            }
            this.fullBuildString = sb.toString();
        }
        return this.fullBuildString;
    }

    public String getShortGitId() {
        return StringUtils.substring(this.gitId, 0, 7);
    }

    @JsonIgnore
    public String getString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id);
        sb.append(" ");
        if (this.dateString != null) {
            String newDateString = this.dateString.replace('/', '-');
            sb.append(newDateString);
        }
        return sb.toString();
    }

    public String getKitVersion() {
        if (StringUtils.isBlank(this.kitVersion) && StringUtils.isNotBlank(this.kernel)) {
            int beginIndex = this.kernel.indexOf(44);
            int endIndex = this.kernel.lastIndexOf(44);
            if (beginIndex > -1 && endIndex > -1 && endIndex > beginIndex) {
                this.kitVersion = this.kernel.substring(beginIndex + 1, endIndex);
            }
        }
        return this.kitVersion;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public int getRestPort() {
        return this.restPort;
    }

    @Generated
    public String getOs() {
        return this.os;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getGitId() {
        return this.gitId;
    }

    @Generated
    public String getGitBranch() {
        return this.gitBranch;
    }

    @Generated
    public String getDateString() {
        return this.dateString;
    }

    @Generated
    public String getFullBuildStringWebUi() {
        return this.fullBuildStringWebUi;
    }

    @Generated
    public String getFullBuildStringRestoreAssistant() {
        return this.fullBuildStringRestoreAssistant;
    }

    @Generated
    public UpdateRecommendation getUpdateRecommendation() {
        return this.updateRecommendation;
    }

    @Generated
    public boolean isRequireAuth() {
        return this.requireAuth;
    }

    @Generated
    public boolean isAllPermission() {
        return this.allPermission;
    }

    @Generated
    public boolean isEulaAccepted() {
        return this.eulaAccepted;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public List<String> getFilesToUpdate() {
        return this.filesToUpdate;
    }

    @Generated
    public String getLang() {
        return this.lang;
    }

    @Generated
    public String getJavaVersion() {
        return this.javaVersion;
    }

    @Generated
    public String getJavaRuntime() {
        return this.javaRuntime;
    }

    @Generated
    public String getJavaVm() {
        return this.javaVm;
    }

    @Generated
    public String getJavaVendor() {
        return this.javaVendor;
    }

    @Generated
    public String getJavaOs() {
        return this.javaOs;
    }

    @Generated
    public String getRelease() {
        return this.release;
    }

    @Generated
    public String getPreviousRelease() {
        return this.previousRelease;
    }

    @Generated
    public String getKernel() {
        return this.kernel;
    }

    @Generated
    public String getKernelGitId() {
        return this.kernelGitId;
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public String getInstallationDate() {
        return this.installationDate;
    }

    @Generated
    public String getUpdateDate() {
        return this.updateDate;
    }

    @Generated
    public String getBrand() {
        return this.brand;
    }

    @Generated
    public String getEncoding() {
        return this.encoding;
    }

    @Generated
    public String getBuildHost() {
        return this.buildHost;
    }

    @Generated
    public String getDbType() {
        return this.dbType;
    }

    @Generated
    public String getServerOs() {
        return this.serverOs;
    }

    @Generated
    public String getServicepackDate() {
        return this.servicepackDate;
    }

    @Generated
    public String getServicepackNumber() {
        return this.servicepackNumber;
    }

    @Generated
    public String getServicepackPackage() {
        return this.servicepackPackage;
    }

    @Generated
    public String getCurrentBackupDay() {
        return this.currentBackupDay;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public Integer getTzOffset() {
        return this.tzOffset;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setRestPort(int restPort) {
        this.restPort = restPort;
    }

    @Generated
    public void setOs(String os) {
        this.os = os;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setGitId(String gitId) {
        this.gitId = gitId;
    }

    @Generated
    public void setGitBranch(String gitBranch) {
        this.gitBranch = gitBranch;
    }

    @Generated
    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    @Generated
    public void setFullBuildString(String fullBuildString) {
        this.fullBuildString = fullBuildString;
    }

    @Generated
    public void setFullBuildStringWebUi(String fullBuildStringWebUi) {
        this.fullBuildStringWebUi = fullBuildStringWebUi;
    }

    @Generated
    public void setFullBuildStringRestoreAssistant(String fullBuildStringRestoreAssistant) {
        this.fullBuildStringRestoreAssistant = fullBuildStringRestoreAssistant;
    }

    @Generated
    public void setUpdateRecommendation(UpdateRecommendation updateRecommendation) {
        this.updateRecommendation = updateRecommendation;
    }

    @Generated
    public void setRequireAuth(boolean requireAuth) {
        this.requireAuth = requireAuth;
    }

    @Generated
    public void setAllPermission(boolean allPermission) {
        this.allPermission = allPermission;
    }

    @Generated
    public void setEulaAccepted(boolean eulaAccepted) {
        this.eulaAccepted = eulaAccepted;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setFilesToUpdate(List<String> filesToUpdate) {
        this.filesToUpdate = filesToUpdate;
    }

    @Generated
    public void setLang(String lang) {
        this.lang = lang;
    }

    @Generated
    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    @Generated
    public void setJavaRuntime(String javaRuntime) {
        this.javaRuntime = javaRuntime;
    }

    @Generated
    public void setJavaVm(String javaVm) {
        this.javaVm = javaVm;
    }

    @Generated
    public void setJavaVendor(String javaVendor) {
        this.javaVendor = javaVendor;
    }

    @Generated
    public void setJavaOs(String javaOs) {
        this.javaOs = javaOs;
    }

    @Generated
    public void setRelease(String release) {
        this.release = release;
    }

    @Generated
    public void setPreviousRelease(String previousRelease) {
        this.previousRelease = previousRelease;
    }

    @Generated
    public void setKernel(String kernel) {
        this.kernel = kernel;
    }

    @Generated
    public void setKernelGitId(String kernelGitId) {
        this.kernelGitId = kernelGitId;
    }

    @Generated
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Generated
    public void setInstallationDate(String installationDate) {
        this.installationDate = installationDate;
    }

    @Generated
    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }

    @Generated
    public void setBrand(String brand) {
        this.brand = brand;
    }

    @Generated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Generated
    public void setBuildHost(String buildHost) {
        this.buildHost = buildHost;
    }

    @Generated
    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    @Generated
    public void setServerOs(String serverOs) {
        this.serverOs = serverOs;
    }

    @Generated
    public void setServicepackDate(String servicepackDate) {
        this.servicepackDate = servicepackDate;
    }

    @Generated
    public void setServicepackNumber(String servicepackNumber) {
        this.servicepackNumber = servicepackNumber;
    }

    @Generated
    public void setServicepackPackage(String servicepackPackage) {
        this.servicepackPackage = servicepackPackage;
    }

    @JsonIgnore
    @Generated
    public void setKitVersion(String kitVersion) {
        this.kitVersion = kitVersion;
    }

    @Generated
    public void setCurrentBackupDay(String currentBackupDay) {
        this.currentBackupDay = currentBackupDay;
    }

    @Generated
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Generated
    public void setTzOffset(Integer tzOffset) {
        this.tzOffset = tzOffset;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setCapabilities(Map<String, Object> capabilities) {
        this.capabilities = capabilities;
    }

    @Generated
    public ServerInfoDto() {
    }
}

