/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSerializableObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.File;
import lombok.Generated;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

@Schema(description="All available server located files.")
public class ServerFileListDto
extends AbstractSerializableObject {
    private static final long serialVersionUID = 3197650048023235122L;
    @NotNull
    @Schema(description="The name of the file without any path information.", example="file.txt")
    private String name;
    @NotNull
    @Schema(description="The size of the file in bytes.", example="1024")
    private Long size;
    @NotNull
    @Schema(description="The last modified date of the file.", example="1577836800000")
    private Long lastModified;
    @Schema(description="The location of the requested file at the server in form of a Sesam GV variable.", example="gv_rw_gui")
    private String location;
    @Schema(description="The type of the file.", example="text/plain")
    private String type;
    @Schema(description="The file selector", example="not")
    private String selector;
    @Schema(description="Any kind of additional information about the requested file", example="addInfo")
    private String additionalInfo;
    @Schema(description="The date of the last modification in the format yyyy-MM-dd", example="2020-01-01")
    private String dayLbl;
    @Schema(description="If present in the return object and if set to true, then the corresponding file should not\nbe visible to the user in any log viewer. File entries marked as hidden should be\nattached to e-mails only, if send to customer support in example.\n", example="true")
    private Boolean hidden;
    @Schema(description="If it should be deleted after the completion.", example="true")
    private Boolean deleteOnCompletion;
    @Schema(description="The file object", example="file.txt")
    private File file;

    @JsonIgnore
    public final String toGvString() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank(this.location)) {
            sb.append(this.location);
            sb.append(":");
        }
        if (StringUtils.isNotBlank(this.name)) {
            sb.append(this.name);
        }
        return sb.toString();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @Generated
    public Long getLastModified() {
        return this.lastModified;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getSelector() {
        return this.selector;
    }

    @Generated
    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Generated
    public String getDayLbl() {
        return this.dayLbl;
    }

    @Generated
    public Boolean getHidden() {
        return this.hidden;
    }

    @Generated
    public Boolean getDeleteOnCompletion() {
        return this.deleteOnCompletion;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSize(Long size) {
        this.size = size;
    }

    @Generated
    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setSelector(String selector) {
        this.selector = selector;
    }

    @Generated
    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Generated
    public void setDayLbl(String dayLbl) {
        this.dayLbl = dayLbl;
    }

    @Generated
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @Generated
    public void setDeleteOnCompletion(Boolean deleteOnCompletion) {
        this.deleteOnCompletion = deleteOnCompletion;
    }

    @Generated
    public void setFile(File file) {
        this.file = file;
    }
}

