/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import de.sep.sesam.model.Clients;
import de.sep.sesam.model.RestoreEvents;
import de.sep.sesam.model.RestoreTasks;
import de.sep.sesam.model.Results;
import de.sep.sesam.model.Schedules;
import de.sep.sesam.model.annotations.SesamParameter;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.type.CryptFlagType;
import de.sep.sesam.model.type.PrePost;
import de.sep.sesam.model.type.RestoreMode;
import de.sep.sesam.model.type.RestoreOptions;
import de.sep.sesam.model.type.RestoreOverwriteMode;
import de.sep.sesam.model.type.RestoreTreeType;
import java.io.Serializable;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class RestoreDto
implements Serializable,
INamedEntity {
    private static final long serialVersionUID = 7524843308053116456L;
    @NotNull
    @Length(max=49)
    @SesamParameter(shortFields={"T"}, description="Model.RestoreEvents.Description.RestoreTask")
    private @NotNull @Length(max=49) String name;
    @SesamParameter(shortFields={"l"}, description="Model.RestoreTasks.Description.Type", defaultValue="f ")
    private RestoreOptions type;
    @SesamParameter(shortFields={"G"}, description="Model.RestoreTasks.Description.Genmode")
    private Boolean genmode;
    @SesamParameter(shortFields={"t"}, stringEnum=true, description="Model.RestoreTasks.Description.TreeType", defaultValue="d")
    private RestoreTreeType treeType;
    @SesamParameter(shortFields={"s"}, target="name", description="Model.RestoreTasks.Description.Result")
    private Results result;
    @SesamParameter(shortFields={"d"}, description="Model.RestoreTasks.Description.Drive")
    private Long driveNum;
    @SesamParameter(shortFields={"o"}, description="Model.RestoreTasks.Description.Options")
    private String options;
    @NotNull
    @SesamParameter(shortFields={"c"}, target="name", description="Model.RestoreTasks.Description.Client")
    private Clients client;
    @NotNull
    @Length(max=1024)
    @SesamParameter(shortFields={"R"}, description="Model.RestoreTasks.Description.TargetPath")
    private @NotNull @Length(max=1024) String targetPath;
    @SesamParameter(shortFields={"S"}, description="Model.RestoreTasks.Description.IFace")
    private String ifaceName;
    @Length(max=255)
    @SesamParameter(shortFields={"F"}, description="Model.RestoreTasks.Description.Filter")
    private @Length(max=255) String filter;
    @SesamParameter(shortFields={"P"}, stringEnum=true, description="Model.RestoreTasks.Description.RPrepost")
    private PrePost rPrepost;
    @Length(max=128)
    @SesamParameter(shortFields={"i"}, description="Model.RestoreTasks.Description.Usercomment")
    private @Length(max=128) String usercomment;
    @SesamParameter(shortFields={"D"}, description="Model.Dto.RestoreDto.Description.SesamDate")
    private Date sesamDate;
    @SesamParameter(shortFields={"j"}, description="Model.RestoreTasks.Description.Task")
    private String task;
    @SesamParameter(shortFields={"n"}, description="Model.Dto.RestoreDto.Description.Cnt")
    private Long cnt;
    @SesamParameter(shortFields={"f"}, description="Model.RestoreTasks.Description.SelFile")
    private String selFile;
    @SesamParameter(shortFields={"r"}, description="Model.RestoreTasks.Description.TargetStore")
    private String targetDatastore;
    @SesamParameter(shortFields={"M"}, description="Model.RestoreTasks.Description.Original")
    private Boolean original;
    @Length(max=64)
    @SesamParameter(shortFields={"a"}, description="Model.RestoreTasks.Description.Recover")
    private @Length(max=64) String recover;
    @Length(max=64)
    @SesamParameter(shortFields={"E"}, description="Model.RestoreTasks.Description.TargetServer")
    private @Length(max=64) String targetServer;
    @SesamParameter(shortFields={"V"}, description="Model.Dto.RestoreDto.Description.Verify")
    private String verify;
    private Boolean rename;
    private RestoreMode mode;
    private RestoreOverwriteMode overwrite;
    @SesamParameter(shortFields={"m"}, description="Model.RestoreEvents.Description.MediaPool")
    private String mediaPool;
    @SesamParameter(shortFields={"@"}, description="Model.Description.FollowUpEvent", cliCommandType={"restore"})
    private String followUp;
    @SesamParameter(shortFields={"O"}, description="Model.RestoreTasks.Description.Mode")
    private RestoreMode restoreMode;
    @Length(max=1024)
    @SesamParameter(shortFields={"e"}, description="Model.Dto.RestoreDto.Description.Eol")
    private @Length(max=1024) Long eol;
    @SesamParameter(shortFields={"q"}, description="Model.Dto.RestoreDto.Description.UseLastSuccessfulBackup")
    private Boolean useLastSuccessfulBackup;
    @SesamParameter(shortFields={"Q"}, description="Model.RestoreTasks.Description.PathFlag")
    private Boolean pathFlag;
    @SesamParameter(shortFields={"U"}, description="Model.RestoreTasks.Description.DumpFlag")
    private Boolean dumpFlag;
    @Length(max=2048)
    @SesamParameter(shortFields={"H"}, description="Model.RestoreTasks.Description.TargetFolder")
    private @Length(max=2048) String targetFolder;
    @Length(max=2048)
    @SesamParameter(shortFields={"L"}, description="Model.RestoreTasks.Description.TargetResource")
    private @Length(max=2048) String targetResource;
    @Length(max=2048)
    @SesamParameter(shortFields={"N"}, description="Model.RestoreTasks.Description.TargetNetwork")
    private @Length(max=2048) String targetNetwork;
    @SesamParameter(shortFields={"C"}, stringEnum=true, description="Model.RestoreTasks.Description.CryptFlag")
    private CryptFlagType cryptFlag;
    @SesamParameter(shortFields={"K"}, description="Model.RestoreTasks.Description.DataMover")
    private String dataMover;
    @SesamParameter(shortFields={"k"}, description="Model.RestoreTasks.Description.CryptKey")
    private String cryptKey;
    private Schedules schedules;

    public void setRestoreMode(RestoreMode restoreMode) {
        this.restoreMode = restoreMode;
        switch (restoreMode) {
            case OVERWRITE: {
                this.setOverwrite(RestoreOverwriteMode.OVERWRITE);
                this.setRename(false);
                break;
            }
            case OVERWRITE_NEWER: {
                this.setOverwrite(RestoreOverwriteMode.OVERWRITE_NEWER);
                this.setRename(false);
                break;
            }
            case OVERWRITE_OLDER: {
                this.setOverwrite(RestoreOverwriteMode.OVERWRITE_OLDER);
                this.setRename(false);
                break;
            }
            case NO_OVERWRITE: {
                this.setOverwrite(RestoreOverwriteMode.NO_OVERWRITE);
                this.setRename(false);
                break;
            }
            case NEW_VERSION: {
                this.setOverwrite(RestoreOverwriteMode.NO_OVERWRITE);
                this.setRename(true);
                break;
            }
        }
    }

    public RestoreTasks toRestoreTasks() {
        if (this.result == null) {
            this.result = new Results();
        }
        RestoreTasks t = new RestoreTasks();
        t.setName(this.name);
        t.setType(this.type);
        t.setGenmode(this.genmode);
        t.setTreeType(this.treeType);
        this.result.setTask(this.task);
        this.result.setCnt(this.cnt);
        this.result.setSesamDate(this.sesamDate);
        t.setResult(this.result);
        t.setDriveNum(this.driveNum);
        t.setOptions(this.options);
        t.setClient(this.client);
        t.setIfaceName(this.ifaceName);
        t.setMediaPool(this.mediaPool);
        t.setFilter(this.filter);
        t.setrPrepost(this.rPrepost);
        t.setUsercomment(this.usercomment);
        t.setOriginal(this.original);
        t.setRecover(this.recover);
        t.setVerify(this.verify);
        t.setOverwrite(this.overwrite != null ? this.overwrite : RestoreOverwriteMode.NO_OVERWRITE);
        t.setMode(this.mode);
        t.setRename(this.rename != null ? this.rename : Boolean.FALSE);
        t.setEol(this.eol);
        t.setPathFlag(this.pathFlag);
        t.setDumpFlag(this.dumpFlag);
        t.setTargetStore(this.targetDatastore);
        t.setTargetFolder(this.targetFolder);
        t.setTargetNetwork(this.targetNetwork);
        t.setTargetPath(this.targetPath);
        t.setTargetResource(this.targetResource);
        t.setTargetServer(this.targetServer);
        t.setCryptFlag(this.cryptFlag);
        t.setDataMover(this.dataMover);
        t.setCryptKey(this.cryptKey);
        return t;
    }

    public RestoreEvents toRestoreEvents() {
        RestoreEvents e = new RestoreEvents();
        e.setRestoreTask(this.name);
        e.setFollowUp(this.followUp);
        e.setMediaPool(this.mediaPool);
        return e;
    }

    public PrePost getrPrepost() {
        return this.rPrepost;
    }

    public void setrPrepost(PrePost rPrepost) {
        this.rPrepost = rPrepost;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public RestoreOptions getType() {
        return this.type;
    }

    @Generated
    public Boolean getGenmode() {
        return this.genmode;
    }

    @Generated
    public RestoreTreeType getTreeType() {
        return this.treeType;
    }

    @Generated
    public Results getResult() {
        return this.result;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public Clients getClient() {
        return this.client;
    }

    @Generated
    public String getTargetPath() {
        return this.targetPath;
    }

    @Generated
    public String getIfaceName() {
        return this.ifaceName;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public Date getSesamDate() {
        return this.sesamDate;
    }

    @Generated
    public String getTask() {
        return this.task;
    }

    @Generated
    public Long getCnt() {
        return this.cnt;
    }

    @Generated
    public String getSelFile() {
        return this.selFile;
    }

    @Generated
    public String getTargetDatastore() {
        return this.targetDatastore;
    }

    @Generated
    public Boolean getOriginal() {
        return this.original;
    }

    @Generated
    public String getRecover() {
        return this.recover;
    }

    @Generated
    public String getTargetServer() {
        return this.targetServer;
    }

    @Generated
    public String getVerify() {
        return this.verify;
    }

    @Generated
    public Boolean getRename() {
        return this.rename;
    }

    @Generated
    public RestoreMode getMode() {
        return this.mode;
    }

    @Generated
    public RestoreOverwriteMode getOverwrite() {
        return this.overwrite;
    }

    @Generated
    public String getMediaPool() {
        return this.mediaPool;
    }

    @Generated
    public String getFollowUp() {
        return this.followUp;
    }

    @Generated
    public RestoreMode getRestoreMode() {
        return this.restoreMode;
    }

    @Generated
    public Long getEol() {
        return this.eol;
    }

    @Generated
    public Boolean getUseLastSuccessfulBackup() {
        return this.useLastSuccessfulBackup;
    }

    @Generated
    public Boolean getPathFlag() {
        return this.pathFlag;
    }

    @Generated
    public Boolean getDumpFlag() {
        return this.dumpFlag;
    }

    @Generated
    public String getTargetFolder() {
        return this.targetFolder;
    }

    @Generated
    public String getTargetResource() {
        return this.targetResource;
    }

    @Generated
    public String getTargetNetwork() {
        return this.targetNetwork;
    }

    @Generated
    public CryptFlagType getCryptFlag() {
        return this.cryptFlag;
    }

    @Generated
    public String getDataMover() {
        return this.dataMover;
    }

    @Generated
    public String getCryptKey() {
        return this.cryptKey;
    }

    @Generated
    public Schedules getSchedules() {
        return this.schedules;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(RestoreOptions type) {
        this.type = type;
    }

    @Generated
    public void setGenmode(Boolean genmode) {
        this.genmode = genmode;
    }

    @Generated
    public void setTreeType(RestoreTreeType treeType) {
        this.treeType = treeType;
    }

    @Generated
    public void setResult(Results result) {
        this.result = result;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setClient(Clients client) {
        this.client = client;
    }

    @Generated
    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    @Generated
    public void setIfaceName(String ifaceName) {
        this.ifaceName = ifaceName;
    }

    @Generated
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setSesamDate(Date sesamDate) {
        this.sesamDate = sesamDate;
    }

    @Generated
    public void setTask(String task) {
        this.task = task;
    }

    @Generated
    public void setCnt(Long cnt) {
        this.cnt = cnt;
    }

    @Generated
    public void setSelFile(String selFile) {
        this.selFile = selFile;
    }

    @Generated
    public void setTargetDatastore(String targetDatastore) {
        this.targetDatastore = targetDatastore;
    }

    @Generated
    public void setOriginal(Boolean original) {
        this.original = original;
    }

    @Generated
    public void setRecover(String recover) {
        this.recover = recover;
    }

    @Generated
    public void setTargetServer(String targetServer) {
        this.targetServer = targetServer;
    }

    @Generated
    public void setVerify(String verify) {
        this.verify = verify;
    }

    @Generated
    public void setRename(Boolean rename) {
        this.rename = rename;
    }

    @Generated
    public void setMode(RestoreMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setOverwrite(RestoreOverwriteMode overwrite) {
        this.overwrite = overwrite;
    }

    @Generated
    public void setMediaPool(String mediaPool) {
        this.mediaPool = mediaPool;
    }

    @Generated
    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    @Generated
    public void setEol(Long eol) {
        this.eol = eol;
    }

    @Generated
    public void setUseLastSuccessfulBackup(Boolean useLastSuccessfulBackup) {
        this.useLastSuccessfulBackup = useLastSuccessfulBackup;
    }

    @Generated
    public void setPathFlag(Boolean pathFlag) {
        this.pathFlag = pathFlag;
    }

    @Generated
    public void setDumpFlag(Boolean dumpFlag) {
        this.dumpFlag = dumpFlag;
    }

    @Generated
    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    @Generated
    public void setTargetResource(String targetResource) {
        this.targetResource = targetResource;
    }

    @Generated
    public void setTargetNetwork(String targetNetwork) {
        this.targetNetwork = targetNetwork;
    }

    @Generated
    public void setCryptFlag(CryptFlagType cryptFlag) {
        this.cryptFlag = cryptFlag;
    }

    @Generated
    public void setDataMover(String dataMover) {
        this.dataMover = dataMover;
    }

    @Generated
    public void setCryptKey(String cryptKey) {
        this.cryptKey = cryptKey;
    }

    @Generated
    public void setSchedules(Schedules schedules) {
        this.schedules = schedules;
    }

    @Generated
    public RestoreDto() {
    }
}

