/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.MigrationEvents;
import de.sep.sesam.model.MigrationTasks;
import de.sep.sesam.model.Schedules;
import de.sep.sesam.model.annotations.SesamParameter;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.dto.EventsScheduleParamDto;
import de.sep.sesam.model.type.MigrationCfdiType;
import de.sep.sesam.model.type.ReferenceType;
import de.sep.sesam.model.type.RelativeDate;
import de.sep.sesam.model.type.StateType;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class MigrateDto
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = -1510126971935259113L;
    @SesamParameter(shortFields={"@"}, description="Model.Description.FollowUpEvent")
    private String followUp;
    @SesamParameter(shortFields={"f"}, description="Model.Dto.MigrateDto.Description.SubmitFlag")
    private Boolean submitFlag;
    @SesamParameter(shortFields={"R"}, target="name", description="Model.Dto.MigrateDto.Description.MigrationTask")
    private MigrationTasks migrationTask;
    @SesamParameter(shortFields={"B"}, description="Model.Description.DateStart")
    private RelativeDate dateStart;
    @SesamParameter(shortFields={"E"}, description="Model.Description.DateEnd")
    private RelativeDate dateEnd;
    @SesamParameter(shortFields={"p"}, description="Model.Dto.MigrateDto.Description.Priority")
    private Long priority;
    @SesamParameter(shortFields={"s"}, description="Model.Dto.MigrateDto.Description.Saveset")
    private String saveset;
    private Boolean grpflag;
    @SesamParameter(shortFields={"r"}, description="Model.Dto.MigrateDto.Description.DeleteFlag")
    private String deleteFlag;
    @SesamParameter(shortFields={"m"}, description="Model.Dto.MigrateDto.Description.SourcePool")
    private String sourcePool;
    @NotNull
    @SesamParameter(shortFields={"M"}, description="Model.Dto.MigrateDto.Description.TargetPool")
    private String targetPool;
    @SesamParameter(shortFields={"j"}, description="Model.Dto.MigrateDto.Description.Task")
    private String task;
    @SesamParameter(shortFields={"G", "J"}, description="Model.Description.TaskGroup")
    private String taskGroup;
    @SesamParameter(shortFields={"n"}, description="Model.Dto.MigrateDto.Description.SavesetCnt")
    private Long savesetCnt;
    @SesamParameter(shortFields={"c"}, description="Model.Dto.MigrateDto.Description.Client")
    private String client;
    @SesamParameter(shortFields={"d"}, description="Model.Dto.MigrateDto.Description.SourceDrive")
    private Long sourceDrive;
    @SesamParameter(shortFields={"D"}, description="Model.Dto.MigrateDto.Description.TargetDrive")
    private Long targetDrive;
    @SesamParameter(shortFields={"S"}, description="Model.Description.Interface")
    private String ifaceName;
    @SesamParameter(shortFields={"T"}, description="Model.Description.SourceInterface")
    private String sourceIfaceName;
    @Length(max=255)
    @SesamParameter(shortFields={"v"}, description="Model.Dto.MigrateDto.Description.DataMover")
    private @Length(max=255) String dataMover;
    @SesamParameter(shortFields={"i"}, description="Model.Dto.MigrateDto.Description.Usercomment")
    private String usercomment;
    @SesamParameter(shortFields={"l"}, description="Model.Description.CfdiType", defaultValue="CFDI")
    private MigrationCfdiType cfdiType;
    @SesamParameter(shortFields={"e"}, description="Model.Dto.MigrateDto.Description.BackupState")
    private StateType backupState;
    @SesamParameter(shortFields={"L"}, description="Model.Dto.MigrateDto.Description.Media")
    private String mediaLabel;
    @SesamParameter(shortFields={"a"}, description="Model.Dto.MigrateDto.Description.AbsoluteFlag", defaultValue="true")
    private Boolean absoluteFlag;
    @SesamParameter(shortFields={"F"}, description="Model.Dto.MigrateDto.Description.MigratedFlag")
    private Boolean migratedFlag;
    @SesamParameter(shortFields={"C"}, description="Model.Dto.MigrateDto.Description.MigrationCmd", hidden=true)
    private String migrationCmd;
    @Length(max=255)
    @SesamParameter(shortFields={"O"}, description="Model.MigrationTasks.Description.Options")
    private @Length(max=255) String options;
    @SesamParameter(shortFields={"A"}, description="Model.Dto.MigrateDto.Description.RestartId")
    private String restartId;
    @SesamParameter(shortFields={"z"}, description="Cli.MigrateParams.Description.Duration")
    private String duration;
    @SesamParameter(shortFields={"Z"}, description="Cli.MigrateParams.Description.LifeTime")
    private String lifetime;
    private String scheduleName;
    private EventsScheduleParamDto scheduleParams;

    public MigrationTasks toMigrationTask() {
        MigrationTasks migrationTasks = new MigrationTasks();
        migrationTasks.setSourcePool(this.sourcePool);
        migrationTasks.setTargetPool(this.targetPool);
        migrationTasks.setTask(this.task);
        migrationTasks.setTaskGroup(this.taskGroup);
        migrationTasks.setSavesetCnt(this.savesetCnt);
        migrationTasks.setClient(this.client);
        migrationTasks.setSourceDrive(this.sourceDrive);
        migrationTasks.setTargetDrive(this.targetDrive);
        migrationTasks.setIfaceName(this.ifaceName);
        migrationTasks.setSourceIfaceName(this.sourceIfaceName);
        migrationTasks.setUsercomment(this.usercomment);
        migrationTasks.setCfdiType(this.cfdiType);
        migrationTasks.setBackupState(this.backupState);
        migrationTasks.setMediaLabel(this.mediaLabel);
        migrationTasks.setAbsoluteFlag(this.absoluteFlag);
        migrationTasks.setDeleteFlag(this.deleteFlag);
        migrationTasks.setMigratedFlag(this.migratedFlag);
        migrationTasks.setMigrationCmd(this.migrationCmd);
        migrationTasks.setOptions(this.options);
        migrationTasks.setSaveset(this.saveset);
        migrationTasks.setSubmitFlag(this.submitFlag);
        return migrationTasks;
    }

    public MigrationEvents toMigrationEvent() {
        MigrationEvents migrationEvents = new MigrationEvents();
        migrationEvents.setMigrationTask(this.migrationTask != null ? this.migrationTask.getName() : null);
        migrationEvents.setFollowUp(this.followUp);
        migrationEvents.setSubmitFlag(this.submitFlag);
        migrationEvents.setOptions(this.options);
        migrationEvents.setDateStart(this.dateStart);
        migrationEvents.setDateEnd(this.dateEnd);
        migrationEvents.setSaveset(this.saveset);
        migrationEvents.setGrpflag(this.grpflag);
        migrationEvents.setDeleteFlag(null);
        if (this.migrationTask != null && this.migrationTask.getDeleteFlag() != null) {
            String mTaskDeleteFlag = this.migrationTask.getDeleteFlag();
            if (this.deleteFlag != null && !this.deleteFlag.equals(mTaskDeleteFlag)) {
                migrationEvents.setDeleteFlag(this.deleteFlag);
            }
        } else if (StringUtils.isNotBlank(this.deleteFlag)) {
            migrationEvents.setDeleteFlag(this.deleteFlag);
        }
        migrationEvents.setTargetDrive(this.targetDrive);
        if (this.migrationTask != null && this.targetDrive == null && this.migrationTask.getTargetDrive() != null) {
            migrationEvents.setTargetDrive(0L);
        }
        migrationEvents.setTargetPool(this.targetPool);
        if (this.migrationTask != null && StringUtils.isBlank(this.targetPool) && this.migrationTask.getTargetPool() != null) {
            migrationEvents.setTargetPool("*");
        }
        migrationEvents.setTask(this.task);
        if (this.migrationTask != null && StringUtils.isBlank(this.task) && this.migrationTask.getTask() != null) {
            migrationEvents.setTask("*");
        }
        migrationEvents.setTaskGroup(this.taskGroup);
        if (this.migrationTask != null && StringUtils.isBlank(this.taskGroup) && this.migrationTask.getTaskGroup() != null) {
            migrationEvents.setTaskGroup("*");
        }
        migrationEvents.setClient(this.client);
        if (this.migrationTask != null && StringUtils.isBlank(this.client) && this.migrationTask.getClient() != null) {
            migrationEvents.setClient("*");
        }
        if (this.getSavesetCnt() != null) {
            migrationEvents.setSavesetCnt(this.getSavesetCnt());
        }
        if (StringUtils.isNotBlank(this.getIfaceName())) {
            migrationEvents.setIfaceName(this.getIfaceName());
        }
        migrationEvents.setDataMoverId(null);
        migrationEvents.setDataMover(this.dataMover);
        if (this.getMigratedFlag() != null) {
            migrationEvents.setMigratedFlag(this.getMigratedFlag());
        }
        if (this.getAbsoluteFlag() != null) {
            migrationEvents.setAbsoluteFlag(this.getAbsoluteFlag());
        }
        if (this.getCfdiType() != null) {
            migrationEvents.setCfdiType(this.getCfdiType());
        }
        if (this.getBackupState() != null) {
            migrationEvents.setState(this.getBackupState());
        }
        if (StringUtils.isNotBlank(this.getMediaLabel())) {
            migrationEvents.setMediaLabel(this.getMediaLabel());
        }
        if (this.getUsercomment() != null) {
            migrationEvents.setUsercomment(this.getUsercomment());
        }
        if (this.getSubmitFlag() != null) {
            migrationEvents.setSubmitFlag(this.getSubmitFlag());
        }
        if (this.getPriority() != null) {
            migrationEvents.setPriority(this.getPriority());
        }
        if (StringUtils.isNotBlank(this.getRestartId())) {
            migrationEvents.setReferenceType(ReferenceType.RESTART);
            migrationEvents.setReferenceId(this.getRestartId());
        }
        migrationEvents.setScheduleName(this.getScheduleName());
        migrationEvents.setScheduleParams(this.getScheduleParams());
        return migrationEvents;
    }

    public void fillFromMigrationEvent(MigrationEvents migrationEvent) {
        if (migrationEvent == null) {
            return;
        }
        this.setTargetPool(migrationEvent.getTargetPool());
        this.setTargetDrive(migrationEvent.getTargetDrive());
        this.setIfaceName(migrationEvent.getIfaceName());
        this.setDataMover(migrationEvent.getDataMover());
        this.setAbsoluteFlag(migrationEvent.getAbsoluteFlag());
        this.setDateStart(migrationEvent.getDateStart());
        this.setDateEnd(migrationEvent.getDateEnd());
        this.setSavesetCnt(migrationEvent.getSavesetCnt());
        this.setCfdiType(migrationEvent.getCfdiType());
        this.setGrpflag(migrationEvent.getGrpflag());
        this.setTask(migrationEvent.getTask());
        this.setTaskGroup(migrationEvent.getTaskGroup());
        this.setClient(migrationEvent.getClient());
        this.setMigratedFlag(migrationEvent.getMigratedFlag());
        this.setDeleteFlag(migrationEvent.getDeleteFlag());
        this.setMediaLabel(migrationEvent.getMediaLabel());
        this.setSaveset(migrationEvent.getSaveset());
        this.setUsercomment(migrationEvent.getUsercomment());
        this.setFollowUp(migrationEvent.getFollowUp());
        this.setSubmitFlag(migrationEvent.getSubmitFlag());
        if (ReferenceType.RESTART.equals((Object)migrationEvent.getReferenceType()) && StringUtils.isNotBlank(migrationEvent.getReferenceId())) {
            this.setRestartId(migrationEvent.getReferenceId());
        } else {
            this.setRestartId(null);
        }
        this.setScheduleParams(migrationEvent.getScheduleParams());
    }

    public void fillFromMigrationTask(MigrationTasks migrationTask) {
        if (migrationTask == null) {
            return;
        }
        this.setSourcePool(migrationTask.getSourcePool());
        this.setSourceDrive(migrationTask.getSourceDrive());
        this.setBackupState(migrationTask.getBackupState());
        this.setSourceIfaceName(migrationTask.getSourceIfaceName());
    }

    public void fillFromSchedule(Schedules schedule) {
        if (schedule == null) {
            return;
        }
        EventsScheduleParamDto params = this.getScheduleParams();
        if (params == null) {
            params = new EventsScheduleParamDto();
            this.setScheduleParams(params);
        }
        params.setDuration(schedule.getDuration());
        params.setLifeTime(schedule.getLifeTime());
        params.setStartDate(schedule.getStartDate());
        params.setStartTime(schedule.getStartTime());
        params.setEndDate(schedule.getEndDate());
        params.setEndTime(schedule.getEndTime());
    }

    @Generated
    public String getFollowUp() {
        return this.followUp;
    }

    @Generated
    public Boolean getSubmitFlag() {
        return this.submitFlag;
    }

    @Generated
    public MigrationTasks getMigrationTask() {
        return this.migrationTask;
    }

    @Generated
    public RelativeDate getDateStart() {
        return this.dateStart;
    }

    @Generated
    public RelativeDate getDateEnd() {
        return this.dateEnd;
    }

    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public String getSaveset() {
        return this.saveset;
    }

    @Generated
    public Boolean getGrpflag() {
        return this.grpflag;
    }

    @Generated
    public String getDeleteFlag() {
        return this.deleteFlag;
    }

    @Generated
    public String getSourcePool() {
        return this.sourcePool;
    }

    @Generated
    public String getTargetPool() {
        return this.targetPool;
    }

    @Generated
    public String getTask() {
        return this.task;
    }

    @Generated
    public String getTaskGroup() {
        return this.taskGroup;
    }

    @Generated
    public Long getSavesetCnt() {
        return this.savesetCnt;
    }

    @Generated
    public String getClient() {
        return this.client;
    }

    @Generated
    public Long getSourceDrive() {
        return this.sourceDrive;
    }

    @Generated
    public Long getTargetDrive() {
        return this.targetDrive;
    }

    @Generated
    public String getIfaceName() {
        return this.ifaceName;
    }

    @Generated
    public String getSourceIfaceName() {
        return this.sourceIfaceName;
    }

    @Generated
    public String getDataMover() {
        return this.dataMover;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public MigrationCfdiType getCfdiType() {
        return this.cfdiType;
    }

    @Generated
    public StateType getBackupState() {
        return this.backupState;
    }

    @Generated
    public String getMediaLabel() {
        return this.mediaLabel;
    }

    @Generated
    public Boolean getAbsoluteFlag() {
        return this.absoluteFlag;
    }

    @Generated
    public Boolean getMigratedFlag() {
        return this.migratedFlag;
    }

    @Generated
    public String getMigrationCmd() {
        return this.migrationCmd;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public String getRestartId() {
        return this.restartId;
    }

    @Generated
    public String getDuration() {
        return this.duration;
    }

    @Generated
    public String getLifetime() {
        return this.lifetime;
    }

    @Generated
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Generated
    public EventsScheduleParamDto getScheduleParams() {
        return this.scheduleParams;
    }

    @Generated
    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    @Generated
    public void setSubmitFlag(Boolean submitFlag) {
        this.submitFlag = submitFlag;
    }

    @Generated
    public void setMigrationTask(MigrationTasks migrationTask) {
        this.migrationTask = migrationTask;
    }

    @Generated
    public void setDateStart(RelativeDate dateStart) {
        this.dateStart = dateStart;
    }

    @Generated
    public void setDateEnd(RelativeDate dateEnd) {
        this.dateEnd = dateEnd;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setSaveset(String saveset) {
        this.saveset = saveset;
    }

    @Generated
    public void setGrpflag(Boolean grpflag) {
        this.grpflag = grpflag;
    }

    @Generated
    public void setDeleteFlag(String deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    @Generated
    public void setSourcePool(String sourcePool) {
        this.sourcePool = sourcePool;
    }

    @Generated
    public void setTargetPool(String targetPool) {
        this.targetPool = targetPool;
    }

    @Generated
    public void setTask(String task) {
        this.task = task;
    }

    @Generated
    public void setTaskGroup(String taskGroup) {
        this.taskGroup = taskGroup;
    }

    @Generated
    public void setSavesetCnt(Long savesetCnt) {
        this.savesetCnt = savesetCnt;
    }

    @Generated
    public void setClient(String client) {
        this.client = client;
    }

    @Generated
    public void setSourceDrive(Long sourceDrive) {
        this.sourceDrive = sourceDrive;
    }

    @Generated
    public void setTargetDrive(Long targetDrive) {
        this.targetDrive = targetDrive;
    }

    @Generated
    public void setIfaceName(String ifaceName) {
        this.ifaceName = ifaceName;
    }

    @Generated
    public void setSourceIfaceName(String sourceIfaceName) {
        this.sourceIfaceName = sourceIfaceName;
    }

    @Generated
    public void setDataMover(String dataMover) {
        this.dataMover = dataMover;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setCfdiType(MigrationCfdiType cfdiType) {
        this.cfdiType = cfdiType;
    }

    @Generated
    public void setBackupState(StateType backupState) {
        this.backupState = backupState;
    }

    @Generated
    public void setMediaLabel(String mediaLabel) {
        this.mediaLabel = mediaLabel;
    }

    @Generated
    public void setAbsoluteFlag(Boolean absoluteFlag) {
        this.absoluteFlag = absoluteFlag;
    }

    @Generated
    public void setMigratedFlag(Boolean migratedFlag) {
        this.migratedFlag = migratedFlag;
    }

    @Generated
    public void setMigrationCmd(String migrationCmd) {
        this.migrationCmd = migrationCmd;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setRestartId(String restartId) {
        this.restartId = restartId;
    }

    @Generated
    public void setDuration(String duration) {
        this.duration = duration;
    }

    @Generated
    public void setLifetime(String lifetime) {
        this.lifetime = lifetime;
    }

    @Generated
    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    @Generated
    public void setScheduleParams(EventsScheduleParamDto scheduleParams) {
        this.scheduleParams = scheduleParams;
    }
}

