/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.Accounts;
import de.sep.sesam.model.annotations.SesamParameter;
import de.sep.sesam.model.dto.ServerFileListDto;
import de.sep.sesam.model.type.SslOption;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.sf.oval.constraint.NotNull;

@Schema(description="Mailer")
public class MailerDto
implements Serializable {
    @JsonIgnore
    private static final long serialVersionUID = -5173192785763208749L;
    @Schema(description="The account to use for sending the mail.")
    private Accounts account;
    @NotNull
    @SesamParameter(shortFields={"m"}, description="Model.Accounts.Description.Message")
    @Schema(description="The message to send.", example="Hello World!")
    private String message;
    @NotNull
    @SesamParameter(shortFields={"s"}, description="Model.Accounts.Description.Subject")
    @Schema(description="The subject of the mail.", example="the subject")
    private String subject;
    @SesamParameter(shortFields={"t"}, description="Model.Accounts.Description.MailTo")
    @Schema(description="The mail address to send the mail to.", example="<EMAIL>")
    private String mailTo;
    @SesamParameter(shortFields={"f"}, description="Model.Accounts.Description.SmtpEmailAddress")
    @Schema(description="Email address of the sender that appears in the FROM field of the sent email.", example="<EMAIL>")
    private String smtpEmailAddress;
    @SesamParameter(shortFields={"h"}, description="Model.Accounts.Description.SmtpServer")
    @Schema(description="The SMTP server to use for sending the mail.", example="smtp.example.com")
    private String smtpServer;
    @SesamParameter(shortFields={"p"}, description="Model.Accounts.Description.SmtpPort")
    @Schema(description="The SMTP port to use for sending the mail.", example="25")
    private Long smtpPort;
    @SesamParameter(shortFields={"S"}, description="Model.Accounts.Description.SslOptions")
    @Schema(description="The SSL options to use for sending the mail.", example="TLS")
    private SslOption sslOptions;
    @SesamParameter(shortFields={"U"}, description="Model.Accounts.Description.MailUsername")
    @Schema(description="Name of the user to connect to the SMTP server.", example="username")
    private String mailUsername;
    @JsonIgnore
    @SesamParameter(shortFields={"P"}, description="Model.Accounts.Description.MailPassword")
    @Schema(description="Password of the user to connect to the SMTP server.", example="<PASSWORD>")
    private String clearMailPassword;
    @Schema(description="Encrypted password of the user to connect to the SMTP server.", example="<PASSWORD>")
    private String mailPassword;
    @SesamParameter(shortFields={"c"}, description="Model.Accounts.Description.MailCc")
    @Schema(description="Additional email addresses to send emails to, using CC function.", example="<EMAIL>")
    private String mailCc;
    @SesamParameter(shortFields={"b"}, description="Model.Accounts.Description.MailBcc")
    @Schema(description="Additional email addresses to send emails to, using BCC function.", example="<EMAIL>,<EMAIL>,<EMAIL>")
    private String mailBcc;
    @SesamParameter(shortFields={"Z"}, description="Model.Accounts.Description.Compress", defaultValue="true", cliCommandType={"send"})
    @Schema(description="Compress the mail message.", example="true")
    private Boolean compressAttachment;
    @Schema(description="Attachments")
    private List<ServerFileListDto> attachments = new ArrayList<ServerFileListDto>();
    @JsonIgnore
    @Schema(description="Attachments uploaded by the user")
    private transient Map<String, byte[]> uploadedFiles;
    @Schema(description="The message file to send")
    private ServerFileListDto messageFile;

    public Accounts toAccount() {
        Accounts account = new Accounts();
        account.setMailTo(this.mailTo);
        account.setMailCc(this.mailCc);
        account.setMailBcc(this.mailBcc);
        account.setSmtpEmailAddress(this.smtpEmailAddress);
        account.setSmtpServer(this.smtpServer);
        account.setMailUsername(this.mailUsername);
        account.setMailPassword(this.mailPassword);
        account.setSslOptions(this.sslOptions);
        account.setSmtpPort(this.smtpPort);
        return account;
    }

    @Generated
    public void setAccount(Accounts account) {
        this.account = account;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }

    @Generated
    public void setSmtpEmailAddress(String smtpEmailAddress) {
        this.smtpEmailAddress = smtpEmailAddress;
    }

    @Generated
    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    @Generated
    public void setSmtpPort(Long smtpPort) {
        this.smtpPort = smtpPort;
    }

    @Generated
    public void setSslOptions(SslOption sslOptions) {
        this.sslOptions = sslOptions;
    }

    @Generated
    public void setMailUsername(String mailUsername) {
        this.mailUsername = mailUsername;
    }

    @JsonIgnore
    @Generated
    public void setClearMailPassword(String clearMailPassword) {
        this.clearMailPassword = clearMailPassword;
    }

    @Generated
    public void setMailPassword(String mailPassword) {
        this.mailPassword = mailPassword;
    }

    @Generated
    public void setMailCc(String mailCc) {
        this.mailCc = mailCc;
    }

    @Generated
    public void setMailBcc(String mailBcc) {
        this.mailBcc = mailBcc;
    }

    @Generated
    public void setCompressAttachment(Boolean compressAttachment) {
        this.compressAttachment = compressAttachment;
    }

    @Generated
    public void setAttachments(List<ServerFileListDto> attachments) {
        this.attachments = attachments;
    }

    @JsonIgnore
    @Generated
    public void setUploadedFiles(Map<String, byte[]> uploadedFiles) {
        this.uploadedFiles = uploadedFiles;
    }

    @Generated
    public void setMessageFile(ServerFileListDto messageFile) {
        this.messageFile = messageFile;
    }

    @Generated
    public Accounts getAccount() {
        return this.account;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public String getMailTo() {
        return this.mailTo;
    }

    @Generated
    public String getSmtpEmailAddress() {
        return this.smtpEmailAddress;
    }

    @Generated
    public String getSmtpServer() {
        return this.smtpServer;
    }

    @Generated
    public Long getSmtpPort() {
        return this.smtpPort;
    }

    @Generated
    public SslOption getSslOptions() {
        return this.sslOptions;
    }

    @Generated
    public String getMailUsername() {
        return this.mailUsername;
    }

    @Generated
    public String getClearMailPassword() {
        return this.clearMailPassword;
    }

    @Generated
    public String getMailPassword() {
        return this.mailPassword;
    }

    @Generated
    public String getMailCc() {
        return this.mailCc;
    }

    @Generated
    public String getMailBcc() {
        return this.mailBcc;
    }

    @Generated
    public Boolean getCompressAttachment() {
        return this.compressAttachment;
    }

    @Generated
    public List<ServerFileListDto> getAttachments() {
        return this.attachments;
    }

    @Generated
    public Map<String, byte[]> getUploadedFiles() {
        return this.uploadedFiles;
    }

    @Generated
    public ServerFileListDto getMessageFile() {
        return this.messageFile;
    }
}

