/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.annotations.SesamParameter;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.types.SMLoaderAction;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import net.sf.oval.constraint.NotNull;

@Schema(description="Hardware loader action")
public class HwLoadersExActionDto
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = -2535893422327237044L;
    @NotNull
    @Schema(description="The loader action to execute.", example="E")
    private SMLoaderAction action;
    @NotNull
    @Schema(description="The unique ID of the loader to execute the loader action for.", example="1")
    private Long id;
    @SesamParameter(shortFields={"s"}, description="Cli.HwLoaderParams.Description.Action.Slot")
    @Schema(description="The loader slot to use.", example="1")
    private String slot;
    @SesamParameter(shortFields={"d"}, description="Cli.HwLoaderParams.Description.Action.DriveNum", cliCommandType={"load", "unload"})
    @Schema(description="The number of the loader drive to use. Valid only if the loader action is either \u2018LOAD\u2019\nor \u2018UNLOAD\u2019.", example="1")
    private Long driveNum;
    @SesamParameter(shortFields={"p"}, description="Cli.HwLoaderParams.Description.Action.Port", cliCommandType={"import", "export"})
    @Schema(description="The loader port range to use. Valid only if the loader action is either \u2018IMPORT\u2019 or\n\u2018EXPORT\u2019.", example="1-10")
    private String port;

    @Generated
    public SMLoaderAction getAction() {
        return this.action;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getSlot() {
        return this.slot;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public void setAction(SMLoaderAction action) {
        this.action = action;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSlot(String slot) {
        this.slot = slot;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setPort(String port) {
        this.port = port;
    }

    @Generated
    public HwLoadersExActionDto() {
    }
}

