/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import java.io.File;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public final class FileContentDto {
    private File file;
    private String fileName;
    private long length;
    private long lastModified;
    private String content;
    private byte[] byteContent;
    private final HashSet<File> deleteOnCompletion = new HashSet();

    public FileContentDto(File file) {
        assert (file != null);
        this.file = file;
        this.length = file.length();
        this.lastModified = file.lastModified();
    }

    public File getFile() {
        return this.file;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFilename() {
        return StringUtils.isNotBlank(this.fileName) ? this.fileName : this.file.getName();
    }

    public void setFilename(String fileName) {
        this.fileName = fileName;
    }

    public HashSet<File> getDeleteOnCompletion() {
        return this.deleteOnCompletion.isEmpty() ? null : this.deleteOnCompletion;
    }

    public void addDeleteOnCompletion(File file) {
        assert (file != null);
        this.deleteOnCompletion.add(file);
    }

    public byte[] getByteContent() {
        return this.byteContent;
    }

    public void setByteContent(byte[] byteContent) {
        this.byteContent = byteContent;
    }
}

