/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.HwDrives;
import de.sep.sesam.model.MigrationEvents;
import de.sep.sesam.model.RestoreEvents;
import de.sep.sesam.model.TaskEvents;
import de.sep.sesam.model.core.AbstractEventsEntity;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.type.EventType;
import lombok.Generated;

public class EventInfoDto
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = 1020618462962631918L;
    @JsonIgnore
    private AbstractEventsEntity event;
    private String displayName;
    private Long id;
    private EventType type;
    private String object;
    private String iface;
    private String driveLabel;
    private String scheduleName;

    public EventInfoDto(RestoreEvents event, HwDrives drive) {
        assert (event != null);
        this.event = event;
        this.displayName = "restoreEvent '" + event.getId() + "'";
        this.id = event.getId();
        this.iface = event.getIfaceName();
        this.driveLabel = drive != null ? drive.getDisplayLabel() : null;
        this.scheduleName = event.getScheduleName();
        this.object = event.getObjectLabel();
        this.type = EventType.RESTORE;
    }

    public EventInfoDto(MigrationEvents event, HwDrives drive) {
        assert (event != null);
        this.event = event;
        this.displayName = "migrationEvent '" + event.getId() + "'";
        this.id = event.getId();
        this.iface = event.getIfaceName();
        this.driveLabel = drive != null ? drive.getDisplayLabel() : null;
        this.scheduleName = event.getScheduleName();
        this.object = event.getObjectLabel();
        this.type = EventType.MIGRATION;
    }

    public EventInfoDto(TaskEvents event, HwDrives drive) {
        assert (event != null);
        this.event = event;
        this.displayName = "taskEvent '" + event.getId() + "'";
        this.id = event.getId();
        this.iface = event.getIfaceName();
        this.driveLabel = drive != null ? drive.getDisplayLabel() : null;
        this.scheduleName = event.getScheduleName();
        this.object = event.getObjectLabel();
        this.type = EventType.TASK;
    }

    public AbstractEventsEntity getEvent() {
        if (this.event == null) {
            switch (this.type) {
                case RESTORE: {
                    this.event = new RestoreEvents();
                    this.event.setId(this.id);
                    ((RestoreEvents)this.event).setName(this.displayName);
                    break;
                }
                case MIGRATION: {
                    this.event = new MigrationEvents();
                    this.event.setId(this.id);
                    ((MigrationEvents)this.event).setName(this.displayName);
                    break;
                }
                case TASK: {
                    this.event = new TaskEvents();
                    this.event.setId(this.id);
                    ((TaskEvents)this.event).setName(this.displayName);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return this.event;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public EventType getType() {
        return this.type;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getIface() {
        return this.iface;
    }

    @Generated
    public String getDriveLabel() {
        return this.driveLabel;
    }

    @Generated
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setType(EventType type) {
        this.type = type;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setIface(String iface) {
        this.iface = iface;
    }

    @Generated
    public void setDriveLabel(String driveLabel) {
        this.driveLabel = driveLabel;
    }

    @Generated
    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    @Generated
    public EventInfoDto() {
    }
}

