/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.sep.sesam.model.Clients;
import de.sep.sesam.model.TaskTypes;
import de.sep.sesam.model.core.AbstractSerializableObject;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

@JsonDeserialize(builder=DatamoverForClientDtoBuilder.class)
@Schema(description="Datamover for client dto")
public class DatamoverForClientDto
extends AbstractSerializableObject {
    private static final long serialVersionUID = 6034197104869525707L;
    @Schema(description="The client.", example="{\n  \"id\": 207,\n  \"name\": \"win-client-01.sep.de\",\n  \"location\": {\n    \"id\": 5,\n    \"name\": \"Hauptstandort\",\n    \"displayLabel\": \"Hauptstandort\"\n  },\n  \"operSystem\": {\n    \"name\": \"Windows\",\n    \"platform\": \"WINDOWS\"\n  },\n  \"netProt\": \"CTRL\",\n  \"macAddress\": \"00:1A:2B:3C:4D:5E\",\n  \"accessmode\": \"CTRL\",\n  \"usercomment\": \"Wichtiger Windows Client im Hauptstandort.\",\n  \"wolFlag\": true,\n  \"updateMode\": \"AUTOMATIC\",\n  \"userName\": \"backup_user\",\n  \"password\": \"<password_placeholder>\",\n  \"osUser\": \"administrator\",\n  \"osPassword\": \"<os_password_placeholder>\",\n  \"stpdPort\": 11301,\n  \"stpdOptions\": \"-s\",\n  \"sbcVersion\": \"5.1.0.14\",\n  \"jarVersion\": \"5.1.0.14-1\"\n}\n", requiredMode=Schema.RequiredMode.REQUIRED)
    private Clients client;
    @Schema(description="The task types.", example="{\n  \"pk\": {\n    \"name\": \"path\",\n    \"platform\": \"all\"\n  },\n  \"name\": \"path\",\n  \"displayName\": \"Filesystem\",\n  \"shortName\": \"path\",\n  \"backupCmd\": \"sbc\",\n  \"backupOptions\": \"-b -s @-\",\n  \"restoreCmd\": \"sbc\",\n  \"restoreOptions\": \"-r\",\n  \"platform\": \"all\",\n  \"operSystems\": \"all\",\n  \"isHypervisor\": false,\n  \"proxy\": \"U\",\n  \"interpreter\": \"NONE\",\n  \"backupExtern\": false,\n  \"restoreExtern\": false,\n  \"restoreAsPath\": true,\n  \"restoreOnline\": true,\n  \"restorePlain\": true,\n  \"restoreRecover\": false,\n  \"restoreReloc\": true,\n  \"restoreSelective\": true,\n  \"restoreStart\": false,\n  \"sepcomment\": \"Standard filesystem backup for all platforms. Used for backing up files and directories.\"\n}", requiredMode=Schema.RequiredMode.REQUIRED)
    private TaskTypes taskType;

    @Generated
    public static DatamoverForClientDtoBuilder builder() {
        return new DatamoverForClientDtoBuilder();
    }

    @Generated
    public Clients getClient() {
        return this.client;
    }

    @Generated
    public TaskTypes getTaskType() {
        return this.taskType;
    }

    @Generated
    public DatamoverForClientDto() {
    }

    @Generated
    public DatamoverForClientDto(Clients client, TaskTypes taskType) {
        this.client = client;
        this.taskType = taskType;
    }

    @Generated
    public static class DatamoverForClientDtoBuilder {
        @Generated
        private Clients client;
        @Generated
        private TaskTypes taskType;

        @Generated
        DatamoverForClientDtoBuilder() {
        }

        @Generated
        public DatamoverForClientDtoBuilder withClient(Clients client) {
            this.client = client;
            return this;
        }

        @Generated
        public DatamoverForClientDtoBuilder withTaskType(TaskTypes taskType) {
            this.taskType = taskType;
            return this;
        }

        @Generated
        public DatamoverForClientDto build() {
            return new DatamoverForClientDto(this.client, this.taskType);
        }

        @Generated
        public String toString() {
            return "DatamoverForClientDto.DatamoverForClientDtoBuilder(client=" + this.client + ", taskType=" + this.taskType + ")";
        }
    }
}

