/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.Clients;
import de.sep.sesam.model.CommandEvents;
import de.sep.sesam.model.HwDrives;
import de.sep.sesam.model.HwLoaders;
import de.sep.sesam.model.RestoreTasks;
import de.sep.sesam.model.Schedules;
import de.sep.sesam.model.Tasks;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.interfaces.IEntity;
import de.sep.sesam.model.dto.EventInfoDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public final class ClientReferenceDto
extends AbstractSerializableObject {
    private static final long serialVersionUID = 4101123826803432073L;
    private List<Clients> clients;
    private List<HwLoaders> hwLoaders;
    private List<HwDrives> hwDrives;
    private List<Tasks> tasks;
    private List<RestoreTasks> restoreTasks;
    private List<CommandEvents> commandEvents;
    private List<EventInfoDto> events;
    private List<Schedules> schedules;
    private boolean hasDataMoverReferences;

    @JsonIgnore
    public boolean isReferenced() {
        return this.clients != null && !this.clients.isEmpty() || this.hwLoaders != null && !this.hwLoaders.isEmpty() || this.hwDrives != null && !this.hwDrives.isEmpty() || this.tasks != null && !this.tasks.isEmpty() || this.restoreTasks != null && !this.restoreTasks.isEmpty() || this.commandEvents != null && !this.commandEvents.isEmpty() || this.events != null && !this.events.isEmpty() || this.schedules != null && !this.schedules.isEmpty();
    }

    @JsonIgnore
    public Collection<? extends IEntity<?>> getEntities() {
        ArrayList<AbstractModelEntity> result = new ArrayList<AbstractModelEntity>();
        if (CollectionUtils.isNotEmpty(this.clients)) {
            result.addAll(this.clients);
        }
        if (CollectionUtils.isNotEmpty(this.hwLoaders)) {
            result.addAll(this.hwLoaders);
        }
        if (CollectionUtils.isNotEmpty(this.hwDrives)) {
            result.addAll(this.hwDrives);
        }
        if (CollectionUtils.isNotEmpty(this.tasks)) {
            result.addAll(this.tasks);
        }
        if (CollectionUtils.isNotEmpty(this.restoreTasks)) {
            result.addAll(this.restoreTasks);
        }
        if (CollectionUtils.isNotEmpty(this.commandEvents)) {
            result.addAll(this.commandEvents);
        }
        if (CollectionUtils.isNotEmpty(this.events)) {
            result.addAll(this.events.stream().filter(e -> e.getEvent() != null).map(e -> e.getEvent()).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(this.schedules)) {
            result.addAll(this.schedules);
        }
        return result;
    }

    @Generated
    public List<Clients> getClients() {
        return this.clients;
    }

    @Generated
    public List<HwLoaders> getHwLoaders() {
        return this.hwLoaders;
    }

    @Generated
    public List<HwDrives> getHwDrives() {
        return this.hwDrives;
    }

    @Generated
    public List<Tasks> getTasks() {
        return this.tasks;
    }

    @Generated
    public List<RestoreTasks> getRestoreTasks() {
        return this.restoreTasks;
    }

    @Generated
    public List<CommandEvents> getCommandEvents() {
        return this.commandEvents;
    }

    @Generated
    public List<EventInfoDto> getEvents() {
        return this.events;
    }

    @Generated
    public List<Schedules> getSchedules() {
        return this.schedules;
    }

    @Generated
    public boolean isHasDataMoverReferences() {
        return this.hasDataMoverReferences;
    }

    @Generated
    public void setClients(List<Clients> clients) {
        this.clients = clients;
    }

    @Generated
    public void setHwLoaders(List<HwLoaders> hwLoaders) {
        this.hwLoaders = hwLoaders;
    }

    @Generated
    public void setHwDrives(List<HwDrives> hwDrives) {
        this.hwDrives = hwDrives;
    }

    @Generated
    public void setTasks(List<Tasks> tasks) {
        this.tasks = tasks;
    }

    @Generated
    public void setRestoreTasks(List<RestoreTasks> restoreTasks) {
        this.restoreTasks = restoreTasks;
    }

    @Generated
    public void setCommandEvents(List<CommandEvents> commandEvents) {
        this.commandEvents = commandEvents;
    }

    @Generated
    public void setEvents(List<EventInfoDto> events) {
        this.events = events;
    }

    @Generated
    public void setSchedules(List<Schedules> schedules) {
        this.schedules = schedules;
    }

    @Generated
    public void setHasDataMoverReferences(boolean hasDataMoverReferences) {
        this.hasDataMoverReferences = hasDataMoverReferences;
    }

    @Generated
    public ClientReferenceDto() {
    }
}

