/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.datastores.utils;

import de.sep.sesam.model.formatter.ByteFormatter;
import de.sep.sesam.model.type.DataSizeFormats;
import java.text.DecimalFormat;

public final class DatastoresDataSizeUtil {
    private static final ByteFormatter byteFormatter = new ByteFormatter();

    public static double convertToBytes(Double valueGiB) {
        return valueGiB != null ? valueGiB * ByteFormatter.A_GIBI : 0.0;
    }

    public static String byteToString(double bytes, String dataSizeFormat) {
        DecimalFormat df = new DecimalFormat("####0.00");
        double absBytes = Math.abs(bytes);
        String value = null;
        value = DataSizeFormats.BINARY.name.equals(dataSizeFormat) ? (absBytes < ByteFormatter.A_TERABYTE ? byteFormatter.formatInGIBI(df, bytes, true) : byteFormatter.formatInTEBI(df, bytes, true)) : (absBytes < ByteFormatter.A_TERABYTE ? byteFormatter.formatInGigaBytes(df, bytes, true) : byteFormatter.formatInTeraBytes(df, bytes, true));
        return value;
    }

    public static Long byteToLong(double bytes, String dataSizeFormat) {
        if (DataSizeFormats.BINARY.name.equals(dataSizeFormat)) {
            return Math.round(bytes / ByteFormatter.A_GIBI);
        }
        return Math.round(bytes / ByteFormatter.A_GIGABYTE);
    }
}

