/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.utils;

import de.sep.sesam.model.core.interfaces.IBrowsableEntity;
import de.sep.sesam.model.core.types.BackupType;
import de.sep.sesam.model.core.types.OperatingSystemType;
import de.sep.sesam.model.core.types.VmServerType;
import lombok.Generated;

public final class BrowseableEntityUtils {
    public static boolean isVirtualizationHost(IBrowsableEntity entity) {
        boolean virtualizationHost = false;
        if (entity != null) {
            VmServerType serverType = entity.getVmServerType();
            OperatingSystemType osType = entity.getOperatingSystemType();
            if (serverType != null || osType != null) {
                virtualizationHost = VmServerType.CITRIX_HYPERVISOR.equals(serverType) || OperatingSystemType.CITRIX_XENSERVER.equals((Object)osType) || VmServerType.HYPER_V_SERVER.equals(serverType) || VmServerType.HYPER_V_CLUSTER.equals(serverType) || VmServerType.KVM_SERVER.equals(serverType) || VmServerType.NUTANIX.equals(serverType) || VmServerType.OPENNEBULA_SERVER.equals(serverType) || VmServerType.ORACLE_VM_SERVER.equals(serverType) || VmServerType.PROXMOX.equals(serverType) || VmServerType.RHV.equals(serverType) || VmServerType.V_CENTER.equals(serverType) || VmServerType.ESX_SERVER.equals(serverType) || OperatingSystemType.ESX_SERVER.equals((Object)osType);
            }
        }
        return virtualizationHost;
    }

    public static BackupType getBackupTypeForEntity(IBrowsableEntity entity) {
        BackupType type = null;
        if (entity != null && BrowseableEntityUtils.isVirtualizationHost(entity)) {
            VmServerType serverType = entity.getVmServerType();
            OperatingSystemType osType = entity.getOperatingSystemType();
            if (serverType != null || osType != null) {
                if (VmServerType.CITRIX_HYPERVISOR.equals(serverType) || OperatingSystemType.CITRIX_XENSERVER.equals((Object)osType)) {
                    type = BackupType.CITRIX_XEN_SERVER;
                } else if (VmServerType.HYPER_V_SERVER.equals(serverType) || VmServerType.HYPER_V_CLUSTER.equals(serverType)) {
                    type = BackupType.HYPERV;
                } else if (VmServerType.KVM_SERVER.equals(serverType)) {
                    type = BackupType.KVM_QEMU;
                } else if (VmServerType.NUTANIX.equals(serverType)) {
                    type = BackupType.NUTANIX;
                } else if (VmServerType.OPENNEBULA_SERVER.equals(serverType)) {
                    type = BackupType.OPEN_NEBULA;
                } else if (VmServerType.ORACLE_VM_SERVER.equals(serverType)) {
                    type = BackupType.ORACLE_VM;
                } else if (VmServerType.PROXMOX.equals(serverType)) {
                    type = BackupType.PROXMOX;
                } else if (VmServerType.RHV.equals(serverType)) {
                    type = BackupType.RHEV;
                } else if (VmServerType.V_CENTER.equals(serverType) || VmServerType.ESX_SERVER.equals(serverType) || OperatingSystemType.ESX_SERVER.equals((Object)osType)) {
                    type = BackupType.VM_WARE_VSPHERE;
                }
            }
        }
        return type;
    }

    @Generated
    private BrowseableEntityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

