/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.types;

import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import org.apache.commons.lang3.StringUtils;

public enum VmServerType implements IDisplayLabelProvider
{
    AZURE("Microsoft Azure"),
    CITRIX_HYPERVISOR("Citrix Hypervisor"),
    ESX_SERVER("ESX-Server"),
    HYPER_V_SERVER("Hyper-V-Server"),
    HYPER_V_CLUSTER("Hyper-V-Cluster"),
    KVM_SERVER("KVM Server"),
    NUTANIX("Nutanix-AHV"),
    OPENNEBULA_SERVER("OpenNebula Server"),
    ORACLE_VM_SERVER("Oracle-VM Server"),
    PROXMOX("Proxmox-VE"),
    RHV("RHV-Management-Server"),
    V_CENTER("vCenter"),
    NONE("");

    private final String vmServerType;

    private VmServerType(String vmServerType) {
        this.vmServerType = vmServerType;
    }

    public static VmServerType fromString(String s) {
        if (s == null) {
            return NONE;
        }
        if (StringUtils.equals(s = s.trim(), "RHEV-Management-Server")) {
            s = "RHV-Management-Server";
        }
        for (VmServerType st : VmServerType.values()) {
            if (!st.vmServerType.equalsIgnoreCase(s)) continue;
            return st;
        }
        return NONE;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return this.vmServerType;
    }

    @Override
    public String getDisplayLabel() {
        return this.vmServerType;
    }
}

