/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.types;

import org.apache.commons.lang3.StringUtils;

public enum StorageWizardType {
    CLOUD_STORAGE("Cloud storage"),
    IMMUTABLE_STORAGE("Immutable or read-only storage"),
    LOCAL_STORAGE("Local storage"),
    NETWORK_STORAGE("Network storage"),
    STORAGE_APPLIANCE("Storage appliance"),
    TAPE_STORAGE("Tape storage"),
    NONE("");

    private final String displayLabel;

    private StorageWizardType(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public static StorageWizardType fromString(String s) {
        if (StringUtils.isBlank(s)) {
            return NONE;
        }
        for (StorageWizardType t : StorageWizardType.values()) {
            if (!StringUtils.equalsIgnoreCase(s, t.displayLabel)) continue;
            return t;
        }
        return NONE;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return this.displayLabel;
    }
}

