/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.types;

import org.apache.commons.lang3.StringUtils;

public enum StorageWizardSubType {
    AMAZON_S3("Amazon S3 or compatible"),
    HPE_CBS("HPE Cloud Bank Store"),
    HPE_NIMBLE("HPE Nimble Storage"),
    HPE_SO("HPE StoreOnce"),
    IMMUTABLE("Immutable Storage"),
    LOCAL_FS("Local file system"),
    MS_AZURE("Microsoft Azure"),
    PURE("Pure Storage"),
    NETAPP_SNAP("NetApp Snap Storage"),
    READONLY("Read-only Storage"),
    SI3_DEDUP("Si3 Deduplication"),
    SI3_DEDUP_V1("Si3 V1 Deduplication"),
    NETWORK("Network share or NAS device"),
    WASABI("Wasabi Cloud Storage"),
    NONE("");

    private final String displayLabel;

    private StorageWizardSubType(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public static StorageWizardSubType fromString(String s) {
        if (StringUtils.isBlank(s)) {
            return NONE;
        }
        for (StorageWizardSubType t : StorageWizardSubType.values()) {
            if (!StringUtils.equalsIgnoreCase(s, t.displayLabel)) continue;
            return t;
        }
        return NONE;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return this.displayLabel;
    }
}

