/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.types;

import org.apache.commons.lang3.StringUtils;

public enum PowerStateType {
    off("poweredOff", "powered_off", "off", "offline", "stop", "stopped", "down", "not running", "Halted"),
    on("poweredOn", "powered_on", "on", "online", "up", "Running"),
    suspended("suspended"),
    standby("standby"),
    NONE("none", "_unknown");

    private final String[] val;

    private PowerStateType(String ... val) {
        this.val = val;
    }

    public static PowerStateType fromString(String s) {
        if (s == null) {
            return NONE;
        }
        s = s.trim();
        for (PowerStateType st : PowerStateType.values()) {
            if (st.name().equalsIgnoreCase(s)) {
                return st;
            }
            if (st.val == null || st.val.length <= 0) continue;
            for (String v : st.val) {
                if (!StringUtils.equalsIgnoreCase(s, v)) continue;
                return st;
            }
        }
        return NONE;
    }

    public String toString() {
        return StringUtils.equalsIgnoreCase(super.toString(), "NONE") ? "" : super.toString();
    }
}

