/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.types;

import org.apache.commons.lang3.StringUtils;

public enum OperatingSystemType {
    CITRIX_XENSERVER(true, false, false, "Citrix XenServer", "XenServer", "CitrixCenServer"),
    ESX_SERVER(false, false, false, "ESX-Server"),
    LINUX(true, true, true, "LINUX"),
    MARATHON_EVERRUN(true, false, false, "Marathon everRun"),
    NETWARE(false, false, false, "NETWARE"),
    OES_LINUX(true, false, true, "OES-Linux", "OES Linux"),
    UNIX(false, false, false, "UNIX"),
    NETAPP(true, false, false, "NetApp"),
    NDMP(true, false, false, "NDMP", "NETAPP", "EMC VNX", "Oracle ZFS"),
    VMS(false, false, false, "VMS"),
    OTHER(false, false, false, ""),
    MAC(false, false, false, "Mac OS X", "Mac OSX"),
    WINDOWS_XP(false, false, false, "Windows XP");

    private String[] names;
    private boolean netwareMode = false;
    private boolean novellOESFlag = false;
    private boolean lvmCapable = false;

    private OperatingSystemType(boolean netwareMode, boolean novellOESFlag, boolean canLVM, String ... names) {
        this.netwareMode = netwareMode;
        this.novellOESFlag = novellOESFlag;
        this.lvmCapable = canLVM;
        this.names = names;
    }

    public String toString() {
        return this.getTitle();
    }

    public String getTitle() {
        return this.names[0];
    }

    public boolean isNetwareMode() {
        return this.netwareMode;
    }

    public boolean hasNovellOESFlag() {
        return this.novellOESFlag;
    }

    public static OperatingSystemType fromString(String s) {
        if (StringUtils.isBlank(s)) {
            return OTHER;
        }
        s = s.trim();
        for (OperatingSystemType type : OperatingSystemType.values()) {
            for (String ts : type.names) {
                if (!ts.equalsIgnoreCase(s)) continue;
                return type;
            }
        }
        return OTHER;
    }

    public boolean isLvmCapable() {
        return this.lvmCapable;
    }
}

