/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import java.util.Comparator;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize(using=ToStringSerializer.class)
@JsonDeserialize(using=BackupTypeJsonDeserializer.class)
public enum BackupType {
    ABAS(null, false, "ABAS", "free", false),
    AZURE_VM(null, false, "Azure-VM", "azure_vm", true),
    BSR_WINDOWS("all", false, "BSR_Windows", "bsr_windows", true),
    CITRIX_XEN_SERVER("all", true, "Citrix XenServer", "xen_server_seats", true),
    COURIER_IMAP("Courier IMAP", "imap", true),
    CYRUS_IMAP("all", false, "Cyrus IMAP", "imap", true),
    DB2_UDB(null, false, "DB2_UDB", "db2_udb", false),
    DOVECOT_IMAP("Dovecot IMAP", "imap", true),
    EDIRECTORY(null, false, "eDirectory", "free", true),
    EXCHANGE_SERVER_2003(null, true, "Exchange Server 2003", "msexchange", true),
    EXCHANGE_SERVER_2007_2010("all", false, "Exchange Server", "msexchange", true),
    EXCHANGE_SERVER_2010("all", false, "Exchange Server 2010", "msexchange", true),
    EXCHANGE_SERVER_5_X(null, false, "Exchange Server 5.x", "msexchange", true),
    EXCHANGE_SERVER_DAG("all", false, "Exchange Server DAG", "msexchange", true),
    EXCHANGE_SERVER_SINGLE_MAILBOX(null, false, "Exchange Server Single Mailbox", "msexchange", true),
    GROUPWISE(null, false, "GroupWise", "groupwise", true),
    HYPERV("all", false, "Hyper-V", "hyper-v_seats", true),
    IFOLDER(null, false, "iFolder", "free", true),
    INFORMIX(null, false, "INFORMIX", "informix", false),
    INGRES(null, false, "Ingres", "ingres", false),
    JIRA(null, false, "JIRA", "jira", false),
    KOPANO("all", true, "Kopano", "zarafa", true),
    KVM_QEMU(null, false, "KVM-QEMU", "kvm_server_seats", true),
    LINUX_BSR("all", false, "Linux BSR", "bsr_linux", false),
    LOTUS_NOTES("all", false, "Lotus Notes", "lotus_notes", true),
    MARATHON_EVERRUN("Marathon everRun", null, false),
    MAX_DB(null, false, "MaxDB", "sap", false),
    MS_SQL_SERVER("all", true, "MS SQL Server", "sqlserver", true),
    MY_SQL("all", true, "MySQL", "mysql", true),
    NDMP(null, false, "NDMP", "ndmp", true),
    NET_APP(null, false, "NetApp", "netappclients", false),
    NETWARE(null, false, "NetWare", null, true),
    NONE(""),
    NUTANIX("Nutanix-AHV", "nutanix_server_seats", true),
    NSS_FILE_SYSTEM(null, true, "NSS File System", "free", true),
    OES_NOVELL_DIRECTORY(null, false, "OES Novell Directory", "free", false),
    OPEN_EXCHANGE_SERVER(null, false, "Open-Exchange Server", "ox", false),
    OPEN_NEBULA(null, false, "OpenNebula", "opennebula_server_seats", true),
    OPEN_LDAP(null, false, "OpenLDAP", "openldap", false),
    ORACLE(null, false, "ORACLE", "oracle_sids", false),
    ORACLE_VM(null, false, "Oracle-VM", "olvm_server_seats", true),
    PATH(null, false, "Path", "free", true),
    PATH_ALL(null, false, "Path#", "free", false),
    POSTGRESQL("all", true, "PostgreSQL", "postgresql", true),
    PROXMOX("Proxmox-VE", "proxmox_server_seats", true),
    RHEV(null, false, "RHEV", "rhev_server_seats", true),
    SAP_ASE(null, false, "SAP ASE", "sap_ase", false),
    SAP_R3(null, false, "SAP/R3", "sap", false),
    SAP_HANA(null, false, "SAP HANA", "sap", false),
    SCALIX(null, true, "Scalix", "scalix", false),
    SHAREPOINT_SERVER("/", false, "SharePoint Server", "mssharepointserver", false),
    SHAREPOINT_SITES("/", false, "SharePoint Sites", "MSSharePointServer", false),
    SUSE_LINUX_OPENEXCHANGE_SERVER("all", false, "SuSE Linux Openexchange Server", "free", false),
    SYSTEM_RECOVERY("all", false, "System Recovery", "free", false),
    SYSTEM_STATE(null, false, "System State", null, false),
    VM_WARE_VSPHERE(null, false, "VMware vSphere", "esx_server_seats", true),
    WIN32_UNICODE(null, false, "win32-unicode", null, false),
    ZARAFA("all", true, "Zarafa", "zarafa", false);

    private final String source;
    private final String backupType;
    private final String licenseKey;
    private final boolean removeSlashAtBeginningOfSource;
    private final boolean supportedByWebUI;
    @JsonIgnore
    private static final Comparator<BackupType> comparator;

    private BackupType(String source, boolean removeSlashAtBeginningOfSource, String backupType, String licenseKey, boolean isSupportedByWebUI) {
        this.source = source;
        this.backupType = backupType;
        this.licenseKey = licenseKey;
        this.removeSlashAtBeginningOfSource = removeSlashAtBeginningOfSource;
        this.supportedByWebUI = isSupportedByWebUI;
    }

    private BackupType(String backupType) {
        this.source = null;
        this.backupType = backupType;
        this.licenseKey = null;
        this.removeSlashAtBeginningOfSource = false;
        this.supportedByWebUI = false;
    }

    private BackupType(String backupType, String licenseKey, boolean isSupportedByWebUI) {
        this.source = null;
        this.backupType = backupType;
        this.licenseKey = licenseKey;
        this.removeSlashAtBeginningOfSource = false;
        this.supportedByWebUI = isSupportedByWebUI;
    }

    public static BackupType fromString(String s) {
        if (s == null) {
            return NONE;
        }
        if (StringUtils.equalsIgnoreCase(s, "AZURE")) {
            return AZURE_VM;
        }
        if (StringUtils.equalsIgnoreCase(s, "KVM")) {
            return KVM_QEMU;
        }
        if (StringUtils.equalsIgnoreCase(s, "ONE")) {
            return OPEN_NEBULA;
        }
        for (BackupType val : BackupType.values()) {
            if (!val.name().equalsIgnoreCase(s) && !val.backupType.equalsIgnoreCase(s)) continue;
            return val;
        }
        for (BackupType val : BackupType.values()) {
            if (!s.contains(val.name()) && !s.contains(val.backupType)) continue;
            return val;
        }
        return NONE;
    }

    public String toString() {
        if (this == NONE) {
            return "";
        }
        return this.backupType;
    }

    public String getTypeName() {
        return this.backupType;
    }

    public static BackupType checkTaskTypeAtTree(String path) {
        if (path.matches(".*iFolder Store.*")) {
            return IFOLDER;
        }
        if (path.matches(".*Linux File System.*")) {
            return NSS_FILE_SYSTEM;
        }
        if (path.matches(".*NetWare File System.*")) {
            return NSS_FILE_SYSTEM;
        }
        if (path.matches(".*Novell Directory.*") || path.matches(".*NetIQ Directory.*")) {
            return EDIRECTORY;
        }
        return null;
    }

    public boolean isExchangeServer() {
        return this.backupType.startsWith("Exchange Server");
    }

    public boolean isNetware() {
        return NETWARE.toString().equals(this.backupType) || IFOLDER.toString().equals(this.backupType) || NSS_FILE_SYSTEM.toString().equals(this.backupType) || EDIRECTORY.toString().equals(this.backupType) || GROUPWISE.toString().equals(this.backupType);
    }

    @JsonIgnore
    public boolean isVirtual() {
        return AZURE_VM.toString().equals(this.backupType) || CITRIX_XEN_SERVER.toString().equals(this.backupType) || HYPERV.toString().equals(this.backupType) || KVM_QEMU.toString().equals(this.backupType) || NUTANIX.toString().equals(this.backupType) || OPEN_NEBULA.toString().equals(this.backupType) || ORACLE_VM.toString().equals(this.backupType) || PROXMOX.toString().equals(this.backupType) || RHEV.toString().equals(this.backupType) || VM_WARE_VSPHERE.toString().equals(this.backupType);
    }

    @JsonIgnore
    public boolean isTaskBased() {
        return PATH.toString().equals(this.backupType) || KOPANO.toString().equals(this.backupType);
    }

    @JsonIgnore
    public static Comparator<BackupType> sorter() {
        return comparator;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getLicenseKey() {
        return this.licenseKey;
    }

    @Generated
    public boolean isRemoveSlashAtBeginningOfSource() {
        return this.removeSlashAtBeginningOfSource;
    }

    @Generated
    public boolean isSupportedByWebUI() {
        return this.supportedByWebUI;
    }

    static {
        comparator = (o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            if (o1 != null && o1.backupType == null && o2 != null && o2.backupType == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        };
    }

    public static class BackupTypeJsonDeserializer
    extends JsonDeserializer<BackupType> {
        @Override
        public BackupType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return BackupType.fromString(p.getText());
        }
    }
}

