/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;

public enum BackupSubType {
    BDA("_BDA"),
    CBT("_CBT"),
    CBS("_CBS"),
    CONFIG("_CONFIG"),
    EXCHANGE_2013("Exchange 2013"),
    IMAGE("_IMG"),
    LVM("_LVM"),
    MAIN("_MAIN"),
    NBD("_NBD"),
    RBD("_RBD"),
    RCT("_RCT"),
    SES("_SES"),
    VZD("_VZD"),
    ZFS("_ZFS"),
    ZFSBDA("_ZFSBDA"),
    NONE("");

    private final String backupSubType;

    private BackupSubType(String backupSubType) {
        this.backupSubType = backupSubType;
    }

    public static BackupSubType fromString(String s) {
        if (StringUtils.isBlank(s)) {
            return NONE;
        }
        for (BackupSubType val : BackupSubType.values()) {
            if (!StringUtils.equalsIgnoreCase(val.backupSubType, s)) continue;
            return val;
        }
        return NONE;
    }

    @JsonIgnore
    public String toString() {
        if (this == NONE) {
            return "";
        }
        return this.backupSubType;
    }
}

