/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.types.BrowserViewType;
import de.sep.sesam.model.core.types.VmServerType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(builder=BrowserFilterBuilder.class)
@Schema(description="The browser filter.")
public class BrowserFilter
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = 321827215536213889L;
    @Schema(description="The path to browse. The path contains the full root path, including\n\t * the client or remote virtualization server name, to browse. When\n\t * browsing the root level, some special marker might be used.", example="My Virtual Machine/backup type/path:/")
    private String path;
    @Schema(description="The browser view type.", example="DEFAULT")
    private BrowserViewType viewType;
    @Schema(description="The virtual server types to match.", example="[Microsoft Azure, ESX-Server]")
    private List<VmServerType> serverTypes;
    @Schema(description="The backup type to use for browsing if the path does not\n\t * contain the backup type itself.")
    private String backupType;
    @Schema(description="Additional backup type specific options to pass on to the 'sm_sho' command via\n\t * '-a &lt;backupTypeOptions&gt;'.")
    private String backupTypeOptions;
    @Schema(description="The name of the task to pass on to the 'sm_sho' command via '-j &lt;taskName&gt;'.\n\t * The task name or saveset ID can be specified when additional access information,\n\t * like user/password, are required.")
    private String taskName;
    @Schema(description="The ID of the saveset to pass on to the 'sm_sho' command via '-s &lt;taskName&gt;'.\n\t * The task name or saveset ID can be specified when additional access information,\n\t * like user/password, are required.", example="SI20250710064413361@i4fGHV1hpQk")
    private String savesetId;
    @Schema(description=" Flag to indicate that the path prefix (\"path:\") needs to be removed\n\t * from the path before executing the browse.", example="true")
    private Boolean filterPathPrefix;
    @Schema(description="Flag to indicate that the paths in the textual representation have to be prefixed\n\t * with the client name.", example="true")
    private Boolean prefixWithClient;
    @Schema(description="Force the use of the remote virtualization buffer.", example="true")
    private Boolean forceRemoteBuffer;
    @Schema(description="Flag to indicate that the remote buffer shall be refreshed before\n\t * getting the requested information.", example="true")
    private Boolean forceRefresh;
    @Schema(description="Flag to indicate if the browsing happens in restore mode.", example="true")
    private Boolean restoreMode;
    @Schema(description="Flag to indicate if the browsing should include \"disk free\" (df) information.", example="true")
    private Boolean diskFreeMode;
    @Schema(description="The credentials ID to use for authentication when browsing the client.", example="1234567890")
    private Long credentialsId;
    @Schema(description="The regular expression to match by the result item's name to get added to the result set.", example=".*")
    private String nameRegexIncludeFilter;
    @Schema(description="The regular expression to match by the result item's name to get removed from the result set.", example=".*")
    private String nameRegexExcludeFilter;
    @Schema(description=" The regular expression to match by any of the result item's additional attributes\n\t * to get included in the result set. Possible forms are: \"<key>=<value>\", \"<key>\" or \"<key regex>=<value regex>\".", example=".*")
    private String attributeRegexIncludeFilter;
    @Schema(description="Flag to indicate to include virtual machine objects only into the result set.", example="true")
    private Boolean includeVirtualMachinesOnly;
    @Schema(description="The regular expression to match by the result item's datacenter property to get added to the result set.", example=".*")
    private String vmDatacenterRegexIncludeFilter;
    @Schema(description="The regular expression to match by the result item's host system property to get added to the result set.", example=".*")
    private String vmHostSystemRegexIncludeFilter;
    @Schema(description="The regular expression to match by the result item's data store property to get added to the result set.", example=".*")
    private String vmDatastoreRegexIncludeFilter;
    @Schema(description="The regular expression to match by the result item's folder property to get added to the result set.", example=".*")
    private String vmFolderRegexIncludeFilter;
    @Schema(description="The regular expression to match by the result item's virtual application property to get added to the result set.", example=".*")
    private String vmVirtualAppRegexIncludeFilter;
    @Schema(description="The regular expression to match by the result item's power state property to get added to the result set.", example=".*")
    private String vmPowerStateRegexIncludeFilter;
    @Schema(description="The regular expression to match by the result item's operating system property to get added to the result set.", example=".*")
    private String vmOperSystemRegexIncludeFilter;
    @Schema(description="The regular expression to match by the result item's tags to get added to the result set.", example=".*")
    private String vmTagRegexIncludeFilter;
    @Schema(description="Flag to indicate if virtual machines without an existing backup\n\t * task are excluded from the result list or not.", example="true")
    private Boolean excludeVmsWithoutExistingTask;
    @Schema(description="Flag to indicate if virtual machines with an existing backup\n\t * task are excluded from the result list or not.")
    private Boolean excludeVmsWithExistingTask;
    @Schema(description="Flag to indicate if tasks, being associated with a no longer\n\t * existing virtual machine, will be included in the result list or not.", example="true")
    private Boolean includeTasksWithoutExistingVm;
    @Schema(description="Flag to indicate if tasks, being associated with an existing\n\t * virtual machine, will be added to the virtual machine result object.", example="true")
    private Boolean includeTasksForExistingVm;
    @Schema(description="Flag to indicate to list mount points only. Has effect only if browsing\n\t * the client file system (sm_cmd dir client -o mount ...).", example="true")
    private Boolean includeMountPointsOnly;
    @Schema(description="Flag to indicate if object tree will be walked recursively and all\n\t * objects found will be included in the result list. Has effect only\n\t * if supported by the backend.", example="true")
    private Boolean recursive;

    @Generated
    BrowserFilter(String path, BrowserViewType viewType, List<VmServerType> serverTypes, String backupType, String backupTypeOptions, String taskName, String savesetId, Boolean filterPathPrefix, Boolean prefixWithClient, Boolean forceRemoteBuffer, Boolean forceRefresh, Boolean restoreMode, Boolean diskFreeMode, Long credentialsId, String nameRegexIncludeFilter, String nameRegexExcludeFilter, String attributeRegexIncludeFilter, Boolean includeVirtualMachinesOnly, String vmDatacenterRegexIncludeFilter, String vmHostSystemRegexIncludeFilter, String vmDatastoreRegexIncludeFilter, String vmFolderRegexIncludeFilter, String vmVirtualAppRegexIncludeFilter, String vmPowerStateRegexIncludeFilter, String vmOperSystemRegexIncludeFilter, String vmTagRegexIncludeFilter, Boolean excludeVmsWithoutExistingTask, Boolean excludeVmsWithExistingTask, Boolean includeTasksWithoutExistingVm, Boolean includeTasksForExistingVm, Boolean includeMountPointsOnly, Boolean recursive) {
        this.path = path;
        this.viewType = viewType;
        this.serverTypes = serverTypes;
        this.backupType = backupType;
        this.backupTypeOptions = backupTypeOptions;
        this.taskName = taskName;
        this.savesetId = savesetId;
        this.filterPathPrefix = filterPathPrefix;
        this.prefixWithClient = prefixWithClient;
        this.forceRemoteBuffer = forceRemoteBuffer;
        this.forceRefresh = forceRefresh;
        this.restoreMode = restoreMode;
        this.diskFreeMode = diskFreeMode;
        this.credentialsId = credentialsId;
        this.nameRegexIncludeFilter = nameRegexIncludeFilter;
        this.nameRegexExcludeFilter = nameRegexExcludeFilter;
        this.attributeRegexIncludeFilter = attributeRegexIncludeFilter;
        this.includeVirtualMachinesOnly = includeVirtualMachinesOnly;
        this.vmDatacenterRegexIncludeFilter = vmDatacenterRegexIncludeFilter;
        this.vmHostSystemRegexIncludeFilter = vmHostSystemRegexIncludeFilter;
        this.vmDatastoreRegexIncludeFilter = vmDatastoreRegexIncludeFilter;
        this.vmFolderRegexIncludeFilter = vmFolderRegexIncludeFilter;
        this.vmVirtualAppRegexIncludeFilter = vmVirtualAppRegexIncludeFilter;
        this.vmPowerStateRegexIncludeFilter = vmPowerStateRegexIncludeFilter;
        this.vmOperSystemRegexIncludeFilter = vmOperSystemRegexIncludeFilter;
        this.vmTagRegexIncludeFilter = vmTagRegexIncludeFilter;
        this.excludeVmsWithoutExistingTask = excludeVmsWithoutExistingTask;
        this.excludeVmsWithExistingTask = excludeVmsWithExistingTask;
        this.includeTasksWithoutExistingVm = includeTasksWithoutExistingVm;
        this.includeTasksForExistingVm = includeTasksForExistingVm;
        this.includeMountPointsOnly = includeMountPointsOnly;
        this.recursive = recursive;
    }

    @Generated
    public static BrowserFilterBuilder builder() {
        return new BrowserFilterBuilder();
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public BrowserViewType getViewType() {
        return this.viewType;
    }

    @Generated
    public List<VmServerType> getServerTypes() {
        return this.serverTypes;
    }

    @Generated
    public String getBackupType() {
        return this.backupType;
    }

    @Generated
    public String getBackupTypeOptions() {
        return this.backupTypeOptions;
    }

    @Generated
    public String getTaskName() {
        return this.taskName;
    }

    @Generated
    public String getSavesetId() {
        return this.savesetId;
    }

    @Generated
    public Boolean getFilterPathPrefix() {
        return this.filterPathPrefix;
    }

    @Generated
    public Boolean getPrefixWithClient() {
        return this.prefixWithClient;
    }

    @Generated
    public Boolean getForceRemoteBuffer() {
        return this.forceRemoteBuffer;
    }

    @Generated
    public Boolean getForceRefresh() {
        return this.forceRefresh;
    }

    @Generated
    public Boolean getRestoreMode() {
        return this.restoreMode;
    }

    @Generated
    public Boolean getDiskFreeMode() {
        return this.diskFreeMode;
    }

    @Generated
    public Long getCredentialsId() {
        return this.credentialsId;
    }

    @Generated
    public String getNameRegexIncludeFilter() {
        return this.nameRegexIncludeFilter;
    }

    @Generated
    public String getNameRegexExcludeFilter() {
        return this.nameRegexExcludeFilter;
    }

    @Generated
    public String getAttributeRegexIncludeFilter() {
        return this.attributeRegexIncludeFilter;
    }

    @Generated
    public Boolean getIncludeVirtualMachinesOnly() {
        return this.includeVirtualMachinesOnly;
    }

    @Generated
    public String getVmDatacenterRegexIncludeFilter() {
        return this.vmDatacenterRegexIncludeFilter;
    }

    @Generated
    public String getVmHostSystemRegexIncludeFilter() {
        return this.vmHostSystemRegexIncludeFilter;
    }

    @Generated
    public String getVmDatastoreRegexIncludeFilter() {
        return this.vmDatastoreRegexIncludeFilter;
    }

    @Generated
    public String getVmFolderRegexIncludeFilter() {
        return this.vmFolderRegexIncludeFilter;
    }

    @Generated
    public String getVmVirtualAppRegexIncludeFilter() {
        return this.vmVirtualAppRegexIncludeFilter;
    }

    @Generated
    public String getVmPowerStateRegexIncludeFilter() {
        return this.vmPowerStateRegexIncludeFilter;
    }

    @Generated
    public String getVmOperSystemRegexIncludeFilter() {
        return this.vmOperSystemRegexIncludeFilter;
    }

    @Generated
    public String getVmTagRegexIncludeFilter() {
        return this.vmTagRegexIncludeFilter;
    }

    @Generated
    public Boolean getExcludeVmsWithoutExistingTask() {
        return this.excludeVmsWithoutExistingTask;
    }

    @Generated
    public Boolean getExcludeVmsWithExistingTask() {
        return this.excludeVmsWithExistingTask;
    }

    @Generated
    public Boolean getIncludeTasksWithoutExistingVm() {
        return this.includeTasksWithoutExistingVm;
    }

    @Generated
    public Boolean getIncludeTasksForExistingVm() {
        return this.includeTasksForExistingVm;
    }

    @Generated
    public Boolean getIncludeMountPointsOnly() {
        return this.includeMountPointsOnly;
    }

    @Generated
    public Boolean getRecursive() {
        return this.recursive;
    }

    @Generated
    public void setPrefixWithClient(Boolean prefixWithClient) {
        this.prefixWithClient = prefixWithClient;
    }

    @Generated
    public void setIncludeVirtualMachinesOnly(Boolean includeVirtualMachinesOnly) {
        this.includeVirtualMachinesOnly = includeVirtualMachinesOnly;
    }

    @Generated
    public static class BrowserFilterBuilder {
        @Generated
        private String path;
        @Generated
        private BrowserViewType viewType;
        @Generated
        private ArrayList<VmServerType> serverTypes;
        @Generated
        private String backupType;
        @Generated
        private String backupTypeOptions;
        @Generated
        private String taskName;
        @Generated
        private String savesetId;
        @Generated
        private Boolean filterPathPrefix;
        @Generated
        private Boolean prefixWithClient;
        @Generated
        private Boolean forceRemoteBuffer;
        @Generated
        private Boolean forceRefresh;
        @Generated
        private Boolean restoreMode;
        @Generated
        private Boolean diskFreeMode;
        @Generated
        private Long credentialsId;
        @Generated
        private String nameRegexIncludeFilter;
        @Generated
        private String nameRegexExcludeFilter;
        @Generated
        private String attributeRegexIncludeFilter;
        @Generated
        private Boolean includeVirtualMachinesOnly;
        @Generated
        private String vmDatacenterRegexIncludeFilter;
        @Generated
        private String vmHostSystemRegexIncludeFilter;
        @Generated
        private String vmDatastoreRegexIncludeFilter;
        @Generated
        private String vmFolderRegexIncludeFilter;
        @Generated
        private String vmVirtualAppRegexIncludeFilter;
        @Generated
        private String vmPowerStateRegexIncludeFilter;
        @Generated
        private String vmOperSystemRegexIncludeFilter;
        @Generated
        private String vmTagRegexIncludeFilter;
        @Generated
        private Boolean excludeVmsWithoutExistingTask;
        @Generated
        private Boolean excludeVmsWithExistingTask;
        @Generated
        private Boolean includeTasksWithoutExistingVm;
        @Generated
        private Boolean includeTasksForExistingVm;
        @Generated
        private Boolean includeMountPointsOnly;
        @Generated
        private Boolean recursive;

        @Generated
        BrowserFilterBuilder() {
        }

        @Generated
        public BrowserFilterBuilder withPath(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withViewType(BrowserViewType viewType) {
            this.viewType = viewType;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withServerType(VmServerType serverType) {
            if (this.serverTypes == null) {
                this.serverTypes = new ArrayList();
            }
            this.serverTypes.add(serverType);
            return this;
        }

        @Generated
        public BrowserFilterBuilder withServerTypes(Collection<? extends VmServerType> serverTypes) {
            if (serverTypes != null) {
                if (this.serverTypes == null) {
                    this.serverTypes = new ArrayList();
                }
                this.serverTypes.addAll(serverTypes);
            }
            return this;
        }

        @Generated
        public BrowserFilterBuilder clearServerTypes() {
            if (this.serverTypes != null) {
                this.serverTypes.clear();
            }
            return this;
        }

        @Generated
        public BrowserFilterBuilder withBackupType(String backupType) {
            this.backupType = backupType;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withBackupTypeOptions(String backupTypeOptions) {
            this.backupTypeOptions = backupTypeOptions;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withTaskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withSavesetId(String savesetId) {
            this.savesetId = savesetId;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withFilterPathPrefix(Boolean filterPathPrefix) {
            this.filterPathPrefix = filterPathPrefix;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withPrefixWithClient(Boolean prefixWithClient) {
            this.prefixWithClient = prefixWithClient;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withForceRemoteBuffer(Boolean forceRemoteBuffer) {
            this.forceRemoteBuffer = forceRemoteBuffer;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withForceRefresh(Boolean forceRefresh) {
            this.forceRefresh = forceRefresh;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withRestoreMode(Boolean restoreMode) {
            this.restoreMode = restoreMode;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withDiskFreeMode(Boolean diskFreeMode) {
            this.diskFreeMode = diskFreeMode;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withCredentialsId(Long credentialsId) {
            this.credentialsId = credentialsId;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withNameRegexIncludeFilter(String nameRegexIncludeFilter) {
            this.nameRegexIncludeFilter = nameRegexIncludeFilter;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withNameRegexExcludeFilter(String nameRegexExcludeFilter) {
            this.nameRegexExcludeFilter = nameRegexExcludeFilter;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withAttributeRegexIncludeFilter(String attributeRegexIncludeFilter) {
            this.attributeRegexIncludeFilter = attributeRegexIncludeFilter;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withIncludeVirtualMachinesOnly(Boolean includeVirtualMachinesOnly) {
            this.includeVirtualMachinesOnly = includeVirtualMachinesOnly;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withVmDatacenterRegexIncludeFilter(String vmDatacenterRegexIncludeFilter) {
            this.vmDatacenterRegexIncludeFilter = vmDatacenterRegexIncludeFilter;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withVmHostSystemRegexIncludeFilter(String vmHostSystemRegexIncludeFilter) {
            this.vmHostSystemRegexIncludeFilter = vmHostSystemRegexIncludeFilter;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withVmDatastoreRegexIncludeFilter(String vmDatastoreRegexIncludeFilter) {
            this.vmDatastoreRegexIncludeFilter = vmDatastoreRegexIncludeFilter;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withVmFolderRegexIncludeFilter(String vmFolderRegexIncludeFilter) {
            this.vmFolderRegexIncludeFilter = vmFolderRegexIncludeFilter;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withVmVirtualAppRegexIncludeFilter(String vmVirtualAppRegexIncludeFilter) {
            this.vmVirtualAppRegexIncludeFilter = vmVirtualAppRegexIncludeFilter;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withVmPowerStateRegexIncludeFilter(String vmPowerStateRegexIncludeFilter) {
            this.vmPowerStateRegexIncludeFilter = vmPowerStateRegexIncludeFilter;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withVmOperSystemRegexIncludeFilter(String vmOperSystemRegexIncludeFilter) {
            this.vmOperSystemRegexIncludeFilter = vmOperSystemRegexIncludeFilter;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withVmTagRegexIncludeFilter(String vmTagRegexIncludeFilter) {
            this.vmTagRegexIncludeFilter = vmTagRegexIncludeFilter;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withExcludeVmsWithoutExistingTask(Boolean excludeVmsWithoutExistingTask) {
            this.excludeVmsWithoutExistingTask = excludeVmsWithoutExistingTask;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withExcludeVmsWithExistingTask(Boolean excludeVmsWithExistingTask) {
            this.excludeVmsWithExistingTask = excludeVmsWithExistingTask;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withIncludeTasksWithoutExistingVm(Boolean includeTasksWithoutExistingVm) {
            this.includeTasksWithoutExistingVm = includeTasksWithoutExistingVm;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withIncludeTasksForExistingVm(Boolean includeTasksForExistingVm) {
            this.includeTasksForExistingVm = includeTasksForExistingVm;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withIncludeMountPointsOnly(Boolean includeMountPointsOnly) {
            this.includeMountPointsOnly = includeMountPointsOnly;
            return this;
        }

        @Generated
        public BrowserFilterBuilder withRecursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        @Generated
        public BrowserFilter build() {
            return new BrowserFilter(this.path, this.viewType, switch (this.serverTypes == null ? 0 : this.serverTypes.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.serverTypes.get(0));
                default -> Collections.unmodifiableList(new ArrayList<VmServerType>(this.serverTypes));
            }, this.backupType, this.backupTypeOptions, this.taskName, this.savesetId, this.filterPathPrefix, this.prefixWithClient, this.forceRemoteBuffer, this.forceRefresh, this.restoreMode, this.diskFreeMode, this.credentialsId, this.nameRegexIncludeFilter, this.nameRegexExcludeFilter, this.attributeRegexIncludeFilter, this.includeVirtualMachinesOnly, this.vmDatacenterRegexIncludeFilter, this.vmHostSystemRegexIncludeFilter, this.vmDatastoreRegexIncludeFilter, this.vmFolderRegexIncludeFilter, this.vmVirtualAppRegexIncludeFilter, this.vmPowerStateRegexIncludeFilter, this.vmOperSystemRegexIncludeFilter, this.vmTagRegexIncludeFilter, this.excludeVmsWithoutExistingTask, this.excludeVmsWithExistingTask, this.includeTasksWithoutExistingVm, this.includeTasksForExistingVm, this.includeMountPointsOnly, this.recursive);
        }

        @Generated
        public String toString() {
            return "BrowserFilter.BrowserFilterBuilder(path=" + this.path + ", viewType=" + this.viewType + ", serverTypes=" + this.serverTypes + ", backupType=" + this.backupType + ", backupTypeOptions=" + this.backupTypeOptions + ", taskName=" + this.taskName + ", savesetId=" + this.savesetId + ", filterPathPrefix=" + this.filterPathPrefix + ", prefixWithClient=" + this.prefixWithClient + ", forceRemoteBuffer=" + this.forceRemoteBuffer + ", forceRefresh=" + this.forceRefresh + ", restoreMode=" + this.restoreMode + ", diskFreeMode=" + this.diskFreeMode + ", credentialsId=" + this.credentialsId + ", nameRegexIncludeFilter=" + this.nameRegexIncludeFilter + ", nameRegexExcludeFilter=" + this.nameRegexExcludeFilter + ", attributeRegexIncludeFilter=" + this.attributeRegexIncludeFilter + ", includeVirtualMachinesOnly=" + this.includeVirtualMachinesOnly + ", vmDatacenterRegexIncludeFilter=" + this.vmDatacenterRegexIncludeFilter + ", vmHostSystemRegexIncludeFilter=" + this.vmHostSystemRegexIncludeFilter + ", vmDatastoreRegexIncludeFilter=" + this.vmDatastoreRegexIncludeFilter + ", vmFolderRegexIncludeFilter=" + this.vmFolderRegexIncludeFilter + ", vmVirtualAppRegexIncludeFilter=" + this.vmVirtualAppRegexIncludeFilter + ", vmPowerStateRegexIncludeFilter=" + this.vmPowerStateRegexIncludeFilter + ", vmOperSystemRegexIncludeFilter=" + this.vmOperSystemRegexIncludeFilter + ", vmTagRegexIncludeFilter=" + this.vmTagRegexIncludeFilter + ", excludeVmsWithoutExistingTask=" + this.excludeVmsWithoutExistingTask + ", excludeVmsWithExistingTask=" + this.excludeVmsWithExistingTask + ", includeTasksWithoutExistingVm=" + this.includeTasksWithoutExistingVm + ", includeTasksForExistingVm=" + this.includeTasksForExistingVm + ", includeMountPointsOnly=" + this.includeMountPointsOnly + ", recursive=" + this.recursive + ")";
        }
    }
}

