/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSchedulesEntity;
import de.sep.sesam.model.core.AbstractSerializableObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import lombok.Generated;

@Schema(description="The schedule parameter for the events service.")
public final class EventsScheduleParamDto
extends AbstractSerializableObject {
    private static final long serialVersionUID = -4723464532864886363L;
    @Schema(description="The start date of the schedule. If this field is set, the end date has to be NULL.", example="2020-01-01")
    private Date startDate;
    @Schema(description="The start time of the schedule. If this field is set, the end time has to be NULL.", example="12:00:00")
    private Date startTime;
    @Schema(description="The end date of the schedule. If this field is set, the start date has to be NULL.", example="2020-01-01")
    private Date endDate;
    @Schema(description="The end time of the schedule. If this field is set, the start time has to be NULL.", example="12:00:00")
    private Long endTime;
    @Schema(description="The life time of the schedule. If this field is set, the duration has to be NULL.", example="12:00:00")
    private Long lifeTime;
    @Schema(description="The duration of the schedule. If this field is set, the life time has to be NULL.", example="12:00:00")
    private Long duration;

    @JsonIgnore
    public boolean isEmpty() {
        return this.startDate == null && this.startTime == null && this.endDate == null && this.endTime == null && this.lifeTime == null && this.duration == null;
    }

    public void fillFromSchedule(AbstractSchedulesEntity<?> schedule) {
        if (schedule == null) {
            return;
        }
        this.setStartDate(schedule.getStartDate());
        this.setStartTime(schedule.getStartTime());
        this.setEndDate(schedule.getEndDate());
        this.setEndTime(schedule.getEndTime());
        this.setLifeTime(schedule.getLifeTime());
        this.setDuration(schedule.getDuration());
    }

    @Generated
    public Date getStartDate() {
        return this.startDate;
    }

    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getEndDate() {
        return this.endDate;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public Long getLifeTime() {
        return this.lifeTime;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Generated
    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setLifeTime(Long lifeTime) {
        this.lifeTime = lifeTime;
    }

    @Generated
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Generated
    public EventsScheduleParamDto() {
    }
}

