/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSerializableObject;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

@Schema(description="The DTO for updating a client.")
public class ClientUpdateDto
extends AbstractSerializableObject {
    private static final long serialVersionUID = 5876934394012270446L;
    @Schema(description="The name of the client to update.", example="Test-Client")
    private String clientName;
    @Schema(description="The id of the location to update the client to.", example="1")
    private Long locationId;
    @Schema(description="The operating system of the client to update.", example="Windows 10")
    private String os;
    @Schema(description="The alternate download location URL to use for the client update.", example="https://www.sep.de/de/?switchlang=1")
    private String url;
    @Schema(description="The SEP sesam package to install (applies when <code>install = true</code>)", example="sep-sesam-1.0.0.zip")
    private String sesamPackage;
    @Schema(description="Flag if or if not a package install shall be executed.", example="true")
    private Boolean install;
    @Schema(description="Flag if or if not a package uninstall shall be executed.", example="true")
    private Boolean uninstall;
    @Schema(description="Flag if or if not a package update shall be executed.", example="true")
    private Boolean update;
    @Schema(description="Flag if or if not a service pack update shall be executed.", example="true")
    private Boolean servicepacks;
    @Schema(description="Flag if or if not a UI server update shall be executed.", example="true")
    private Boolean uiserver;
    @Schema(description="Flag if or if not an add client shall be executed.", example="true")
    private Boolean addClient;
    @Schema(description="Flag if or if not a package or service pack update shall be forced.", example="true")
    private Boolean force;
    @Schema(description="Flag if or if not the SEP sesam service shall run as the configured user.", example="true")
    private Boolean runAsUser;
    @Schema(description="Flag if or if not the SEP sesam package with BSR package included (applies when <code>install = true</code>).", example="true")
    private Boolean withBsr;
    @Schema(description="Flag if or if not the SEP sesam package with the client package included (applies when <code>install = true</code>).", example="true")
    private Boolean withClient;
    @Schema(description="Flag if or if not the SEP sesam package with GUI package included (applies when <code>install = true</code>).", example="true")
    private Boolean withGui;
    @Schema(description="Flag if or if not a remote access check shall be performed.", example="true")
    private Boolean remoteAccessCheck;
    @Schema(description="Flag if or if not a sbc connection check shall be performed.", example="true")
    private Boolean sbcConnectionCheck;
    @Schema(description="Flag if or if not a update check shall be performed.", example="true")
    private Boolean updateCheck;
    @Schema(description="Flag if or if not the version information shall be fetched from the SEP download server.", example="true")
    private Boolean versionCheck;
    @Schema(description="Flag if or if not the client access key shall be synchronized with the server.", example="true")
    private Boolean setClient;
    @Schema(description="Flag if or if not the client status checks shall be executed synchronous.", example="true")
    private Boolean sync;
    @Schema(description="The timeout in seconds to wait for the command to finish (applies when <code>sync = true</code>).", example="120")
    private Long timeout;
    @Schema(description="The message to print as warning by the CLI.", example="The client is not connected to the SBC.")
    private String message;
    @JsonIgnore
    private String address;
    @JsonIgnore
    private String mode;
    @JsonIgnore
    private String sender;

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public Long getLocationId() {
        return this.locationId;
    }

    @Generated
    public String getOs() {
        return this.os;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getSesamPackage() {
        return this.sesamPackage;
    }

    @Generated
    public Boolean getInstall() {
        return this.install;
    }

    @Generated
    public Boolean getUninstall() {
        return this.uninstall;
    }

    @Generated
    public Boolean getUpdate() {
        return this.update;
    }

    @Generated
    public Boolean getServicepacks() {
        return this.servicepacks;
    }

    @Generated
    public Boolean getUiserver() {
        return this.uiserver;
    }

    @Generated
    public Boolean getAddClient() {
        return this.addClient;
    }

    @Generated
    public Boolean getForce() {
        return this.force;
    }

    @Generated
    public Boolean getRunAsUser() {
        return this.runAsUser;
    }

    @Generated
    public Boolean getWithBsr() {
        return this.withBsr;
    }

    @Generated
    public Boolean getWithClient() {
        return this.withClient;
    }

    @Generated
    public Boolean getWithGui() {
        return this.withGui;
    }

    @Generated
    public Boolean getRemoteAccessCheck() {
        return this.remoteAccessCheck;
    }

    @Generated
    public Boolean getSbcConnectionCheck() {
        return this.sbcConnectionCheck;
    }

    @Generated
    public Boolean getUpdateCheck() {
        return this.updateCheck;
    }

    @Generated
    public Boolean getVersionCheck() {
        return this.versionCheck;
    }

    @Generated
    public Boolean getSetClient() {
        return this.setClient;
    }

    @Generated
    public Boolean getSync() {
        return this.sync;
    }

    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @Generated
    public String getSender() {
        return this.sender;
    }

    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Generated
    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }

    @Generated
    public void setOs(String os) {
        this.os = os;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setSesamPackage(String sesamPackage) {
        this.sesamPackage = sesamPackage;
    }

    @Generated
    public void setInstall(Boolean install) {
        this.install = install;
    }

    @Generated
    public void setUninstall(Boolean uninstall) {
        this.uninstall = uninstall;
    }

    @Generated
    public void setUpdate(Boolean update) {
        this.update = update;
    }

    @Generated
    public void setServicepacks(Boolean servicepacks) {
        this.servicepacks = servicepacks;
    }

    @Generated
    public void setUiserver(Boolean uiserver) {
        this.uiserver = uiserver;
    }

    @Generated
    public void setAddClient(Boolean addClient) {
        this.addClient = addClient;
    }

    @Generated
    public void setForce(Boolean force) {
        this.force = force;
    }

    @Generated
    public void setRunAsUser(Boolean runAsUser) {
        this.runAsUser = runAsUser;
    }

    @Generated
    public void setWithBsr(Boolean withBsr) {
        this.withBsr = withBsr;
    }

    @Generated
    public void setWithClient(Boolean withClient) {
        this.withClient = withClient;
    }

    @Generated
    public void setWithGui(Boolean withGui) {
        this.withGui = withGui;
    }

    @Generated
    public void setRemoteAccessCheck(Boolean remoteAccessCheck) {
        this.remoteAccessCheck = remoteAccessCheck;
    }

    @Generated
    public void setSbcConnectionCheck(Boolean sbcConnectionCheck) {
        this.sbcConnectionCheck = sbcConnectionCheck;
    }

    @Generated
    public void setUpdateCheck(Boolean updateCheck) {
        this.updateCheck = updateCheck;
    }

    @Generated
    public void setVersionCheck(Boolean versionCheck) {
        this.versionCheck = versionCheck;
    }

    @Generated
    public void setSetClient(Boolean setClient) {
        this.setClient = setClient;
    }

    @Generated
    public void setSync(Boolean sync) {
        this.sync = sync;
    }

    @Generated
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    @Generated
    public void setAddress(String address) {
        this.address = address;
    }

    @JsonIgnore
    @Generated
    public void setMode(String mode) {
        this.mode = mode;
    }

    @JsonIgnore
    @Generated
    public void setSender(String sender) {
        this.sender = sender;
    }

    @Generated
    public ClientUpdateDto() {
    }
}

