/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.browser;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@Schema(description="A key/value pair for displaying in a list.")
public class LisInfoKeyValuePair
extends AbstractSerializableObject
implements IDisplayLabelProvider {
    @JsonIgnore
    private static final long serialVersionUID = -1294871675173059276L;
    @Schema(description="The key.", example="key")
    private String key;
    @Schema(description="The value.", example="value")
    private String value;
    @Schema(description="The label to display instead of the value.", example="label")
    private String label;
    @JsonIgnore
    private static final Comparator<LisInfoKeyValuePair> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getKey() == null && o2 != null && o2.getKey() == null) {
            return 0;
        }
        if (o1 == null || o1.getKey() == null) {
            return -1;
        }
        if (o2 == null || o2.getKey() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getKey().compareToIgnoreCase(o2.getKey()) : o1.getKey().compareTo(o2.getKey());
    };

    @JsonIgnore
    public static Comparator<LisInfoKeyValuePair> sorter() {
        return comparator;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank(this.key)) {
            sb.append(StringUtils.trim(this.key));
            if (StringUtils.isNotBlank(this.value) || this.value != null) {
                sb.append("=");
            }
            if (StringUtils.isNotBlank(this.value)) {
                sb.append(StringUtils.trim(StringUtils.isNotBlank(this.label) ? this.label : this.value));
            }
        }
        return !sb.isEmpty() ? sb.toString() : "";
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public LisInfoKeyValuePair() {
    }
}

