/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core.browser;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.date.HumanDate;
import de.sep.sesam.common.text.TextUtils;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.annotations.CompareIgnore;
import de.sep.sesam.model.core.browser.LisInfoKeyValuePair;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.types.BackupType;
import de.sep.sesam.model.core.types.PowerStateType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringTokenizer;

public final class LisInfo
extends AbstractSerializableObject
implements INamedEntity,
IDisplayLabelProvider {
    @JsonIgnore
    private static final long serialVersionUID = -5062382283554197703L;
    @JsonIgnore
    private static final Pattern diskFreePattern = Pattern.compile("df=([0-9.]+)/([0-9.]+)/([0-9.]+)/?([0-9.]+)?");
    @JsonIgnore
    private static final Pattern tasksPattern = Pattern.compile("tasks=\\[([^]]+)]");
    @JsonIgnore
    private static final Pattern powerStatePattern = Pattern.compile("powerState=([a-zA-Z_0-9 ]+)");
    @JsonIgnore
    private static final Pattern linuxMountPattern = Pattern.compile(".+\\son\\s(.+)\\stype\\s(.+)\\s\\((.+)\\)");
    @JsonIgnore
    private static final Pattern windowsMountPattern = Pattern.compile("(Device:\\s.+,\\s)volume:\\s([^,]+),\\s(.+)");
    @JsonIgnore
    private static final Comparator<LisInfo> comparator = (o1, o2) -> {
        boolean sortCaseInsensitive;
        if (o1 == o2 || o1 != null && o2 != null && StringUtils.isBlank(o1.getFullPath()) && StringUtils.isBlank(o2.getFullPath())) {
            return 0;
        }
        if (o1 == null || StringUtils.isBlank(o1.getFullPath())) {
            return -1;
        }
        if (o2 == null || StringUtils.isBlank(o2.getFullPath())) {
            return 1;
        }
        if (StringUtils.equalsAny(o1.getType(), "dd", "dH", "dD", "dA", "dC", "dR", "fN", "dv") || StringUtils.equalsAny(o2.getType(), "dd", "dH", "dD", "dA", "dC", "dR", "fN", "dv")) {
            if (StringUtils.equals(o1.getType(), "dd") && !StringUtils.equals(o2.getType(), "dd")) {
                return -1;
            }
            if (!StringUtils.equals(o1.getType(), "dd") && StringUtils.equals(o2.getType(), "dd")) {
                return 1;
            }
            if (StringUtils.equals(o1.getType(), "dC") && !StringUtils.equals(o2.getType(), "dC")) {
                return -1;
            }
            if (!StringUtils.equals(o1.getType(), "dC") && StringUtils.equals(o2.getType(), "dC")) {
                return 1;
            }
            if (StringUtils.equals(o1.getType(), "dH") && !StringUtils.equals(o2.getType(), "dH")) {
                return -1;
            }
            if (!StringUtils.equals(o1.getType(), "dH") && StringUtils.equals(o2.getType(), "dH")) {
                return 1;
            }
            if (StringUtils.equals(o1.getType(), "fN") && !StringUtils.equals(o2.getType(), "fN")) {
                return -1;
            }
            if (!StringUtils.equals(o1.getType(), "fN") && StringUtils.equals(o2.getType(), "fN")) {
                return 1;
            }
            if (StringUtils.equals(o1.getType(), "dD") && !StringUtils.equals(o2.getType(), "dD")) {
                return -1;
            }
            if (!StringUtils.equals(o1.getType(), "dD") && StringUtils.equals(o2.getType(), "dD")) {
                return 1;
            }
            if (StringUtils.equals(o1.getType(), "dR") && !StringUtils.equals(o2.getType(), "dR")) {
                return -1;
            }
            if (!StringUtils.equals(o1.getType(), "dR") && StringUtils.equals(o2.getType(), "dR")) {
                return 1;
            }
            if (StringUtils.equals(o1.getType(), "dA") && !StringUtils.equals(o2.getType(), "dA")) {
                return -1;
            }
            if (!StringUtils.equals(o1.getType(), "dA") && StringUtils.equals(o2.getType(), "dA")) {
                return 1;
            }
            if (StringUtils.equals(o1.getType(), "dv") && !StringUtils.equals(o2.getType(), "dv")) {
                return -1;
            }
            if (!StringUtils.equals(o1.getType(), "dv") && StringUtils.equals(o2.getType(), "dv")) {
                return 1;
            }
        }
        return (sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive")) ? o1.getFullPath().compareToIgnoreCase(o2.getFullPath()) : o1.getFullPath().compareTo(o2.getFullPath());
    };
    private String lisFileName;
    private String rawData;
    private String clientName;
    private Boolean prefixWithClient;
    private String name;
    private String type;
    private String path;
    private String parentPath;
    private String forcedParentPath;
    @JsonIgnore
    private volatile String lastModifiedDateString;
    @JsonIgnore
    private volatile String lastModifiedTimeString;
    @JsonIgnore
    private volatile String creationDateString;
    @JsonIgnore
    private volatile String creationTimeString;
    private Date created;
    private Date lastModified;
    private String segmentNum;
    private String startPos;
    private String endPos;
    private String infoData;
    private String diskFreeData;
    @JsonIgnore
    private volatile String sizeString;
    private Long size;
    private Double capacity;
    private Double free;
    private Double used;
    private Double usedPercent;
    private List<String> tasks;
    private BackupType backupType;
    @JsonIgnore
    private volatile List<LisInfoKeyValuePair> pairs;
    @JsonIgnore
    @CompareIgnore
    private final ReentrantLock lock = new ReentrantLock();
    @JsonIgnore
    private boolean isMountPath;

    @JsonIgnore
    public static Comparator<LisInfo> sorter() {
        return comparator;
    }

    public LisInfo(String lisFileName, String rawData) {
        this(lisFileName, rawData, null);
    }

    public LisInfo(String lisFileName, String rawData, String clientName) {
        this.setLisFileName(lisFileName);
        this.setClientName(clientName);
        if (StringUtils.isNotBlank(rawData)) {
            this.setRawData(rawData);
            this.parseAbsoluteName(this.getRawData());
            this.parseInfo(this.getRawData());
        }
    }

    private void parseAbsoluteName(String rawData) {
        if (StringUtils.isBlank(rawData)) {
            return;
        }
        String rd = StringUtils.trim(rawData);
        int beginIndex = StringUtils.indexOf((CharSequence)rd, "\"") + 1;
        int endIndex = StringUtils.indexOf((CharSequence)rd, "\"", beginIndex);
        if (beginIndex > 0 && endIndex > -1 && beginIndex < endIndex) {
            this.setPath(StringUtils.substring(rd, beginIndex, endIndex));
            this.parseParentPathAndName(this.getPath());
        }
        if (beginIndex == 0 && endIndex == -1 && this.isMountPath) {
            Matcher matcher = linuxMountPattern.matcher(rd);
            assert (matcher != null);
            if (matcher.matches()) {
                this.setPath(matcher.group(1));
                this.parseParentPathAndName(this.getPath());
                this.setType("dm");
                this.setInfoData((String)(StringUtils.isNotBlank(matcher.group(2)) ? "fstype=" + matcher.group(2) + (StringUtils.isNotBlank(matcher.group(3)) ? "," : "") : "") + (StringUtils.isNotBlank(matcher.group(3)) ? matcher.group(3) : ""));
            } else {
                matcher = windowsMountPattern.matcher(rd);
                assert (matcher != null);
                if (matcher.matches()) {
                    this.setPath(matcher.group(2));
                    this.parseParentPathAndName(this.getPath());
                    this.setType("dm");
                    String infoData = (StringUtils.isNotBlank(matcher.group(1)) ? matcher.group(1) : "") + (StringUtils.isNotBlank(matcher.group(3)) ? matcher.group(3) : "");
                    if (StringUtils.isNotBlank(infoData)) {
                        this.setInfoData(StringUtils.replace(StringUtils.replace(infoData, ", ", ","), ": ", "="));
                    }
                }
            }
        }
    }

    private void parseParentPathAndName(String path) {
        String prefix;
        BackupType bt;
        if (StringUtils.isBlank(path)) {
            return;
        }
        String name = StringUtils.removeEnd(StringUtils.replace(path, "\\", "/"), "/");
        int nameIndex = StringUtils.lastIndexOf((CharSequence)name, "/") + 1;
        if (nameIndex > 0) {
            String pp = StringUtils.substring(name, 0, nameIndex);
            this.setParentPath(pp);
            if (StringUtils.isNotBlank(pp) && StringUtils.contains((CharSequence)pp, ":") && !BackupType.NONE.equals((Object)(bt = BackupType.fromString(StringUtils.substringBefore(pp, ":"))))) {
                this.backupType = bt;
            }
        }
        if (nameIndex > 0) {
            name = StringUtils.substring(name, nameIndex);
        }
        if (StringUtils.isNotBlank(name) && StringUtils.contains((CharSequence)name, ":") && (bt = BackupType.fromString(prefix = StringUtils.substringBefore(name, ":"))) != null && !BackupType.NONE.equals((Object)bt)) {
            this.backupType = bt;
            String n = StringUtils.removeStart(StringUtils.substringAfter(name, ":"), "/");
            if (StringUtils.isNotBlank(n)) {
                name = n;
            }
        }
        this.setName(name);
    }

    private void parseInfo(String rawData) {
        String delim;
        int beginIndex;
        int parseStartPos;
        if (StringUtils.isBlank(rawData) || this.isMountPath) {
            return;
        }
        String rd = StringUtils.trim(rawData);
        int length = StringUtils.length(rd);
        if (length < (parseStartPos = StringUtils.indexOf((CharSequence)rd, "\"", beginIndex = StringUtils.indexOf((CharSequence)rd, "\"") + 1) + 2)) {
            return;
        }
        String stringToParse = StringUtils.substring(rd, parseStartPos);
        StringTokenizer st = new StringTokenizer(stringToParse, delim = " ");
        int tokensCount = st.size();
        if (tokensCount < 6) {
            return;
        }
        this.setType(st.nextToken());
        String s = st.nextToken();
        this.creationDateString = StringUtils.isNotBlank(s) && !"-".equals(s) ? s : "";
        s = st.nextToken();
        this.creationTimeString = StringUtils.isNotBlank(s) && !"-".equals(s) ? s : "";
        s = st.nextToken();
        this.lastModifiedDateString = StringUtils.isNotBlank(s) && !"-".equals(s) ? s : "";
        s = st.nextToken();
        this.lastModifiedTimeString = StringUtils.isNotBlank(s) && !"-".equals(s) ? s : "";
        boolean skipSegmentNum = false;
        if (StringUtils.isNotBlank(this.creationDateString) && "0".equals(this.creationDateString) && StringUtils.isNotBlank(this.creationTimeString) && "0".equals(this.creationTimeString) && StringUtils.isNotBlank(this.lastModifiedDateString) && "0".equals(this.lastModifiedDateString) && StringUtils.isBlank(this.lastModifiedTimeString)) {
            this.sizeString = this.lastModifiedDateString;
            this.creationDateString = null;
            this.creationTimeString = null;
            this.lastModifiedDateString = null;
            skipSegmentNum = true;
        }
        if (!skipSegmentNum) {
            String string = s = st.hasNext() ? st.nextToken() : "";
            if (StringUtils.isNotBlank(s) && !s.matches("-?[0-9]+")) {
                s = st.hasNext() ? st.nextToken() : "";
                s = st.hasNext() ? st.nextToken() : "";
            }
            String string2 = this.segmentNum = StringUtils.isNotBlank(s) && !"-".equals(s) ? s : "";
        }
        if (st.hasNext()) {
            boolean selFileMode;
            if (!skipSegmentNum) {
                s = st.nextToken();
                String string = this.startPos = StringUtils.isNotBlank(s) && !"-".equals(s) ? s : "";
                if (StringUtils.startsWith(this.startPos, ",")) {
                    this.endPos = this.startPos;
                } else {
                    s = st.hasNext() ? st.nextToken() : null;
                    this.endPos = StringUtils.isNotBlank(s) && !"-".equals(s) ? s : "";
                }
            }
            StringBuilder sb = new StringBuilder();
            boolean bl = selFileMode = StringUtils.isNotBlank(this.segmentNum) && this.segmentNum.matches("-?[0-9]+") && StringUtils.isNotBlank(this.startPos) && this.startPos.matches("-?[0-9]+") && StringUtils.isNotBlank(this.endPos) && this.endPos.matches("-?[0-9]+");
            if (selFileMode) {
                Long startPosLong = null;
                Long endPosLong = null;
                boolean v2 = false;
                if (st.hasNext()) {
                    String inode = st.getTokenList().get(st.nextIndex());
                    try {
                        Long.decode(inode);
                        v2 = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (v2) {
                    try {
                        this.size = Long.decode(this.endPos);
                    }
                    catch (NumberFormatException inode) {
                        // empty catch block
                    }
                    this.segmentNum = null;
                    this.startPos = null;
                    this.endPos = null;
                    st.next();
                    st.next();
                    st.next();
                } else {
                    try {
                        startPosLong = Long.decode(this.startPos);
                        endPosLong = Long.decode(this.endPos);
                    }
                    catch (NumberFormatException inode) {
                        // empty catch block
                    }
                    if (startPosLong != null && endPosLong != null) {
                        this.size = endPosLong - startPosLong;
                    }
                }
            } else {
                this.sizeString = this.segmentNum;
                sb.append(this.endPos);
                this.segmentNum = null;
                this.startPos = null;
                this.endPos = null;
            }
            while (st.hasNext()) {
                sb.append(" ");
                sb.append(st.nextToken());
            }
            String remainData = sb.toString().trim();
            Matcher matcher = diskFreePattern.matcher(remainData);
            if (matcher.find()) {
                block19: for (int i = 1; i <= 4; ++i) {
                    String value = null;
                    try {
                        value = matcher.group(i);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    Double doubleValue = null;
                    if (StringUtils.isNotBlank(value)) {
                        try {
                            doubleValue = Double.parseDouble(value);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (doubleValue == null) continue;
                    switch (i) {
                        case 1: {
                            this.capacity = doubleValue;
                            continue block19;
                        }
                        case 2: {
                            this.used = doubleValue;
                            continue block19;
                        }
                        case 3: {
                            this.free = doubleValue;
                            continue block19;
                        }
                        case 4: {
                            this.usedPercent = doubleValue;
                        }
                    }
                }
                this.setDiskFreeData(StringUtils.substring(remainData, matcher.start(), matcher.end()));
                String before = StringUtils.trim(StringUtils.removeEnd(StringUtils.substring(remainData, 0, matcher.start()), ","));
                String end = StringUtils.trim(StringUtils.removeStart(StringUtils.substring(remainData, matcher.end()), ","));
                remainData = StringUtils.removeEnd((StringUtils.isNotBlank(before) ? before : "") + "," + (StringUtils.isNotBlank(end) ? end : ""), ",");
            }
            if ((matcher = tasksPattern.matcher(remainData)).find()) {
                String value = null;
                try {
                    value = matcher.group(1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                if (StringUtils.isNotBlank(value)) {
                    this.setTasks(Arrays.asList(StringUtils.split(value, ',')));
                }
            }
            this.setInfoData(remainData);
            this.getCreated();
            this.getLastModified();
            this.getSize();
        }
    }

    public void setPath(String path) {
        this.path = TextUtils.unmaskListCharacters(StringEscapeUtils.unescapeHtml4(path));
        this.parseParentPathAndName(this.path);
    }

    @Override
    public String getName() {
        return StringUtils.replace(this.name, "%2f", "/");
    }

    @JsonIgnore
    public String getNormalizedName() {
        String n = this.getName();
        if (StringUtils.isBlank(n) || this.backupType == null && !StringUtils.contains((CharSequence)n, ":")) {
            return n;
        }
        String prefix = StringUtils.substringBefore(n, ":");
        BackupType bt = BackupType.fromString(prefix);
        if (BackupType.NONE.equals((Object)bt)) {
            return n;
        }
        return StringUtils.startsWith(n, prefix + ":") ? StringUtils.removeStart(n, prefix + ":") : n;
    }

    @JsonIgnore
    private String getFullPath() {
        Object p = this.getPath();
        if (StringUtils.isNotBlank(this.parentPath) && !StringUtils.startsWith((CharSequence)p, this.parentPath)) {
            p = StringUtils.trim(this.parentPath) + "/" + StringUtils.removeStart((String)p, "/");
        }
        if (this.isPrefixWithClient() && StringUtils.isNotBlank(this.clientName)) {
            p = "/" + StringUtils.trim(this.clientName) + "/" + StringUtils.removeStart((String)p, "/");
        }
        return p;
    }

    @JsonIgnore
    public static String getPathFromRawData(String rawData) {
        String path = null;
        if (StringUtils.isNotBlank(rawData)) {
            int beginIndex = StringUtils.indexOf((CharSequence)rawData, "\"") + 1;
            int endIndex = StringUtils.indexOf((CharSequence)rawData, "\"", beginIndex);
            if (beginIndex > 0 && endIndex > -1 && beginIndex < endIndex) {
                path = StringUtils.substring(rawData, beginIndex, endIndex);
            }
        }
        return StringUtils.replace(StringEscapeUtils.unescapeHtml4(path), "%2f", "/");
    }

    public String getType() {
        return StringUtils.isNotBlank(this.type) ? (this.type.length() >= 2 ? this.type : this.type + "_") : "  ";
    }

    @JsonIgnore
    private boolean isPrefixWithClient() {
        return this.prefixWithClient == null || this.prefixWithClient != false;
    }

    public void setRawData(String rawData) {
        PowerStateType powerState;
        String state;
        Matcher matcher;
        if (StringUtils.endsWith((CharSequence)rawData, "fN - - - -")) {
            rawData = (String)rawData + " 0 -";
        }
        if ((matcher = powerStatePattern.matcher((CharSequence)rawData)).find() && StringUtils.isNotBlank(state = matcher.group(1)) && !PowerStateType.NONE.equals((Object)(powerState = PowerStateType.fromString(state)))) {
            rawData = StringUtils.replace((String)rawData, matcher.group(0), "powerState=" + powerState.toString());
        }
        this.rawData = rawData;
        this.isMountPath = linuxMountPattern.matcher((CharSequence)rawData).matches() || windowsMountPattern.matcher((CharSequence)rawData).matches();
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        String[] parts;
        Object label = TextUtils.unmaskListCharacters(StringEscapeUtils.unescapeHtml4(this.getRawData()));
        if (!this.isMountPath && StringUtils.isNotBlank(this.parentPath) && !StringUtils.startsWith(StringUtils.replace((String)label, "\\", "/"), "\"" + this.parentPath)) {
            String p;
            label = StringUtils.removeStart((String)label, "\"");
            String pa = StringUtils.trim(this.parentPath);
            if (StringUtils.startsWithIgnoreCase(this.parentPath, "/NetWare") && StringUtils.isNotBlank(p = new File(StringUtils.substringBefore((String)label, "\"")).getParent())) {
                pa = StringUtils.removeEnd(StringUtils.removeEnd(pa, RegExUtils.replaceAll(p, "\\\\", "/")), "/");
            }
            label = "\"" + pa + "/" + StringUtils.removeStart((String)label, "/");
        }
        if (StringUtils.isNotBlank(this.forcedParentPath) && !StringUtils.startsWith(StringUtils.replace((String)label, "\\", "/"), "\"" + this.forcedParentPath)) {
            String lastSegment;
            String datastore;
            String separator;
            String labelWithoutInfoData;
            label = StringUtils.removeStart((String)label, "\"");
            String bt = null;
            if (BackupType.OPEN_NEBULA.equals((Object)this.backupType)) {
                bt = "ONE";
            } else if (BackupType.KVM_QEMU.equals((Object)this.backupType)) {
                bt = "KVM";
            } else if (BackupType.AZURE_VM.equals((Object)this.backupType)) {
                bt = "AZURE";
            } else if (this.backupType != null) {
                bt = this.backupType.toString();
            }
            if (StringUtils.isNotBlank(bt) && StringUtils.startsWithAny((CharSequence)label, bt + ":", "/" + bt + ":")) {
                label = StringUtils.removeStart(StringUtils.removeStart((String)label, "/"), bt + ":");
            }
            if (!StringUtils.contains((CharSequence)labelWithoutInfoData, separator = (StringUtils.contains((CharSequence)(labelWithoutInfoData = StringUtils.substringBefore((String)label, "- ,")), "/") ? "/" : "") + StringUtils.trim(this.name) + "\"") && StringUtils.isNotBlank(bt)) {
                separator = (StringUtils.contains((CharSequence)labelWithoutInfoData, "/") ? "/" : "") + bt + ":" + StringUtils.trim(this.name) + "\"";
            } else if (!StringUtils.contains((CharSequence)labelWithoutInfoData, separator) && StringUtils.isNotBlank(this.type)) {
                separator = StringUtils.trim(this.name) + "\" " + this.type + " ";
            }
            if (StringUtils.contains((CharSequence)label, separator)) {
                label = StringUtils.substringAfter((String)label, separator);
                if (StringUtils.endsWith(separator, "\" " + this.type + " ")) {
                    label = " " + this.type + " " + (String)label;
                }
            }
            if (StringUtils.isBlank(datastore = StringUtils.substringAfterLast(StringUtils.removeEnd(this.parentPath, "/"), "/")) || !datastore.matches("\\[[^]]+]\\s+.*")) {
                datastore = null;
            }
            String fpp = this.forcedParentPath;
            int indexLastSlash = StringUtils.lastIndexOf((CharSequence)fpp, "/");
            if (!StringUtils.endsWith(fpp, "/") && indexLastSlash > 0 && StringUtils.startsWith(this.name, lastSegment = StringUtils.substring(fpp, indexLastSlash + 1)) && StringUtils.endsWith(lastSegment, ":")) {
                fpp = StringUtils.substring(fpp, 0, indexLastSlash);
            }
            if (StringUtils.isNotBlank(bt) && (StringUtils.contains((CharSequence)fpp, bt + ":") || StringUtils.startsWith(this.name, bt + ":") || BackupType.VM_WARE_VSPHERE.equals((Object)this.backupType))) {
                bt = null;
            }
            label = "\"" + StringUtils.trim(StringUtils.removeEnd(fpp, "/")) + (StringUtils.isNotBlank(bt) && StringUtils.endsWith(fpp, bt + ":") ? "" : "/") + (String)(StringUtils.isNotBlank(datastore) ? StringUtils.trim(datastore) + "/" : "") + (BackupType.VM_WARE_VSPHERE.equals((Object)this.backupType) && StringUtils.equals(this.type, "dH") ? "ESX_HOST:/" : "") + (String)(StringUtils.isNotBlank(bt) ? bt + ":" : "") + StringUtils.trim(this.name) + "\"" + (String)label;
        }
        if (!this.isMountPath && this.isPrefixWithClient() && StringUtils.isNotBlank(this.clientName) && !StringUtils.startsWithAny((CharSequence)label, "\"" + this.clientName + "/", "\"/" + this.clientName + "/")) {
            label = StringUtils.removeStart((String)label, "\"");
            label = StringUtils.removeStart((String)label, "/");
            label = "\"/" + StringUtils.trim(this.clientName) + "/" + (String)label;
        }
        if (ArrayUtils.isNotEmpty(parts = StringUtils.splitByWholeSeparator((String)label, " - ,", 2)) && ArrayUtils.getLength(parts) == 2) {
            List pairStrings;
            label = parts[0] + " - ,";
            List<LisInfoKeyValuePair> pairs = this.getKeyValuePairs();
            if (CollectionUtils.isNotEmpty(pairs) && CollectionUtils.isNotEmpty(pairStrings = pairs.stream().map(LisInfoKeyValuePair::getDisplayLabel).filter(s -> StringUtils.isNotBlank(s) && !StringUtils.equals(s, "=")).collect(Collectors.toList()))) {
                label = (String)label + String.join((CharSequence)",", pairStrings);
            }
        }
        if (StringUtils.isNotBlank(this.getDiskFreeData()) && !StringUtils.contains((CharSequence)label, this.getDiskFreeData())) {
            label = (String)label + (StringUtils.endsWith((CharSequence)label, ",") ? "" : ",") + StringUtils.trim(this.getDiskFreeData());
        }
        if (CollectionUtils.isNotEmpty(this.getTasks()) && !StringUtils.contains((CharSequence)label, "tasks=")) {
            label = (String)label + (StringUtils.endsWith((CharSequence)label, ",") ? "" : ",") + "tasks=[" + String.join((CharSequence)",", this.getTasks()) + "]";
        }
        return StringUtils.replace(StringEscapeUtils.unescapeHtml4((String)label), "%2f", "/");
    }

    public Date getCreated() {
        if (this.created == null && StringUtils.isNotBlank(this.creationDateString) && StringUtils.isNotBlank(this.creationTimeString)) {
            this.created = HumanDate.toDate(this.creationDateString + " " + this.creationTimeString);
        }
        return this.created;
    }

    public Date getLastModified() {
        if (this.lastModified == null && StringUtils.isNotBlank(this.lastModifiedDateString) && StringUtils.isNotBlank(this.lastModifiedTimeString)) {
            this.lastModified = HumanDate.toDate(this.lastModifiedDateString + " " + this.lastModifiedTimeString);
        }
        return this.lastModified;
    }

    public Long getSize() {
        if (this.size == null && StringUtils.isNotBlank(this.sizeString)) {
            try {
                this.size = Long.decode(this.sizeString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
        this.sizeString = size != null ? size.toString() : null;
    }

    public String getUuid() {
        return this.getKeyValuePair(this.hasKeyValuePair("moref") ? "moref" : "uuid");
    }

    @JsonIgnore
    public boolean hasKeyValuePair(String key) {
        List<LisInfoKeyValuePair> candidates = this.getKeyValuePairs();
        if (CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        Optional<LisInfoKeyValuePair> pair = List.copyOf(candidates).stream().filter(p -> StringUtils.equals(key, p.getKey())).findFirst();
        return pair.isPresent();
    }

    @JsonIgnore
    public String getKeyValuePair(String key) {
        List<LisInfoKeyValuePair> candidates = this.getKeyValuePairs();
        if (CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        Optional<LisInfoKeyValuePair> pair = List.copyOf(candidates).stream().filter(p -> StringUtils.equals(key, p.getKey())).findFirst();
        return pair.isPresent() && StringUtils.isNotBlank(pair.get().getValue()) ? pair.get().getValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public List<LisInfoKeyValuePair> getKeyValuePairs() {
        this.lock.lock();
        try {
            if (this.pairs == null && StringUtils.isNotBlank(this.infoData)) {
                this.pairs = new ArrayList<LisInfoKeyValuePair>();
                String name = this.getName();
                List<String> candidates = TextUtils.splitByCommaNotInQuoteOrList(this.infoData);
                if (CollectionUtils.isNotEmpty(candidates)) {
                    for (String candidate : candidates) {
                        String[] parts;
                        if (StringUtils.isBlank(candidate) || StringUtils.contains((CharSequence)name, candidate)) continue;
                        LisInfoKeyValuePair pair = new LisInfoKeyValuePair();
                        String keyword = this.getKeywordFromStartOfString(candidate);
                        if (StringUtils.isNotBlank(keyword)) {
                            LisInfoKeyValuePair p = new LisInfoKeyValuePair();
                            p.setKey(keyword);
                            this.pairs.add(p);
                            candidate = StringUtils.trim(StringUtils.substring(candidate, StringUtils.length(keyword)));
                        }
                        if (!StringUtils.isNotBlank(candidate) || !ArrayUtils.isNotEmpty(parts = candidate.split("[:=]", 2))) continue;
                        pair.setKey(StringUtils.trim(parts[0]));
                        if (ArrayUtils.getLength(parts) > 1) {
                            String value = TextUtils.unmaskListCharacters(StringEscapeUtils.unescapeHtml4(StringUtils.trim(parts[1])));
                            if (StringUtils.equalsIgnoreCase(pair.getKey(), "description") && StringUtils.startsWith(value, "'") && StringUtils.endsWith(value, "'")) {
                                pair.setLabel(value);
                                value = StringUtils.removeEnd(StringUtils.removeStart(value, "'"), "'");
                            }
                            if (StringUtils.equals(pair.getKey(), "vmname") && !StringUtils.equals(value = StringUtils.replace(value, "%2f", "/"), name)) {
                                value = this.getName();
                            }
                            pair.setValue(value);
                        }
                        this.pairs.add(pair);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return CollectionUtils.isNotEmpty(this.pairs) ? List.copyOf(this.pairs) : Collections.emptyList();
    }

    @JsonIgnore
    public List<LisInfoKeyValuePair> getAttributesAsKeyValuePairs() {
        List<String> values;
        String value;
        ArrayList<LisInfoKeyValuePair> pairs = new ArrayList<LisInfoKeyValuePair>();
        if (this.hasKeyValuePair("attributes") && StringUtils.isNotBlank(value = this.getKeyValuePair("attributes")) && CollectionUtils.isNotEmpty(values = Arrays.asList(value.split(StringUtils.startsWith(value = StringUtils.trim(StringUtils.removeStart(StringUtils.removeEnd(value, "]"), "[")), "(") ? "\\),\\(" : ",")))) {
            for (String v : values) {
                LisInfoKeyValuePair p;
                v = StringUtils.removeStart(StringUtils.removeEnd(StringEscapeUtils.escapeHtml4(StringUtils.trim(v)), ")"), "(");
                List<String> parts = TextUtils.splitByCommaNotInQuoteOrList(v = StringUtils.removeStart(StringUtils.removeEnd(v, "'"), "'"));
                if (!CollectionUtils.isNotEmpty(parts)) continue;
                String attributeName = null;
                String attributeValue = null;
                for (String p2 : parts) {
                    if (StringUtils.startsWith(p2, "name=")) {
                        attributeName = StringUtils.trim(StringUtils.removeStart(p2, "name="));
                        continue;
                    }
                    if (!StringUtils.startsWith(p2, "value=")) continue;
                    attributeValue = StringUtils.trim(StringUtils.removeStart(p2, "value="));
                }
                if (StringUtils.isNotBlank(attributeName)) {
                    p = new LisInfoKeyValuePair();
                    p.setKey(TextUtils.unmaskListCharacters(StringEscapeUtils.unescapeHtml4(attributeName)));
                    p.setValue(TextUtils.unmaskListCharacters(StringEscapeUtils.unescapeHtml4(attributeValue)));
                    pairs.add(p);
                    continue;
                }
                if (CollectionUtils.size(parts) != 1 || !StringUtils.contains((CharSequence)parts.get(0), "=")) continue;
                attributeName = StringUtils.trim(StringUtils.substringBefore(parts.get(0), "="));
                attributeValue = StringUtils.trim(StringUtils.substringAfter(parts.get(0), "="));
                if (!StringUtils.isNotBlank(attributeName)) continue;
                p = new LisInfoKeyValuePair();
                p.setKey(TextUtils.unmaskListCharacters(StringEscapeUtils.unescapeHtml4(attributeName)));
                if (StringUtils.isNotBlank(attributeValue)) {
                    p.setValue(TextUtils.unmaskListCharacters(StringEscapeUtils.unescapeHtml4(attributeValue)));
                }
                pairs.add(p);
            }
        }
        return CollectionUtils.isNotEmpty(pairs) ? pairs : Collections.emptyList();
    }

    private String getKeywordFromStartOfString(String candidate) {
        String s2;
        String k;
        String kw = null;
        String s = StringUtils.lowerCase(candidate);
        if (StringUtils.startsWithAny(s, "not_saveable", "not_selectable", "single_selection", "not_expandable", "exclude_only", "hidden") && StringUtils.isNotBlank(k = StringUtils.substringBefore(s, " ")) && StringUtils.isNotBlank(StringUtils.trim(s2 = StringUtils.substringAfter(s, k)))) {
            kw = k;
        }
        return StringEscapeUtils.unescapeHtml4(kw);
    }

    @Generated
    public String getLisFileName() {
        return this.lisFileName;
    }

    @Generated
    public String getRawData() {
        return this.rawData;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public Boolean getPrefixWithClient() {
        return this.prefixWithClient;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getParentPath() {
        return this.parentPath;
    }

    @Generated
    public String getForcedParentPath() {
        return this.forcedParentPath;
    }

    @Generated
    public String getSegmentNum() {
        return this.segmentNum;
    }

    @Generated
    public String getStartPos() {
        return this.startPos;
    }

    @Generated
    public String getEndPos() {
        return this.endPos;
    }

    @Generated
    public String getInfoData() {
        return this.infoData;
    }

    @Generated
    public String getDiskFreeData() {
        return this.diskFreeData;
    }

    @Generated
    public Double getCapacity() {
        return this.capacity;
    }

    @Generated
    public Double getFree() {
        return this.free;
    }

    @Generated
    public Double getUsed() {
        return this.used;
    }

    @Generated
    public Double getUsedPercent() {
        return this.usedPercent;
    }

    @Generated
    public List<String> getTasks() {
        return this.tasks;
    }

    @Generated
    public BackupType getBackupType() {
        return this.backupType;
    }

    @Generated
    public void setLisFileName(String lisFileName) {
        this.lisFileName = lisFileName;
    }

    @Generated
    public void setPrefixWithClient(Boolean prefixWithClient) {
        this.prefixWithClient = prefixWithClient;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    @Generated
    public void setForcedParentPath(String forcedParentPath) {
        this.forcedParentPath = forcedParentPath;
    }

    @Generated
    public void setCreated(Date created) {
        this.created = created;
    }

    @Generated
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Generated
    public void setSegmentNum(String segmentNum) {
        this.segmentNum = segmentNum;
    }

    @Generated
    public void setStartPos(String startPos) {
        this.startPos = startPos;
    }

    @Generated
    public void setEndPos(String endPos) {
        this.endPos = endPos;
    }

    @Generated
    public void setInfoData(String infoData) {
        this.infoData = infoData;
    }

    @Generated
    public void setDiskFreeData(String diskFreeData) {
        this.diskFreeData = diskFreeData;
    }

    @Generated
    public void setCapacity(Double capacity) {
        this.capacity = capacity;
    }

    @Generated
    public void setFree(Double free) {
        this.free = free;
    }

    @Generated
    public void setUsed(Double used) {
        this.used = used;
    }

    @Generated
    public void setUsedPercent(Double usedPercent) {
        this.usedPercent = usedPercent;
    }

    @Generated
    public void setTasks(List<String> tasks) {
        this.tasks = tasks;
    }

    @Generated
    public void setBackupType(BackupType backupType) {
        this.backupType = backupType;
    }

    @Generated
    public LisInfo() {
    }

    @Generated
    private void setClientName(String clientName) {
        this.clientName = clientName;
    }
}

