/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.annotations.CompareIgnore;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.IEntity;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractSerializableObject
implements Serializable {
    @JsonIgnore
    private static final Comparator<Field> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if ("id".equals(o1.getName()) || "id".equals(o2.getName())) {
            if (o1.getName().equals(o2.getName())) {
                return 0;
            }
            if ("id".equals(o1.getName())) {
                return -1;
            }
            if ("id".equals(o2.getName())) {
                return 1;
            }
        }
        if ("name".equals(o1.getName()) || "name".equals(o2.getName())) {
            if (o1.getName().equals(o2.getName())) {
                return 0;
            }
            if ("name".equals(o1.getName())) {
                return -1;
            }
            if ("name".equals(o2.getName())) {
                return 1;
            }
        }
        if ("uuid".equals(o1.getName()) || "uuid".equals(o2.getName())) {
            if (o1.getName().equals(o2.getName())) {
                return 0;
            }
            if ("uuid".equals(o1.getName())) {
                return 1;
            }
            if ("uuid".equals(o2.getName())) {
                return -1;
            }
        }
        if ("mtime".equals(o1.getName()) || "mtime".equals(o2.getName())) {
            if (o1.getName().equals(o2.getName())) {
                return 0;
            }
            if ("mtime".equals(o1.getName())) {
                return 1;
            }
            if ("mtime".equals(o2.getName())) {
                return -1;
            }
        }
        return o1.getName().compareTo(o2.getName());
    };

    @JsonIgnore
    private List<Class<?>> getClasses() {
        ArrayList clazzes = new ArrayList();
        for (Class<?> clazz = this.getClass(); clazz != AbstractSerializableObject.class; clazz = clazz.getSuperclass()) {
            if (clazzes.contains(clazz)) continue;
            clazzes.add(0, clazz);
        }
        return clazzes;
    }

    private List<Field> getAllFields() {
        HashMap<String, Field> candidates = new HashMap<String, Field>();
        for (Class<?> c : this.getClasses()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isVolatile(field.getModifiers()) || field.getAnnotation(CompareIgnore.class) != null) continue;
                candidates.put(field.getName(), field);
            }
        }
        ArrayList<Field> allFields = new ArrayList<Field>(candidates.values());
        allFields.sort(comparator);
        return allFields;
    }

    @JsonIgnore
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        this.toString(sb, this.getAllFields());
        sb.append("}");
        return sb.toString();
    }

    @JsonIgnore
    private void toString(StringBuilder sb, List<Field> fields) {
        assert (sb != null);
        assert (fields != null);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(field.getName()).append(" = ");
            if (!field.canAccess(this)) {
                field.setAccessible(true);
            }
            try {
                Object pk;
                Object value = field.get(this);
                String label = null;
                if (value instanceof IDisplayLabelProvider) {
                    label = ((IDisplayLabelProvider)value).getDisplayLabel();
                }
                if (label == null && value instanceof IEntity && (pk = ((IEntity)value).getPK()) != null) {
                    label = pk.toString();
                }
                if (label == null && value != null && value.getClass().isArray()) {
                    label = value instanceof Object[] ? Arrays.deepToString((Object[])value) : (value instanceof int[] ? Arrays.toString((int[])value) : (value instanceof long[] ? Arrays.toString((long[])value) : (value instanceof float[] ? Arrays.toString((float[])value) : (value instanceof double[] ? Arrays.toString((double[])value) : (value instanceof short[] ? Arrays.toString((short[])value) : (value instanceof byte[] ? Arrays.toString((byte[])value) : (value instanceof char[] ? Arrays.toString((char[])value) : (value instanceof boolean[] ? Arrays.toString((boolean[])value) : value.toString()))))))));
                }
                sb.append(label != null ? label : value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
    }

    @JsonIgnore
    public boolean equals(Object obj) {
        if (obj != null && this.getClass().isAssignableFrom(obj.getClass())) {
            return this.equals(this.getAllFields(), obj);
        }
        return super.equals(obj);
    }

    private boolean equals(List<Field> fields, Object obj) {
        assert (fields != null);
        assert (obj != null);
        for (Field field : fields) {
            if (!field.canAccess(this)) {
                field.setAccessible(true);
            }
            try {
                Object value1 = field.get(this);
                Object value2 = field.get(obj);
                if (value1 == null && value2 == null) continue;
                if (value1 instanceof IEntity) {
                    Object pk = ((IEntity)value1).getPK();
                    if (value2 instanceof IEntity) {
                        Object pk2 = ((IEntity)value2).getPK();
                        if (pk == null && pk2 == null || pk != null && pk.equals(pk2)) continue;
                        return false;
                    }
                    return false;
                }
                if (value1 != null && value1.getClass().isArray() && value2 != null && value2.getClass().isArray()) {
                    if (Objects.deepEquals(value1, value2)) continue;
                    return false;
                }
                if (value1 instanceof AtomicBoolean && value2 instanceof AtomicBoolean) {
                    if (((AtomicBoolean)value1).get() == ((AtomicBoolean)value2).get()) continue;
                    return false;
                }
                if (value1 instanceof AtomicInteger && value2 instanceof AtomicInteger) {
                    if (((AtomicInteger)value1).get() == ((AtomicInteger)value2).get()) continue;
                    return false;
                }
                if (value1 instanceof AtomicLong && value2 instanceof AtomicLong) {
                    if (((AtomicLong)value1).get() != ((AtomicLong)value2).get()) continue;
                    return false;
                }
                if (value1 instanceof AtomicReference && value2 instanceof AtomicReference) {
                    Object v1 = ((AtomicReference)value1).get();
                    Object v2 = ((AtomicReference)value2).get();
                    if (!(v1 == null && v2 != null || v1 != null && v2 == null) && Objects.deepEquals(v1, v2)) continue;
                    return false;
                }
                if (value1 != null && value1.equals(value2)) continue;
                return false;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    @JsonIgnore
    public int hashCode() {
        AtomicInteger result = new AtomicInteger(1);
        this.hashCode(result, 31, this.getAllFields());
        return result.get();
    }

    private void hashCode(AtomicInteger result, int prime, List<Field> fields) {
        assert (result != null);
        assert (prime != 0);
        assert (fields != null);
        for (Field field : fields) {
            if (!field.canAccess(this)) {
                field.setAccessible(true);
            }
            try {
                Object pk;
                Object value = field.get(this);
                int hash = 0;
                hash = value == null ? "null".hashCode() : (value instanceof IEntity ? ((pk = ((IEntity)value).getPK()) != null ? pk.hashCode() : "null".hashCode()) : (value.getClass().isArray() ? ArrayUtils.hashCode(value) : value.hashCode()));
                result.set(prime * result.get() + hash);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
    }
}

