/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.cli;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public enum CliCommandType implements Serializable
{
    ADD,
    BACKUP,
    CANCEL,
    CLEAR,
    CHECK,
    DIR,
    DISABLE,
    DISMOUNT,
    DISTRIBUTE,
    DOWNLOAD,
    ENABLE,
    EXPORT,
    GET,
    GENERATE,
    HELP,
    IMPORT,
    INIT,
    LINK,
    LIST,
    LOAD,
    MIGRATE,
    MODIFY,
    MOUNT,
    NONE,
    ONLINE,
    OFFLINE,
    REFRESH,
    REMOVE,
    RENAME,
    RENDER,
    REGISTER,
    REPLICATE,
    REPORT,
    RESET,
    RESETCBT,
    RESTART,
    RESTORE,
    SEND,
    SHOW,
    SQL,
    START,
    STOP,
    UPDATE,
    UPLOAD,
    UNLINK,
    UNLOAD,
    UNREGISTER;


    public String nameCapitalized() {
        String n = this.name();
        return Character.toTitleCase(n.charAt(0)) + n.substring(1).toLowerCase();
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static CliCommandType fromString(String commandtype) {
        try {
            if (StringUtils.isNotBlank(commandtype)) {
                return CliCommandType.valueOf(StringUtils.trim(commandtype));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return NONE;
    }
}

