/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.browser.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.annotations.SesamParameter;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.types.BackupType;
import de.sep.sesam.model.type.TasksSubType;
import de.sep.sesam.model.vms.dto.VMAttributesDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;

@Schema(description="The command to generate a backup task.")
public class GenerateCommandDto
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = -5698831043094135861L;
    @Schema(description="The attributes of the virtual machine to backup.")
    private VMAttributesDto attribute;
    @Schema(description="The data center to backup.", example="datacenter-1")
    private String dataCenter;
    @Schema(description="The data store to backup.", example="datastore-1")
    private List<String> dataStore;
    @Schema(description="To exclude from a backup type.", example="vm-1")
    private String exclude;
    private List<String> esx;
    @Schema(description="The folder to backup.", example="folder-1")
    private List<String> folder;
    @Schema(description="The name of the generator.", example="backup-generator-1")
    private String name;
    @Schema(description="The operating system.", example="Linux")
    private List<String> operSystem;
    @Schema(description="browse options")
    @SesamParameter(shortFields={"o"}, description="Cli.BrowserParams.Description.Filter.Option")
    private String option;
    @Schema(description="The power state of the virtual machine to backup.", example="powered-on")
    private List<String> powerState;
    @Schema(description="The server.", example="server-1")
    private String server;
    @Schema(description="Task type according to which the data is backed up.", example="full")
    @SesamParameter(shortFields={"t"}, description="Model.Tasks.Description.Type", hidden=true)
    private BackupType type;
    @Schema(description="The type of the task.")
    @SesamParameter(shortFields={"T"}, target="name", description="Model.Tasks.Description.SubType")
    private TasksSubType subType;
    @Schema(description="Additional task groups that also contain generated tasks")
    @SesamParameter(shortFields={"G"}, description="Cli.TaskGenParams.Description.TaskGroups")
    private String taskGroup;
    @Schema(description="The virtual app.", example="vm-1")
    private List<String> virtualApp;
    @Schema(description="The tags.")
    private List<String> tags;

    @Generated
    public VMAttributesDto getAttribute() {
        return this.attribute;
    }

    @Generated
    public String getDataCenter() {
        return this.dataCenter;
    }

    @Generated
    public List<String> getDataStore() {
        return this.dataStore;
    }

    @Generated
    public String getExclude() {
        return this.exclude;
    }

    @Generated
    public List<String> getEsx() {
        return this.esx;
    }

    @Generated
    public List<String> getFolder() {
        return this.folder;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getOperSystem() {
        return this.operSystem;
    }

    @Generated
    public String getOption() {
        return this.option;
    }

    @Generated
    public List<String> getPowerState() {
        return this.powerState;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public BackupType getType() {
        return this.type;
    }

    @Generated
    public TasksSubType getSubType() {
        return this.subType;
    }

    @Generated
    public String getTaskGroup() {
        return this.taskGroup;
    }

    @Generated
    public List<String> getVirtualApp() {
        return this.virtualApp;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public void setAttribute(VMAttributesDto attribute) {
        this.attribute = attribute;
    }

    @Generated
    public void setDataCenter(String dataCenter) {
        this.dataCenter = dataCenter;
    }

    @Generated
    public void setDataStore(List<String> dataStore) {
        this.dataStore = dataStore;
    }

    @Generated
    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    @Generated
    public void setEsx(List<String> esx) {
        this.esx = esx;
    }

    @Generated
    public void setFolder(List<String> folder) {
        this.folder = folder;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setOperSystem(List<String> operSystem) {
        this.operSystem = operSystem;
    }

    @Generated
    public void setOption(String option) {
        this.option = option;
    }

    @Generated
    public void setPowerState(List<String> powerState) {
        this.powerState = powerState;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setType(BackupType type) {
        this.type = type;
    }

    @Generated
    public void setSubType(TasksSubType subType) {
        this.subType = subType;
    }

    @Generated
    public void setTaskGroup(String taskGroup) {
        this.taskGroup = taskGroup;
    }

    @Generated
    public void setVirtualApp(List<String> virtualApp) {
        this.virtualApp = virtualApp;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public GenerateCommandDto() {
    }
}

