/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.browser.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.date.DateUtils;
import de.sep.sesam.model.TaskTypes;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.browser.LisInfoKeyValuePair;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.types.BackupType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FileDto
extends AbstractSerializableObject
implements INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = -2919340866209067031L;
    @JsonIgnore
    private static final Comparator<FileDto> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getFullPath() == null && o2 != null && o2.getFullPath() == null) {
            return 0;
        }
        if (o1 == null || o1.getFullPath() == null) {
            return -1;
        }
        if (o2 == null || o2.getFullPath() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getFullPath().compareToIgnoreCase(o2.getFullPath()) : o1.getFullPath().compareTo(o2.getFullPath());
    };
    @Schema(description="The name of the client to which this file belongs.", example="my-client-server")
    private String clientName;
    @Schema(description="The absolute path of the file.", example="\"/home/user/backup/backup.zip\"")
    private String path;
    @Schema(description="The file name.", example="backup.zip")
    private String name;
    @Schema(description="The file type", example="f")
    private String type;
    @Schema(description="Backup type", example="path")
    private BackupType backupType;
    @Schema(description="The timestamp of the file creation.", example="1720077461000")
    private Date creationDate;
    @Schema(description="The timestamp of the last modification of the file.", example="1720077461000")
    private Date modificationDate;
    @Schema(description="The size of the file in bytes.", example="1024")
    private Long size;
    @Schema(description="The user name of the file owner.", example="user")
    private String user;
    @Schema(description="The raw data of the file.", example="file data")
    private String rawData;
    @Schema(description="Additional information about file.", example="file data")
    private List<LisInfoKeyValuePair> additionalInformation;
    @JsonIgnore
    @Schema(description="The task type of the file.", example="backup")
    private TaskTypes taskType;
    @JsonIgnore
    @Schema(description="The raw object the file DTO represent.", example="file data")
    private volatile Serializable rawObject;
    @JsonIgnore
    @Schema(description="The information map of the file.", example="file data")
    private volatile Map<String, String> info;

    @JsonIgnore
    public static Comparator<FileDto> sorter() {
        return comparator;
    }

    @JsonIgnore
    public String getAdditionalInformation(String key) {
        if (this.additionalInformation != null) {
            for (LisInfoKeyValuePair info : this.additionalInformation) {
                if (!StringUtils.equals(key, info.getKey())) continue;
                return info.getValue();
            }
        }
        return null;
    }

    @JsonIgnore
    public Map<String, String> getInfo() {
        if (this.info == null) {
            this.info = new HashMap<String, String>();
            if (this.additionalInformation != null) {
                for (LisInfoKeyValuePair elem : this.additionalInformation) {
                    this.info.put(elem.getKey(), elem.getValue());
                }
            }
        }
        return this.info;
    }

    @JsonIgnore
    public TaskTypes getTaskType() {
        if (this.taskType == null && this.backupType != null) {
            this.taskType = new TaskTypes(this.backupType);
        }
        if (this.taskType == null && StringUtils.isNotBlank(this.path)) {
            StringTokenizer st = new StringTokenizer(this.path, StringUtils.contains((CharSequence)this.path, "/") ? "/" : ":");
            while (st.hasMoreTokens() && this.taskType == null) {
                BackupType type;
                String token = StringUtils.substringBefore(st.nextToken(), ":");
                if (StringUtils.equals(token, "\"") || (type = BackupType.fromString(token)) == null || BackupType.NONE.equals((Object)type)) continue;
                this.taskType = new TaskTypes(type);
            }
        }
        return this.taskType;
    }

    @JsonIgnore
    public String getFullPath() {
        String fullPath;
        String p;
        StringBuilder sb = new StringBuilder();
        String string = p = StringUtils.isNotBlank(this.rawData) ? this.rawData : this.path;
        if (StringUtils.isNotBlank(this.clientName) && !StringUtils.startsWith(p, "\"/" + this.clientName)) {
            sb.append("\"/");
            sb.append(this.clientName);
            sb.append("/");
            p = StringUtils.removeStart(p, "\"");
            p = StringUtils.removeStart(p, "/");
        }
        if (StringUtils.isNotBlank(p)) {
            sb.append(p);
        }
        if (StringUtils.isNotBlank(sb.toString()) && !StringUtils.startsWith(sb.toString(), "\"")) {
            sb.insert(0, "\"");
        }
        if (StringUtils.isNotBlank(fullPath = sb.toString()) && !fullPath.matches("\".+\" [fd][a-zA-Z_] .*") && !StringUtils.endsWith(p, "\"")) {
            sb.append("\"");
            fullPath = sb.toString();
        }
        return fullPath;
    }

    @Override
    public String toString() {
        String fullPath = this.getFullPath();
        StringBuilder sb = new StringBuilder(StringUtils.isNotBlank(fullPath) ? fullPath : "");
        if (StringUtils.isNotBlank(fullPath) && !fullPath.matches("\".+\" [fd][a-zA-Z_] .*")) {
            sb.append(" ");
            sb.append(this.type);
            sb.append(" ");
            if (this.creationDate != null) {
                sb.append(DateUtils.dateToSmShoStr(this.creationDate));
                sb.append(" ");
            } else {
                sb.append("- -");
            }
            if (this.modificationDate != null) {
                sb.append(DateUtils.dateToSmShoStr(this.modificationDate));
                sb.append(" ");
            } else {
                sb.append(" - - ");
            }
            sb.append(this.size != null ? this.size : "0");
            sb.append(" -");
            if (CollectionUtils.isNotEmpty(this.additionalInformation)) {
                sb.append(" ,");
                boolean first = true;
                Iterator<LisInfoKeyValuePair> it = this.additionalInformation.iterator();
                while (it.hasNext()) {
                    LisInfoKeyValuePair info;
                    if (!first) {
                        sb.append(",");
                    }
                    if (StringUtils.isNotBlank((info = it.next()).getKey())) {
                        sb.append(info.getKey());
                    }
                    if (StringUtils.isNotBlank(info.getValue())) {
                        sb.append("=");
                        sb.append(info.getValue());
                    }
                    first = false;
                }
            }
        }
        return sb.toString();
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public BackupType getBackupType() {
        return this.backupType;
    }

    @Generated
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Generated
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getRawData() {
        return this.rawData;
    }

    @Generated
    public List<LisInfoKeyValuePair> getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Generated
    public Serializable getRawObject() {
        return this.rawObject;
    }

    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setBackupType(BackupType backupType) {
        this.backupType = backupType;
    }

    @Generated
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Generated
    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Generated
    public void setSize(Long size) {
        this.size = size;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setRawData(String rawData) {
        this.rawData = rawData;
    }

    @Generated
    public void setAdditionalInformation(List<LisInfoKeyValuePair> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    @JsonIgnore
    @Generated
    public void setRawObject(Serializable rawObject) {
        this.rawObject = rawObject;
    }

    @Generated
    public FileDto() {
    }
}

