/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.browser.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.text.TextUtils;
import de.sep.sesam.model.browser.dto.FileDto;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.browser.LisInfo;
import de.sep.sesam.model.core.browser.LisInfoKeyValuePair;
import de.sep.sesam.model.core.types.BackupType;
import de.sep.sesam.model.core.types.PowerStateType;
import de.sep.sesam.model.vms.dto.VMAttributesDto;
import de.sep.sesam.model.vms.dto.VMDKDto;
import de.sep.sesam.model.vms.dto.VMDto;
import de.sep.sesam.model.vms.dto.VMSnapshotDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

@Schema(description="The browse DTO object contains information about a file or a virtual machine.")
public class BrowseDto
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = -8713236039787219254L;
    @JsonIgnore
    private static final String VSPHERE_MARKER = BackupType.VM_WARE_VSPHERE.getTypeName() + ":";
    @Schema(description="The type of the browse DTO object. Possible values are 'vm' and 'file'.")
    private VMDto vmDto;
    private FileDto fileDto;
    private VMDKDto vmdkData;

    @Override
    @JsonIgnore
    public String toString() {
        Object retVal = null;
        if (this.vmDto != null) {
            retVal = this.vmDto.toString();
            if (StringUtils.isNotBlank(this.vmDto.getServerName()) && !StringUtils.startsWith((CharSequence)retVal, "\"/" + this.vmDto.getServerName())) {
                retVal = "\"/" + this.vmDto.getServerName() + "/" + StringUtils.removeStart((String)retVal, "\"/");
            }
        }
        if (this.fileDto != null) {
            retVal = this.fileDto.toString();
        }
        if (this.vmdkData != null) {
            retVal = this.vmdkData.toString();
        }
        return retVal;
    }

    @JsonIgnore
    public static BrowseDto fromLisInfo(LisInfo info, boolean forceVmDto) {
        if (info == null) {
            return null;
        }
        String name = info.getName();
        if (StringUtils.isBlank(name)) {
            name = info.getPath();
        }
        if (StringUtils.isBlank(name)) {
            return null;
        }
        BrowseDto dto = new BrowseDto();
        if (forceVmDto) {
            if (StringUtils.equals(info.getType(), "f_")) {
                VMDKDto vmdkData = new VMDKDto();
                vmdkData.setPath(info.getName());
                vmdkData.setCapacity(info.getSize());
                List<LisInfoKeyValuePair> pairs = info.getKeyValuePairs();
                if (CollectionUtils.isNotEmpty(pairs)) {
                    for (LisInfoKeyValuePair p : pairs) {
                        if (StringUtils.isBlank(p.getKey()) || StringUtils.isBlank(p.getValue())) continue;
                        switch (p.getKey()) {
                            case "filename": {
                                vmdkData.setPath(p.getValue());
                                break;
                            }
                            case "diskmode": {
                                vmdkData.setDiskMode(p.getValue());
                                break;
                            }
                            case "description": {
                                vmdkData.setDeviceName(p.getValue());
                                vmdkData.setLabel(p.getValue());
                                break;
                            }
                            case "key": {
                                try {
                                    vmdkData.setKey(Integer.decode(p.getValue()));
                                }
                                catch (NumberFormatException numberFormatException) {}
                                break;
                            }
                            case "unitnumber": {
                                try {
                                    vmdkData.setUnitNumber(Integer.decode(p.getValue()));
                                }
                                catch (NumberFormatException numberFormatException) {}
                                break;
                            }
                            case "controllerkey": {
                                try {
                                    vmdkData.setControllerKey(Integer.decode(p.getValue()));
                                }
                                catch (NumberFormatException numberFormatException) {}
                                break;
                            }
                            case "change_id": {
                                vmdkData.setChangeId(p.getValue());
                                break;
                            }
                            case "backing_type": {
                                vmdkData.setBackingType(p.getValue());
                                break;
                            }
                            case "eagerly_scrub": {
                                vmdkData.setEagerlyScrub(BrowseDto.getBoolean(p.getValue()));
                                break;
                            }
                            case "thin_provisioned": {
                                vmdkData.setThinProvisioned(BrowseDto.getBoolean(p.getValue()));
                                break;
                            }
                            case "write_through": {
                                vmdkData.setWriteThrough(BrowseDto.getBoolean(p.getValue()));
                            }
                        }
                    }
                }
                dto.setVmdkData(vmdkData);
            } else {
                VMDto vmDto = new VMDto();
                vmDto.setName(name);
                Object path = info.getPath();
                if (StringUtils.isNotBlank((CharSequence)path)) {
                    path = StringUtils.replace((String)path, BackupType.VM_WARE_VSPHERE + ":", "");
                    if (StringUtils.isNotBlank(info.getClientName()) && !StringUtils.startsWith((CharSequence)path, "/" + info.getClientName())) {
                        path = "/" + info.getClientName() + "/" + StringUtils.removeStart((String)path, "/");
                    }
                    vmDto.setPath((String)path);
                }
                vmDto.setServerName(info.getClientName());
                vmDto.setSize(info.getSize());
                vmDto.setTasks(info.getTasks());
                vmDto.setBackupType(info.getBackupType());
                List<LisInfoKeyValuePair> pairs = info.getKeyValuePairs();
                if (CollectionUtils.isNotEmpty(pairs)) {
                    HashSet<String> networks = new HashSet<String>();
                    for (LisInfoKeyValuePair p : pairs) {
                        if (StringUtils.isBlank(p.getKey()) || StringUtils.isBlank(p.getValue())) continue;
                        if (StringUtils.startsWith(p.getKey(), "network-")) {
                            networks.add(p.getValue());
                            continue;
                        }
                        switch (p.getKey()) {
                            case "vcenter": {
                                vmDto.setServerName(p.getValue());
                                break;
                            }
                            case "vmname": {
                                vmDto.setName(p.getValue());
                                break;
                            }
                            case "moref": {
                                vmDto.setMoRef(p.getValue());
                                break;
                            }
                            case "datacenter": {
                                vmDto.setDataCenter(p.getValue());
                                break;
                            }
                            case "hostSystem": {
                                vmDto.setHostSystem(p.getValue());
                                break;
                            }
                            case "hostversion": {
                                vmDto.setHostVersion(p.getValue());
                                break;
                            }
                            case "powerState": {
                                vmDto.setPowerState(PowerStateType.fromString(p.getValue()));
                                break;
                            }
                            case "mac_address": 
                            case "mac_addresses": {
                                String v = p.getValue();
                                if (StringUtils.startsWith(v, "[")) {
                                    v = StringUtils.split(StringUtils.removeStart(v, "["), ",", 2)[0];
                                }
                                vmDto.setMacAddress(v);
                                break;
                            }
                            case "guest_tools_running": {
                                vmDto.setGuestToolsRunning(BrowseDto.getBoolean(p.getValue()));
                                break;
                            }
                            case "ip": 
                            case "ips": {
                                String v = p.getValue();
                                if (StringUtils.startsWith(v, "[")) {
                                    v = StringUtils.split(StringUtils.removeStart(v, "["), ",", 2)[0];
                                }
                                vmDto.setIpAddress(v);
                                break;
                            }
                            case "hostname": 
                            case "hostnames": {
                                String v = p.getValue();
                                if (StringUtils.startsWith(v, "[")) {
                                    v = StringUtils.split(StringUtils.removeStart(v, "["), ",", 2)[0];
                                }
                                vmDto.setVmHost(v);
                                break;
                            }
                            case "guest_os": {
                                vmDto.setGuestFullName(p.getValue());
                                break;
                            }
                            case "block_tracking": {
                                vmDto.setChangeBlockTracking(BrowseDto.getBoolean(p.getValue()));
                                break;
                            }
                            case "version": {
                                vmDto.setVersion(p.getValue());
                                break;
                            }
                            case "uuid": {
                                vmDto.setUuid(p.getValue());
                                break;
                            }
                            case "annotation": {
                                vmDto.setAnnotations(BrowseDto.makeList(p.getValue()));
                                break;
                            }
                            case "datastores": {
                                vmDto.setDataStores(BrowseDto.makeList(p.getValue()));
                                break;
                            }
                            case "folder": {
                                vmDto.setFolder(p.getValue());
                                break;
                            }
                            case "cluster": {
                                vmDto.setCluster(p.getValue());
                                break;
                            }
                            case "clustered": {
                                vmDto.setClustered(BrowseDto.getBoolean(p.getValue()));
                                break;
                            }
                            case "vapp": {
                                vmDto.setVApp(p.getValue());
                                break;
                            }
                            case "resourcepool": {
                                vmDto.setResourcepool(p.getValue());
                                break;
                            }
                            case "apitype": {
                                vmDto.setVCenter(StringUtils.equals(p.getValue(), "VirtualCenter"));
                                break;
                            }
                            case "tags": {
                                vmDto.setTags(BrowseDto.makeList(p.getValue()));
                                break;
                            }
                            case "attributes": {
                                vmDto.setAttributes(BrowseDto.makeAttributes(p.getValue()));
                                break;
                            }
                            case "snapshots": {
                                vmDto.setSnapshots(BrowseDto.makeSnapshots(p.getValue()));
                                break;
                            }
                            case "exists": {
                                vmDto.setExist(BrowseDto.getBoolean(p.getValue()));
                                break;
                            }
                            case "description": {
                                vmDto.setDescription(p.getValue());
                            }
                        }
                        if (!CollectionUtils.isNotEmpty(networks)) continue;
                        vmDto.setNetworks(new ArrayList<String>(networks));
                    }
                }
                dto.setVmDto(vmDto);
            }
        } else {
            FileDto fileDto = new FileDto();
            Object type = info.getType();
            if (StringUtils.length((CharSequence)type) == 1) {
                type = (String)type + "_";
            }
            fileDto.setClientName(info.getClientName());
            fileDto.setPath(info.getPath());
            fileDto.setRawData(info.getDisplayLabel());
            fileDto.setName(name);
            fileDto.setType((String)type);
            fileDto.setBackupType(info.getBackupType());
            fileDto.setSize(info.getSize());
            fileDto.setCreationDate(info.getCreated());
            fileDto.setModificationDate(info.getLastModified());
            fileDto.setAdditionalInformation(info.getKeyValuePairs());
            dto.setFileDto(fileDto);
        }
        return dto;
    }

    private static Boolean getBoolean(String value) {
        Boolean b = null;
        if (StringUtils.equalsAnyIgnoreCase(value, "true", "1", "yes")) {
            b = Boolean.TRUE;
        } else if (StringUtils.equalsAnyIgnoreCase(value, "false", "0", "no")) {
            b = Boolean.FALSE;
        }
        return b;
    }

    private static List<String> makeList(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        return Arrays.asList(StringUtils.trim(StringUtils.removeStart(StringUtils.removeEnd(value, "]"), "[")).split(","));
    }

    private static List<VMAttributesDto> makeAttributes(String value) {
        ArrayList<VMAttributesDto> attributes = new ArrayList<VMAttributesDto>();
        List<String> values = Arrays.asList(StringUtils.trim(StringUtils.removeStart(StringUtils.removeEnd(value, "]"), "[")).split("\\),\\("));
        if (CollectionUtils.isNotEmpty(values)) {
            for (String v : values) {
                List<String> parts = TextUtils.splitByCommaNotInQuoteOrList(StringUtils.trim(StringUtils.removeStart(StringUtils.removeEnd(StringEscapeUtils.escapeHtml4(v), ")"), "(")));
                if (!CollectionUtils.isNotEmpty(parts)) continue;
                int attributeKey = -1;
                String attributeName = null;
                String attributeValue = null;
                for (String p : parts) {
                    if (StringUtils.startsWith(p, "key=")) {
                        try {
                            attributeKey = Integer.decode(StringUtils.removeStart(p, "key="));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (StringUtils.startsWith(p, "name=")) {
                        attributeName = StringUtils.trim(StringUtils.removeStart(p, "name="));
                        continue;
                    }
                    if (!StringUtils.startsWith(p, "value=")) continue;
                    attributeValue = StringUtils.trim(StringUtils.removeStart(p, "value="));
                }
                if (attributeKey < 0 || !StringUtils.isNotBlank(attributeName)) continue;
                attributes.add(new VMAttributesDto(attributeKey, StringEscapeUtils.unescapeHtml4(attributeName), StringEscapeUtils.unescapeHtml4(attributeValue), null));
            }
        }
        return CollectionUtils.isNotEmpty(attributes) ? attributes : null;
    }

    private static List<VMSnapshotDto> makeSnapshots(String value) {
        ArrayList<VMSnapshotDto> snapshots = new ArrayList<VMSnapshotDto>();
        List<String> values = Arrays.asList(StringUtils.trim(StringUtils.removeStart(StringUtils.removeEnd(value, "]"), "[")).split("\\),\\("));
        if (CollectionUtils.isNotEmpty(values)) {
            for (String v : values) {
                List<String> parts = TextUtils.splitByCommaNotInQuoteOrList(StringUtils.trim(StringUtils.removeStart(StringUtils.removeEnd(v, ")"), "(")));
                if (!CollectionUtils.isNotEmpty(parts)) continue;
                String id = null;
                String name = null;
                String internalid = null;
                String description = null;
                String creationtime = null;
                String powerstate = null;
                for (String p : parts) {
                    if (StringUtils.startsWith(p, "id=")) {
                        id = StringUtils.trim(StringUtils.removeStart(p, "id="));
                        continue;
                    }
                    if (StringUtils.startsWith(p, "name=")) {
                        name = StringUtils.trim(StringUtils.removeEnd(StringUtils.removeStart(StringUtils.removeStart(p, "name="), "'"), "'"));
                        continue;
                    }
                    if (StringUtils.startsWith(p, "internalid=")) {
                        internalid = StringUtils.trim(StringUtils.removeStart(p, "internalid="));
                        continue;
                    }
                    if (StringUtils.startsWith(p, "description=")) {
                        description = StringUtils.trim(StringUtils.removeEnd(StringUtils.removeStart(StringUtils.removeStart(p, "description="), "'"), "'"));
                        continue;
                    }
                    if (StringUtils.startsWith(p, "creationtime=")) {
                        creationtime = StringUtils.trim(StringUtils.removeStart(p, "creationtime="));
                        continue;
                    }
                    if (!StringUtils.startsWith(p, "powerstate=")) continue;
                    powerstate = StringUtils.trim(StringUtils.removeStart(p, "powerstate="));
                }
                if (!StringUtils.isNotBlank(id) || !StringUtils.isNotBlank(name)) continue;
                VMSnapshotDto snapshot = new VMSnapshotDto();
                snapshot.setId(id);
                snapshot.setName(name);
                snapshot.setDescription(description);
                if (StringUtils.isNotBlank(internalid)) {
                    try {
                        snapshot.setInternalId(Integer.decode(internalid));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (StringUtils.isNotBlank(creationtime)) {
                    snapshot.setCreationTime(StringUtils.trim(creationtime));
                }
                if (StringUtils.isNotBlank(powerstate)) {
                    snapshot.setPowerState(PowerStateType.fromString(powerstate));
                }
                snapshots.add(snapshot);
            }
        }
        return CollectionUtils.isNotEmpty(snapshots) ? snapshots : null;
    }

    @Generated
    public VMDto getVmDto() {
        return this.vmDto;
    }

    @Generated
    public FileDto getFileDto() {
        return this.fileDto;
    }

    @Generated
    public VMDKDto getVmdkData() {
        return this.vmdkData;
    }

    @Generated
    public void setVmDto(VMDto vmDto) {
        this.vmDto = vmDto;
    }

    @Generated
    public void setFileDto(FileDto fileDto) {
        this.fileDto = fileDto;
    }

    @Generated
    public void setVmdkData(VMDKDto vmdkData) {
        this.vmdkData = vmdkData;
    }

    @Generated
    public BrowseDto() {
    }
}

