/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model.auth.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.auth.SessionType;
import de.sep.sesam.model.core.AbstractSerializableObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.security.cert.Certificate;
import lombok.Generated;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

@Schema(description="The DTO to be passed in to the V2 authentication service log in API.")
public class LoginDto
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = 1221294821536642054L;
    @NotNull
    @Schema(description="The username to log in.", example="john.doe")
    private String username;
    @Schema(description="The secret to use to log in (URL encoded).", example="secret")
    private String secret;
    @Schema(description="Name of the hashing algorithm for password (scrypt by default).", example="scrypt")
    private String passHashAlg;
    @JsonIgnore
    @Schema(description="The user authentication certificate instance.", hidden=true)
    private Certificate certificate;
    @Schema(description="The user authentication certificate as base64 encoded string.", example="encoded")
    private String certificateEncoded;
    @Schema(description="Flag to indicate if the user got pre-authenticated by an external instance.", example="true")
    private Boolean preAuthenticated;
    @Schema(description="Two-factor authentication key generated before actual verification happens and actual sessionId is created. Will be returned in LoginResponseDto. Should be provided with verification code and credentials to get working session", example="secret")
    private String mfaKey;
    @Schema(description="Two-factor authentication verification code.", example="123456")
    private String verificationCode;
    @Schema(description="The language used by the frontend.", example="de")
    private String language;
    @Schema(description="Api key used for authentication without MFA. Also overrides credentials and certificate check.", example="secret")
    private String sesamApiKey;
    @JsonIgnore
    @Schema(description="Initially, the login name is the same as the username. However, when the username changes internally during authentication (localFullAccess), the login name will give us the original username.", hidden=true)
    private String loginName;
    @JsonIgnore
    @Schema(description="The IP of the client who initiated the authentication.", hidden=true)
    private String ip;
    @NotNull
    @Schema(description="The type of the session to be created.", example="DEFAULT", defaultValue="DEFAULT")
    private SessionType type = SessionType.DEFAULT;

    public void setUsername(String username) {
        assert (username != null);
        this.username = username;
        if (StringUtils.isBlank(this.loginName)) {
            this.loginName = username;
        }
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getSecret() {
        return this.secret;
    }

    @Generated
    public String getPassHashAlg() {
        return this.passHashAlg;
    }

    @Generated
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Generated
    public String getCertificateEncoded() {
        return this.certificateEncoded;
    }

    @Generated
    public Boolean getPreAuthenticated() {
        return this.preAuthenticated;
    }

    @Generated
    public String getMfaKey() {
        return this.mfaKey;
    }

    @Generated
    public String getVerificationCode() {
        return this.verificationCode;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public String getSesamApiKey() {
        return this.sesamApiKey;
    }

    @Generated
    public String getLoginName() {
        return this.loginName;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public SessionType getType() {
        return this.type;
    }

    @Generated
    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Generated
    public void setPassHashAlg(String passHashAlg) {
        this.passHashAlg = passHashAlg;
    }

    @JsonIgnore
    @Generated
    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    @Generated
    public void setCertificateEncoded(String certificateEncoded) {
        this.certificateEncoded = certificateEncoded;
    }

    @Generated
    public void setPreAuthenticated(Boolean preAuthenticated) {
        this.preAuthenticated = preAuthenticated;
    }

    @Generated
    public void setMfaKey(String mfaKey) {
        this.mfaKey = mfaKey;
    }

    @Generated
    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setSesamApiKey(String sesamApiKey) {
        this.sesamApiKey = sesamApiKey;
    }

    @JsonIgnore
    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setType(SessionType type) {
        this.type = type;
    }

    @Generated
    public LoginDto() {
    }
}

