/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.core.types.MfaType;
import de.sep.sesam.model.type.UserOrigin;
import de.sep.sesam.model.utils.ModelUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class Users
extends AbstractModelEntity<Long>
implements IDisplayLabelProvider,
ILongEntity,
MtimeEntity<Long>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = -8923905415453487167L;
    @JsonIgnore
    private static final Comparator<Users> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getDisplayLabel() == null && o2 != null && o2.getDisplayLabel() == null) {
            return 0;
        }
        if (o1 == null || o1.getDisplayLabel() == null) {
            return -1;
        }
        if (o2 == null || o2.getDisplayLabel() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getDisplayLabel().compareToIgnoreCase(o2.getDisplayLabel()) : o1.getDisplayLabel().compareTo(o2.getDisplayLabel());
    };
    @Schema(description="The unique ID of the user.", example="1")
    private Long id;
    @NotNull
    @Length(max=255)
    @Schema(description="The name of the user.", example="admin")
    private @NotNull @Length(max=255) String name;
    @NotNull
    @Length(max=512)
    @Schema(description="The password of the user.", example="<PASSWORD>")
    private @NotNull @Length(max=512) String password;
    @Schema(description="Flag to indicate if the user account has been expired.", example="false")
    private Boolean accountExpired;
    @Schema(description="Flag to indicate if the user account has been locked.", example="false")
    private Boolean locked;
    @Schema(description="Flag to indicate if the user password has been expired.", example="false")
    private Boolean passwordExpired;
    @Schema(description="The date and time when the user account has been expired.", example="1719486000000")
    private Date passwordExpireDate;
    @Schema(description="Flag to indicate if the user account is enabled.", example="true")
    private Boolean enabled;
    @Schema(description="The origin of the user. Valid values are \u2018SYSTEM\u2019, \u2018INTERNAL\u2019, \u2018POLICY\u2019, \u2018LDAP\u2019, \u2018AD\u2019 and \u2018USER\u2019.")
    private UserOrigin origin;
    @Schema(description="Flag to indicate if the user was created from the Java policy.", example="false")
    private Boolean fromJavaPolicy;
    @Schema(description="Flag to indicate if the user can log in from the given host.", example="false")
    private Boolean allowHostAuth;
    @Length(max=128)
    @Schema(description="The email address of the user.", example="<EMAIL>")
    private @Length(max=128) String email;
    @Length(max=1024)
    @Schema(description="The comment or note from Sesam.")
    private @Length(max=1024) String comment;
    @Length(max=1024)
    @Schema(description="The comment or note from the user.")
    private @Length(max=1024) String usercomment;
    @Schema(description="The date and time when the user was last changed.", example="1719486000000")
    private Date dateChanged;
    @Schema(description="The date and time when the user was created.", example="1719486000000")
    private Date dateCreated;
    @Schema(description="The unique ID or name of the entity or user, who has changed the user account last.", example="admin")
    @Length(max=128)
    private @Length(max=128) String changedBy;
    @Length(max=255)
    @JsonIgnore
    @Schema(description="The salt used to encrypt the user password.", example="salt")
    private @Length(max=255) String salt;
    @Length(max=255)
    @Schema(description="The salt used to encrypt the user password provided by the user when creating a new user via the CLI.", example="salt")
    private @Length(max=255) String userSalt;
    @Length(max=8192)
    @Schema(description="The thumbprint of the user certificate.", example="thumbprint")
    private @Length(max=8192) String thumbprint;
    @Length(max=8192)
    @Schema(description="The API access key of the user.", example="apiAccessKey")
    private @Length(max=8192) String apiAccessKey;
    @Schema(description="The mfa type describes in which state multifactor authentication is in. It got OFF, OTP, CERTIFCATE and EMAIL", example="OTP")
    private MfaType mfaType;
    @Length(max=8192)
    @JsonIgnore
    @Schema(description="The mfa secret used to generate the OTP or the email password", example="mfaSecret")
    private @Length(max=8192) String mfaSecret;
    @Schema(description="Flag to indicate if the user has registered for multifactor authentication.", example="false")
    private Boolean mfaRegistrationDone;
    @Schema(description="The timestamp of the last modification of the record.", example="1719486000000")
    private Date mtime;
    @Schema(description="Flag to indicate if the api key is generated or not.", example="false")
    private Boolean generateApiKey;
    @Schema(description="Flag to indicate if the api key has been removed or not.", example="false")
    private Boolean removeApiKey;
    @Length(max=40)
    @Schema(description="The unique ID of the user.", example="1")
    private @Length(max=40) String uuid;

    @JsonIgnore
    public static Comparator<Users> sorter() {
        return comparator;
    }

    public Users(Users u) {
        assert (u != null);
        ModelUtils.copyProperties(this, u);
        this.setSalt(u.getSalt());
        this.setMfaSecret(u.getMfaSecret());
    }

    public boolean isFromJavaPolicy() {
        return this.fromJavaPolicy != null && this.fromJavaPolicy != false;
    }

    public void setFromJavaPolicy(boolean fromJavaPolicy) {
        this.fromJavaPolicy = fromJavaPolicy ? Boolean.TRUE : null;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Boolean getAccountExpired() {
        return this.accountExpired;
    }

    @Generated
    public Boolean getLocked() {
        return this.locked;
    }

    @Generated
    public Boolean getPasswordExpired() {
        return this.passwordExpired;
    }

    @Generated
    public Date getPasswordExpireDate() {
        return this.passwordExpireDate;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public UserOrigin getOrigin() {
        return this.origin;
    }

    @Generated
    public Boolean getAllowHostAuth() {
        return this.allowHostAuth;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public Date getDateChanged() {
        return this.dateChanged;
    }

    @Generated
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @Generated
    public String getChangedBy() {
        return this.changedBy;
    }

    @Generated
    public String getSalt() {
        return this.salt;
    }

    @Generated
    public String getUserSalt() {
        return this.userSalt;
    }

    @Generated
    public String getThumbprint() {
        return this.thumbprint;
    }

    @Generated
    public String getApiAccessKey() {
        return this.apiAccessKey;
    }

    @Generated
    public MfaType getMfaType() {
        return this.mfaType;
    }

    @Generated
    public String getMfaSecret() {
        return this.mfaSecret;
    }

    @Generated
    public Boolean getMfaRegistrationDone() {
        return this.mfaRegistrationDone;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public Boolean getGenerateApiKey() {
        return this.generateApiKey;
    }

    @Generated
    public Boolean getRemoveApiKey() {
        return this.removeApiKey;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setAccountExpired(Boolean accountExpired) {
        this.accountExpired = accountExpired;
    }

    @Generated
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    @Generated
    public void setPasswordExpired(Boolean passwordExpired) {
        this.passwordExpired = passwordExpired;
    }

    @Generated
    public void setPasswordExpireDate(Date passwordExpireDate) {
        this.passwordExpireDate = passwordExpireDate;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setOrigin(UserOrigin origin) {
        this.origin = origin;
    }

    @Generated
    public void setAllowHostAuth(Boolean allowHostAuth) {
        this.allowHostAuth = allowHostAuth;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setDateChanged(Date dateChanged) {
        this.dateChanged = dateChanged;
    }

    @Generated
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Generated
    public void setChangedBy(String changedBy) {
        this.changedBy = changedBy;
    }

    @JsonIgnore
    @Generated
    public void setSalt(String salt) {
        this.salt = salt;
    }

    @Generated
    public void setUserSalt(String userSalt) {
        this.userSalt = userSalt;
    }

    @Generated
    public void setThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
    }

    @Generated
    public void setApiAccessKey(String apiAccessKey) {
        this.apiAccessKey = apiAccessKey;
    }

    @Generated
    public void setMfaType(MfaType mfaType) {
        this.mfaType = mfaType;
    }

    @JsonIgnore
    @Generated
    public void setMfaSecret(String mfaSecret) {
        this.mfaSecret = mfaSecret;
    }

    @Generated
    public void setMfaRegistrationDone(Boolean mfaRegistrationDone) {
        this.mfaRegistrationDone = mfaRegistrationDone;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setGenerateApiKey(Boolean generateApiKey) {
        this.generateApiKey = generateApiKey;
    }

    @Generated
    public void setRemoveApiKey(Boolean removeApiKey) {
        this.removeApiKey = removeApiKey;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public Users() {
    }
}

