/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.sep.sesam.common.date.DateUtils;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.EventType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class Terms
extends AbstractModelEntity<Long>
implements ILongEntity,
MtimeEntity<Long>,
IDisplayLabelProvider {
    @JsonIgnore
    private static final long serialVersionUID = 1366147705019770068L;
    @JsonIgnore
    private static final Comparator<Terms> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        return o1.getId().compareTo(o2.getId());
    };
    @NotNull
    @JsonSerialize(using=ToStringSerializer.class)
    @JsonDeserialize(as=Long.class)
    @Schema(description="The ID.", example="20250512110710459")
    private Long id;
    @NotNull
    @Schema(description="The type of the term.", example="N")
    private EventType eventType;
    @NotNull
    @Length(max=30)
    @Schema(description="The schedule of the term.", example="Weekly")
    private @NotNull @Length(max=30) String schedule;
    @Length(max=64)
    @Schema(description="The event of the term.")
    private @Length(max=64) String event;
    @Schema(description="The next execution date of the term.", example="2025-05-12T11:07:10Z")
    private Date nextExec;
    @Schema(description="The next execution date of the term.", example="2025-05-12T11:07:10Z")
    private Date afterNextExec;
    @Schema(description="The next end date of the term.", example="2025-05-12T11:07:10Z")
    private Date nextEnd;
    @Schema(description="The next stop date of the term.", example="2025-05-12T11:07:10Z")
    private Date nextStop;
    @Schema(description="Indicates whether the term is visible for the user.", example="true")
    private Boolean visible;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<Terms> sorter() {
        return comparator;
    }

    public Terms(Long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return DateUtils.dateToDateTimeStr(this.nextExec, 2);
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public EventType getEventType() {
        return this.eventType;
    }

    @Generated
    public String getSchedule() {
        return this.schedule;
    }

    @Generated
    public String getEvent() {
        return this.event;
    }

    @Generated
    public Date getNextExec() {
        return this.nextExec;
    }

    @Generated
    public Date getAfterNextExec() {
        return this.afterNextExec;
    }

    @Generated
    public Date getNextEnd() {
        return this.nextEnd;
    }

    @Generated
    public Date getNextStop() {
        return this.nextStop;
    }

    @Generated
    public Boolean getVisible() {
        return this.visible;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonDeserialize(as=Long.class)
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setEvent(String event) {
        this.event = event;
    }

    @Generated
    public void setNextExec(Date nextExec) {
        this.nextExec = nextExec;
    }

    @Generated
    public void setAfterNextExec(Date afterNextExec) {
        this.afterNextExec = afterNextExec;
    }

    @Generated
    public void setNextEnd(Date nextEnd) {
        this.nextEnd = nextEnd;
    }

    @Generated
    public void setNextStop(Date nextStop) {
        this.nextStop = nextStop;
    }

    @Generated
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public Terms() {
    }
}

