/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.sep.sesam.model.Clients;
import de.sep.sesam.model.TaskTypes;
import de.sep.sesam.model.browser.dto.FileDto;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.ICredentialsProvider;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.core.types.BackupType;
import de.sep.sesam.model.type.BsrFlagType;
import de.sep.sesam.model.type.CryptFlagType;
import de.sep.sesam.model.type.ExcludeType;
import de.sep.sesam.model.type.GranularityType;
import de.sep.sesam.model.type.PrePost;
import de.sep.sesam.model.type.StateType;
import de.sep.sesam.model.type.TaskSts;
import de.sep.sesam.model.type.TasksSnapshotFlags;
import de.sep.sesam.model.type.TasksSubType;
import de.sep.sesam.model.vms.dto.VMDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;
import net.sf.oval.constraint.NotEmpty;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Tasks
extends AbstractModelEntity<String>
implements IStringEntity,
IDisplayLabelProvider,
MtimeEntity<String>,
INamedEntity,
ICredentialsProvider {
    @JsonIgnore
    private static final long serialVersionUID = -6350710901497433241L;
    @JsonIgnore
    public static final int MAX_NAME_LENGTH = 50;
    @JsonIgnore
    public static final int MAX_NDMP_NAME_LENGTH = 31;
    @JsonIgnore
    public static final String DEFAULT_TASK_NAME_TEMPLATE = "{{toLower client}}_{{task_type_short}}{{underPrefix source}}";
    @JsonIgnore
    private static final Comparator<Tasks> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @NotNull
    @Length(max=50)
    @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"})
    @Schema(description="The backup task name. Must be unique.", example="backup_client_backup_full")
    private @NotNull @Length(max=50) @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"}) String name;
    @NotNull
    @Schema(description="The backup type.", example="JIRA")
    private BackupType backupType;
    @JsonIgnore
    @Schema(description="The backup task type. The backup task type is an object from the \u2018task_types\u2019 database table.")
    private TaskTypes type;
    @Schema(description="The backup task sub type. Primarily used with virtualization backup task types, like \u201cVMware vSphere\u201d. Valid values are \u2018_CONFIG\u2019 and \u2018_IMG\u2019.\n", example="_CBT")
    private TasksSubType subType;
    @NotNull
    @JsonIncludeProperties(value={"id", "name", "location", "operSystem", "permit"})
    @Schema(description="The client this task belongs to.")
    private Clients client;
    @Length(max=1024)
    @NotNull
    @NotEmpty
    @Schema(description="The source path", example="/home/user/backup/jira")
    private @Length(max=1024) @NotNull @NotEmpty String source;
    @Length(max=64)
    @Schema(description="The source encoding.", example="UTF-8")
    private @Length(max=64) String sourceEncoding;
    @Length(max=128)
    @Schema(description="The Uuid of the backup source.", example="f6a7b8c9-d0e1-2345-6789-0abcdef12345")
    private @Length(max=128) String sourceUuid;
    @Length(max=1024)
    @Schema(description="The comma separated list of backup source pattern to exclude", example="H:, I:, P:, S:, U:, Volume{60cf3502-3685-4c69-a746-d66ad049d2f0}, Volume{831d4403-8d72-4366-bd51-f52cbd913e48}, Z:")
    private @Length(max=1024) String exclude;
    @Length(max=16)
    @Schema(description="The type of the backup source exclude pattern. Valid values are \u2018pattern\u2019 and \u2018regexp\u2019. ", example="pattern")
    private @Length(max=16) ExcludeType excludeType;
    @Length(max=1024)
    @Schema(description="The comment or note from Sesam.")
    private @Length(max=1024) String sepcomment;
    @Schema(description="The status of the last backup run. Valid values are \u20180\u2019 (success), \u20182\u2019 (error), \u2018a\u2019 (active), \u2018q\u2019 (in queue) and more. This property is set by the Sesam kernel.", example="0")
    private StateType resultsSts;
    @Schema(description="Flag to force a FULL backup. When set to \u2018F\u2019, the next INCR or DIFF backup will be forced to run as FULL backup. The flag is reset by the Sesam kernel afterwards.", example="F")
    private TaskSts taskSts;
    @Schema(description="Flat to indicate if the task has been auto generated, in example by the task generation.", example="F")
    private Long autoGenerated;
    @Length(max=64)
    @Schema(description="The backup command to execute.")
    private @Length(max=64) String backupCmd;
    @Length(max=255)
    @Schema(description="The backup options to pass to the backup command. The options are passed as a single string, separated by spaces. The options are passed to the backup command as-is, without any processing.", example="-a trans=hotadd:san:nbd:nbdssl -v 3")
    private @Length(max=255) String backupOptions;
    @Length(max=512)
    @Schema(description="Options to pass on to the SEP sesam backup server process when starting a backup.")
    private @Length(max=512) String backupSrvOptions;
    @Length(max=255)
    @Schema(description="Options to pass on to the SEP sesam restore process when starting a restore.", example="-a osuser=postgres")
    private @Length(max=255) String restoreOptions;
    @Length(max=512)
    @Schema(description="Options to pass on to the SEP sesam restore server process when starting a restore.")
    private @Length(max=512) String restoreSrvOptions;
    @Schema(description="A 4 character string controlling the pre/post backup behavior. The valid values for each\ncharacter are \u2018y\u2019 (yes) or \u2018n\u2019 (no). The meaning of the characters are:\n5. activate pre interface\n6. execute backup despite pre error\n7. activate post interface\n8. execute post despite backup error")
    private PrePost prepost;
    @Schema(description="A 4 character string controlling the pre/post restore behavior. The valid values for each\ncharacter are \u2018y\u2019 (yes) or \u2018n\u2019 (no). The meaning of the characters are:\n1. activate pre interface\n2. execute restore despite pre error\n3. activate post interface\n4. execute post despite restore error\n")
    private PrePost rPrepost;
    @Schema(description="Flag to control if data stored on NFS mounted paths are included or not.", example="true")
    private Boolean nfsMount;
    @Length(max=2)
    @Schema(description="Flag to control if multiple sources are used for the backup task.")
    private @Length(max=2) String multiSource;
    @Length(max=512)
    private @Length(max=512) String multiSourceType;
    @Schema(description="Flag to control if the backup process shall stop (false) or cross (true) file system boundaries.", example="true")
    private Boolean filesystem;
    @Schema(description="Flag to control the granularity for mail system backups. Valid values are \u2018all\u2019, \u2018mailbox\u2019 or \u2018folder\u2019", example="all")
    private GranularityType granularity;
    @Schema(description="Flag to control the depth of the bare system recovery backup. Valid values are \u20180\u2019 (off), \u20181\u2019 (minimal system backup), \u20182\u2019 (system volume backup) and \u20183\u2019 (full local system backup).", example="0")
    private BsrFlagType bsrFlag;
    @Schema(description="Flag to control if the backup process shall compress the backup data or not.", example="true")
    private Boolean compressFlag;
    @Schema(description="Flag to control if the backup process shall encrypt the backup data or not.", example="a")
    private CryptFlagType cryptFlag;
    @Length(max=128)
    @Schema(description="The encrypted encryption key to encrypt the backup data with.")
    private @Length(max=128) String cryptKey;
    @Schema(description="Flag to control if the backup process shall save the encryption key in the database or not.", example="true")
    private Boolean cryptSavekeyFlag;
    @Schema(description="The snapshot type used.", example="LVM")
    private TasksSnapshotFlags snapshotFlags;
    @Schema(description="The host name or IP address of the data mover to use.", example="TEST_Client")
    private String dataMover;
    @Schema(description="The id of the data mover to use.", example="123456789")
    private Long dataMoverId;
    @Length(max=40)
    @Schema(description="The UUID of the vcenter client to use.", example="12345678-9abc-def0-1234-56789abcdef0")
    private @Length(max=40) String vclientUuid;
    @Schema(description="Flag to control if the backup process shall run on a node or not.", example="true")
    private Boolean nodeFlag;
    @Length(max=8)
    @Schema(description="The preffered Mode.")
    private @Length(max=8) String preferredMode;
    @Schema(description="Flag to control if the backup process shall allow other Modes or not.", example="true")
    private Boolean allowOtherMode;
    @Schema(description="The id of the credential to use for the backup task.", example="123456789")
    private Long credentialId;
    @Length(max=40)
    @Schema(description="The UUID of the credential to use for the backup task.", example="12345678-9abc-def0-1234-56789abcdef0")
    private @Length(max=40) String credentialUuid;
    @Length(max=255)
    @Schema(description="The user name to use for connecting to the client.", example="backup_user")
    private @Length(max=255) String userName;
    @Length(max=512)
    @Schema(description="The password to use for connecting to the client.", example="<PASSWORD>")
    private @Length(max=512) String password;
    @Schema(description="Flag to control if the backup process shall be executed or not.", example="true")
    private Boolean exec;
    @Length(max=64)
    @Schema(description="The id of the last executed FULL backup. This property is set by the Sesam kernel.", example="SF20250512134732471@wPn1T35mn95")
    private @Length(max=64) String lastFullBackup;
    @Length(max=64)
    @Schema(description="The id of the last executed DIFF backup. This property is set by the Sesam kernel.", example="SD20250523140004546@1NyQgjH3f08")
    private @Length(max=64) String lastDiffBackup;
    @Length(max=64)
    @Schema(description="The id of the last executed INC backup. This property is set by the Sesam kernel.", example="SI20250523140004546@1NyQgjH3f08")
    private @Length(max=64) String lastIncrBackup;
    @Length(max=64)
    @Schema(description="The id of the last executed FDI backup. This property is set by the Sesam kernel.", example="SF20250523140004546@1NyQgjH3f08")
    private @Length(max=64) String lastFdiBackup;
    @Length(max=64)
    @Schema(description="The id of the last executed COPY backup. This property is set by the Sesam kernel.", example="SC20250523140004546@1NyQgjH3f08")
    private @Length(max=64) String lastCopyBackup;
    @Length(max=1024)
    @Schema(description="The comment or note from the user.", example="This is a test comment.")
    private @Length(max=1024) String usercomment;
    @Schema(description="The creation time of the backup task.", example="2025-05-12T13:47:32.471Z")
    private Date creationTime;
    @Schema(description="The modification time of the backup task.", example="2025-05-12T13:47:32.471Z")
    private Date mtime;
    @Length(max=40)
    @Schema(description="The UUID of the backup task.", example="12345678-9abc-def0-1234-56789abcdef0")
    private @Length(max=40) String uuid;
    @Schema(description="The VM data of the VM task.")
    private VMDto vmDto;
    @Schema(description="The browsed files, which represented a task.")
    private FileDto fileDto;
    @Schema(description="The order of the task in a task group.")
    private Long taskOrder;
    @Schema(description="The task group the task belongs to.")
    private String[] taskGroups;
    @Schema(description="Flag to mark if a backup task is orphaned. Orphaned means that backups for this backup task still exist but the backup task object has been deleted.", example="true")
    private Boolean orphaned;
    @Schema(description="Flag to mark if the license check on create shall be skipped and the task be created in any case.", example="true")
    private Boolean skipLicenseCheck;

    @JsonIgnore
    public static Comparator<Tasks> sorter() {
        return comparator;
    }

    public Tasks(String name) {
        this.name = name;
    }

    public PrePost getrPrepost() {
        return this.rPrepost;
    }

    public void setrPrepost(PrePost rPrepost) {
        this.rPrepost = rPrepost;
    }

    @JsonProperty(value="type")
    public void setType(TaskTypes type) {
        this.backupType = type == null ? null : type.getBackupType();
        this.type = type;
    }

    @JsonIgnore
    public String getShortType() {
        if (this.getType() == null) {
            return null;
        }
        String shortName = this.getType().getShortName();
        if (StringUtils.isBlank(shortName) && StringUtils.isNotBlank(shortName = this.getType().getName())) {
            shortName = shortName.toLowerCase().replaceAll("\\s", "_");
        }
        return shortName;
    }

    @JsonIgnore
    public String getLastSource() {
        if (StringUtils.isBlank(this.getSource())) {
            return null;
        }
        String[] parts = this.getSource().split("/");
        return ArrayUtils.isNotEmpty(parts) ? parts[parts.length - 1] : null;
    }

    @JsonIgnore
    public String getSourceSegment(int pos) {
        if (StringUtils.isBlank(this.getSource())) {
            return null;
        }
        String[] segments = this.getSource().split("/");
        ArrayList<String> lWithoutEmptyFields = new ArrayList<String>();
        for (String s : segments) {
            if (!StringUtils.isNotBlank(s)) continue;
            lWithoutEmptyFields.add(s);
        }
        segments = lWithoutEmptyFields.toArray(new String[0]);
        String retVal = null;
        if (pos >= 0 && pos < segments.length) {
            retVal = segments[pos];
        } else if (pos < 0 && segments.length - Math.abs(pos) >= 0) {
            retVal = segments[segments.length - Math.abs(pos)];
        }
        return retVal;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.getName();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public BackupType getBackupType() {
        return this.backupType;
    }

    @Generated
    public TaskTypes getType() {
        return this.type;
    }

    @Generated
    public TasksSubType getSubType() {
        return this.subType;
    }

    @Generated
    public Clients getClient() {
        return this.client;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    @Generated
    public String getSourceUuid() {
        return this.sourceUuid;
    }

    @Generated
    public String getExclude() {
        return this.exclude;
    }

    @Generated
    public ExcludeType getExcludeType() {
        return this.excludeType;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public StateType getResultsSts() {
        return this.resultsSts;
    }

    @Generated
    public TaskSts getTaskSts() {
        return this.taskSts;
    }

    @Generated
    public Long getAutoGenerated() {
        return this.autoGenerated;
    }

    @Generated
    public String getBackupCmd() {
        return this.backupCmd;
    }

    @Generated
    public String getBackupOptions() {
        return this.backupOptions;
    }

    @Generated
    public String getBackupSrvOptions() {
        return this.backupSrvOptions;
    }

    @Generated
    public String getRestoreOptions() {
        return this.restoreOptions;
    }

    @Generated
    public String getRestoreSrvOptions() {
        return this.restoreSrvOptions;
    }

    @Generated
    public PrePost getPrepost() {
        return this.prepost;
    }

    @Generated
    public Boolean getNfsMount() {
        return this.nfsMount;
    }

    @Generated
    public String getMultiSource() {
        return this.multiSource;
    }

    @Generated
    public String getMultiSourceType() {
        return this.multiSourceType;
    }

    @Generated
    public Boolean getFilesystem() {
        return this.filesystem;
    }

    @Generated
    public GranularityType getGranularity() {
        return this.granularity;
    }

    @Generated
    public BsrFlagType getBsrFlag() {
        return this.bsrFlag;
    }

    @Generated
    public Boolean getCompressFlag() {
        return this.compressFlag;
    }

    @Generated
    public CryptFlagType getCryptFlag() {
        return this.cryptFlag;
    }

    @Generated
    public String getCryptKey() {
        return this.cryptKey;
    }

    @Generated
    public Boolean getCryptSavekeyFlag() {
        return this.cryptSavekeyFlag;
    }

    @Generated
    public TasksSnapshotFlags getSnapshotFlags() {
        return this.snapshotFlags;
    }

    @Generated
    public String getDataMover() {
        return this.dataMover;
    }

    @Generated
    public Long getDataMoverId() {
        return this.dataMoverId;
    }

    @Generated
    public String getVclientUuid() {
        return this.vclientUuid;
    }

    @Generated
    public Boolean getNodeFlag() {
        return this.nodeFlag;
    }

    @Generated
    public String getPreferredMode() {
        return this.preferredMode;
    }

    @Generated
    public Boolean getAllowOtherMode() {
        return this.allowOtherMode;
    }

    @Override
    @Generated
    public Long getCredentialId() {
        return this.credentialId;
    }

    @Override
    @Generated
    public String getCredentialUuid() {
        return this.credentialUuid;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Boolean getExec() {
        return this.exec;
    }

    @Generated
    public String getLastFullBackup() {
        return this.lastFullBackup;
    }

    @Generated
    public String getLastDiffBackup() {
        return this.lastDiffBackup;
    }

    @Generated
    public String getLastIncrBackup() {
        return this.lastIncrBackup;
    }

    @Generated
    public String getLastFdiBackup() {
        return this.lastFdiBackup;
    }

    @Generated
    public String getLastCopyBackup() {
        return this.lastCopyBackup;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public VMDto getVmDto() {
        return this.vmDto;
    }

    @Generated
    public FileDto getFileDto() {
        return this.fileDto;
    }

    @Generated
    public Long getTaskOrder() {
        return this.taskOrder;
    }

    @Generated
    public String[] getTaskGroups() {
        return this.taskGroups;
    }

    @Generated
    public Boolean getOrphaned() {
        return this.orphaned;
    }

    @Generated
    public Boolean getSkipLicenseCheck() {
        return this.skipLicenseCheck;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setBackupType(BackupType backupType) {
        this.backupType = backupType;
    }

    @Generated
    public void setSubType(TasksSubType subType) {
        this.subType = subType;
    }

    @Generated
    public void setClient(Clients client) {
        this.client = client;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    @Generated
    public void setSourceUuid(String sourceUuid) {
        this.sourceUuid = sourceUuid;
    }

    @Generated
    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    @Generated
    public void setExcludeType(ExcludeType excludeType) {
        this.excludeType = excludeType;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setResultsSts(StateType resultsSts) {
        this.resultsSts = resultsSts;
    }

    @Generated
    public void setTaskSts(TaskSts taskSts) {
        this.taskSts = taskSts;
    }

    @Generated
    public void setAutoGenerated(Long autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    @Generated
    public void setBackupCmd(String backupCmd) {
        this.backupCmd = backupCmd;
    }

    @Generated
    public void setBackupOptions(String backupOptions) {
        this.backupOptions = backupOptions;
    }

    @Generated
    public void setBackupSrvOptions(String backupSrvOptions) {
        this.backupSrvOptions = backupSrvOptions;
    }

    @Generated
    public void setRestoreOptions(String restoreOptions) {
        this.restoreOptions = restoreOptions;
    }

    @Generated
    public void setRestoreSrvOptions(String restoreSrvOptions) {
        this.restoreSrvOptions = restoreSrvOptions;
    }

    @Generated
    public void setPrepost(PrePost prepost) {
        this.prepost = prepost;
    }

    @Generated
    public void setNfsMount(Boolean nfsMount) {
        this.nfsMount = nfsMount;
    }

    @Generated
    public void setMultiSource(String multiSource) {
        this.multiSource = multiSource;
    }

    @Generated
    public void setMultiSourceType(String multiSourceType) {
        this.multiSourceType = multiSourceType;
    }

    @Generated
    public void setFilesystem(Boolean filesystem) {
        this.filesystem = filesystem;
    }

    @Generated
    public void setGranularity(GranularityType granularity) {
        this.granularity = granularity;
    }

    @Generated
    public void setBsrFlag(BsrFlagType bsrFlag) {
        this.bsrFlag = bsrFlag;
    }

    @Generated
    public void setCompressFlag(Boolean compressFlag) {
        this.compressFlag = compressFlag;
    }

    @Generated
    public void setCryptFlag(CryptFlagType cryptFlag) {
        this.cryptFlag = cryptFlag;
    }

    @Generated
    public void setCryptKey(String cryptKey) {
        this.cryptKey = cryptKey;
    }

    @Generated
    public void setCryptSavekeyFlag(Boolean cryptSavekeyFlag) {
        this.cryptSavekeyFlag = cryptSavekeyFlag;
    }

    @Generated
    public void setSnapshotFlags(TasksSnapshotFlags snapshotFlags) {
        this.snapshotFlags = snapshotFlags;
    }

    @Generated
    public void setDataMover(String dataMover) {
        this.dataMover = dataMover;
    }

    @Generated
    public void setDataMoverId(Long dataMoverId) {
        this.dataMoverId = dataMoverId;
    }

    @Generated
    public void setVclientUuid(String vclientUuid) {
        this.vclientUuid = vclientUuid;
    }

    @Generated
    public void setNodeFlag(Boolean nodeFlag) {
        this.nodeFlag = nodeFlag;
    }

    @Generated
    public void setPreferredMode(String preferredMode) {
        this.preferredMode = preferredMode;
    }

    @Generated
    public void setAllowOtherMode(Boolean allowOtherMode) {
        this.allowOtherMode = allowOtherMode;
    }

    @Override
    @Generated
    public void setCredentialId(Long credentialId) {
        this.credentialId = credentialId;
    }

    @Override
    @Generated
    public void setCredentialUuid(String credentialUuid) {
        this.credentialUuid = credentialUuid;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setExec(Boolean exec) {
        this.exec = exec;
    }

    @Generated
    public void setLastFullBackup(String lastFullBackup) {
        this.lastFullBackup = lastFullBackup;
    }

    @Generated
    public void setLastDiffBackup(String lastDiffBackup) {
        this.lastDiffBackup = lastDiffBackup;
    }

    @Generated
    public void setLastIncrBackup(String lastIncrBackup) {
        this.lastIncrBackup = lastIncrBackup;
    }

    @Generated
    public void setLastFdiBackup(String lastFdiBackup) {
        this.lastFdiBackup = lastFdiBackup;
    }

    @Generated
    public void setLastCopyBackup(String lastCopyBackup) {
        this.lastCopyBackup = lastCopyBackup;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setVmDto(VMDto vmDto) {
        this.vmDto = vmDto;
    }

    @Generated
    public void setFileDto(FileDto fileDto) {
        this.fileDto = fileDto;
    }

    @Generated
    public void setTaskOrder(Long taskOrder) {
        this.taskOrder = taskOrder;
    }

    @Generated
    public void setTaskGroups(String[] taskGroups) {
        this.taskGroups = taskGroups;
    }

    @Generated
    public void setOrphaned(Boolean orphaned) {
        this.orphaned = orphaned;
    }

    @Generated
    public void setSkipLicenseCheck(Boolean skipLicenseCheck) {
        this.skipLicenseCheck = skipLicenseCheck;
    }

    @Generated
    public Tasks() {
    }
}

