/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class TaskTypesKey
extends AbstractSerializableObject
implements INamedEntity {
    private static final long serialVersionUID = -3408929788758792304L;
    @JsonIgnore
    private static final Comparator<TaskTypesKey> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @NotNull
    @Length(max=32)
    @Schema(description="The name of the task type.", example="INGRES")
    private @NotNull @Length(max=32) String name;
    @NotNull
    @Schema(description="The minimum version.", example="50100012")
    private Long minVersion;
    @Schema(description="The minimum application version.", example="0")
    @NotNull
    private Long minAppVersion;

    private TaskTypesKey(String backupType, Long minVersion, Long minAppVersion) {
        this.name = backupType;
        this.minVersion = minVersion;
        this.minAppVersion = minAppVersion;
    }

    public TaskTypesKey(String backupType) {
        this(backupType, 0L, 0L);
    }

    @JsonIgnore
    public static Comparator<TaskTypesKey> sorter() {
        return comparator;
    }

    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Long getMinVersion() {
        return this.minVersion;
    }

    @Generated
    public Long getMinAppVersion() {
        return this.minAppVersion;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMinVersion(Long minVersion) {
        this.minVersion = minVersion;
    }

    @Generated
    public void setMinAppVersion(Long minAppVersion) {
        this.minAppVersion = minAppVersion;
    }

    @Generated
    public TaskTypesKey() {
    }
}

