/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.text.I18n;
import de.sep.sesam.model.TaskTypesKey;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.core.types.BackupType;
import de.sep.sesam.model.type.Interpreter;
import de.sep.sesam.model.type.LoginType;
import de.sep.sesam.model.type.PrePost;
import de.sep.sesam.model.type.ProxyType;
import de.sep.sesam.model.type.TaskTypesMissingCFDI;
import de.sep.sesam.model.type.TaskTypesProtectionType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import org.apache.commons.lang3.StringUtils;

public class TaskTypes
extends AbstractModelEntity<TaskTypesKey>
implements MtimeEntity<TaskTypesKey>,
INamedEntity,
IDisplayLabelProvider {
    @JsonIgnore
    private static final long serialVersionUID = 9147960120581438131L;
    @JsonIgnore
    private static final Comparator<TaskTypes> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @JsonIgnore
    private static final Comparator<TaskTypes> comparatorMinVersion = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getMinVersion() == null && o2 != null && o2.getMinVersion() == null) {
            return 0;
        }
        if (o1 == null || o1.getMinVersion() == null) {
            return -1;
        }
        if (o2 == null || o2.getMinVersion() == null) {
            return 1;
        }
        return o1.getMinVersion().compareTo(o2.getMinVersion()) * -1;
    };
    @JsonIgnore
    private final TaskTypesKey pk = new TaskTypesKey();
    @Length(max=20)
    @Schema(description="The display name of the task type.", example="MaxDB")
    private @Length(max=20) String displayName;
    @Length(max=20)
    @Schema(description="The short name of the task type.", example="maxdb")
    private @Length(max=20) String shortName;
    @Length(max=20)
    @Schema(description="The backup command of the task type.", example="sbc")
    private @Length(max=20) String backupCmd;
    @Length(max=128)
    @Schema(description="The backup options of the task type.", example="-a trans=hotadd:san:nbd:nbdssl")
    private @Length(max=128) String backupOptions;
    @Schema(description="The prepost configuration")
    private PrePost prepost;
    @Length(max=20)
    @Schema(description="The prepost command of the task type.", example="sbc_")
    private @Length(max=20) String prepostCmd;
    @Length(max=20)
    @Schema(description="The restore command of the task type.", example="sbc")
    private @Length(max=20) String restoreCmd;
    @Length(max=128)
    @Schema(description="The restore options of the task type.", example="-a trans=hotadd:san:nbd:nbdssl")
    private @Length(max=128) String restoreOptions;
    @Schema(description="The restore prepost configuration", example="nnnn")
    private PrePost rPrepost;
    @Length(max=20)
    @Schema(description="The restore prepost command of the task type.", example="sbc_restore_")
    private @Length(max=20) String rPrepostCmd;
    @Length(max=64)
    @Schema(description="The source prefix to use for browsing.", example="ONE:")
    private @Length(max=64) String sourcePrefix;
    @Length(max=255)
    @Schema(description="The platform of the task type.", example="Linux")
    private @Length(max=255) String platform;
    @Length(max=255)
    @Schema(description="The operating systems of the task type.", example="Linux,Windows")
    private @Length(max=255) String operSystems;
    @Schema(description="Flag to indicate if the task type could save virtual machines", example="false")
    private Boolean isHypervisor;
    @Schema(description="The allowed proxy types.", example="u")
    private ProxyType proxy;
    @Length(max=32)
    @Schema(description="The flags of the task type.")
    private @Length(max=32) String flags;
    @Schema(description="The task type protection (bitfield). Valid bits are extern (0x1), unix (0x2), windows (0x4), netware (0x8) and ndmp (0x10).")
    private TaskTypesProtectionType suitablePlatform;
    @Length(max=255)
    @Schema(description="The comment or note from Sesam.")
    private @Length(max=255) String sepcomment;
    @Schema(description="The interpreter to use for the task type.", example="mtf")
    private Interpreter interpreter;
    @Length(max=1)
    @Schema(description="The multi source flag of the task type.", example="0")
    private @Length(max=1) String multiSource;
    @Schema(description="Flag to indicate if backup has been done by a external tool.", example="false")
    private Boolean backupExtern;
    @Schema(description="Flag to indicate if restore has been done by a external tool.", example="false")
    private Boolean restoreExtern;
    @Length(max=40)
    @Schema(description="The name of the external tool to use when \u2018restoreExtern\u2019 is set to \u2018y\u2019.", example="n")
    private @Length(max=40) String externalTool;
    @Schema(description="Flag to indicate if a restore as path is supported.", example="false")
    private Boolean restoreAsPath;
    @Schema(description="Flag to indicate if a online restore is supported.", example="false")
    private Boolean restoreOnline;
    @Schema(description="Flag to indicate if a plain restore is supported.", example="false")
    private Boolean restorePlain;
    @Schema(description="Flag to indicate if a recover restore is supported.", example="false")
    private Boolean restoreRecover;
    @Schema(description="Flag to indicate if a reloc restore is supported.", example="false")
    private Boolean restoreReloc;
    @Schema(description="Flag to indicate if a selective restore is supported.", example="false")
    private Boolean restoreSelective;
    @Schema(description="Flag to indicate if a restore has been started.", example="false")
    private Boolean restoreStart;
    @Schema(description="Flag to indicate if a restore has been done to a targetstore.", example="false")
    private Boolean restoreTargetstore;
    @Length(max=255)
    @Schema(description="A regular expression to match the allowed characters of a backup task source.", example=".*\\.db2")
    private @Length(max=255) String sourceMatchAllow;
    @Length(max=255)
    @Schema(description="A regular expression to match the denied characters of a backup task source.", example=".*\\.db2")
    private @Length(max=255) String sourceMatchDeny;
    @Schema(description="Flag to indicate if a all sources are supported.", example="false")
    private Boolean sourceAll;
    @Schema(description="Flag to indicate if a subtask is supported.", example="false")
    private Boolean subtaskFlag;
    @Schema(description="The subtask types of the task type.", example="_RCT,_NONE")
    @Length(max=255)
    private @Length(max=255) String subtaskTypes;
    @Schema(description="Flag to indicate if a online backup is supported.", example="false")
    private Boolean backupOnline;
    @Schema(description="The lisf of missing FDI types.\n", example="d")
    private TaskTypesMissingCFDI missingCfdi;
    @Length(max=16)
    @Schema(description="Flag to indicate if the task type supports encryption.", example="0")
    private @Length(max=16) String cryptCapable;
    @Schema(description="Flag to indicate if a login configuration is needed.", example="false")
    private Boolean loginFlag;
    @Schema(description="The login configuration type.", example="UP")
    private LoginType loginType;
    @Length(max=255)
    @Schema(description="The task name template to use when auto-generating the task name.", example="MaxDB %s")
    private @Length(max=255) String taskNameTemplate;
    @Schema(description="The modification time of the backup task.", example="2018-01-01 12:00:00")
    private Date mtime;

    @JsonIgnore
    public static Comparator<TaskTypes> sorter() {
        return comparator;
    }

    @JsonIgnore
    public static Comparator<TaskTypes> sorterMinVersion() {
        return comparatorMinVersion;
    }

    public TaskTypes(BackupType backupType) {
        this.setName(backupType != null ? backupType.toString() : null);
    }

    public TaskTypes(String name) {
        this.setName(name);
    }

    @Override
    public String getName() {
        return this.pk.getName();
    }

    public void setName(String name) {
        this.pk.setName(name);
    }

    public Long getMinVersion() {
        return this.pk.getMinVersion();
    }

    public void setMinVersion(Long minVersion) {
        this.pk.setMinVersion(minVersion);
    }

    public Long getMinAppVersion() {
        return this.pk.getMinAppVersion();
    }

    public void setMinAppVersion(Long minAppVersion) {
        this.pk.setMinAppVersion(minAppVersion);
    }

    @Override
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonIgnore
    public TaskTypesKey getPK() {
        return this.pk;
    }

    @JsonIgnore
    public BackupType getBackupType() {
        return BackupType.fromString(this.getName());
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        if (StringUtils.isNotBlank(this.displayName) && !StringUtils.equals(this.displayName, this.getName())) {
            return this.displayName;
        }
        Object label = this.getName();
        BackupType type = this.getBackupType();
        if (BackupType.PATH.equals((Object)type)) {
            label = I18n.get("TaskDialog.Dialog.PathBackup", new Object[0]);
        } else if (BackupType.NET_APP.equals((Object)type)) {
            label = I18n.get("TaskDialog.Dialog.NetApp", new Object[0]);
        } else if (BackupType.EXCHANGE_SERVER_SINGLE_MAILBOX.equals((Object)type)) {
            label = (String)label + " 2003";
        } else if (BackupType.SAP_R3.equals((Object)type)) {
            label = "SAP NetWeaver";
        } else if (BackupType.SYSTEM_RECOVERY.equals((Object)type)) {
            label = "System State";
        } else if (BackupType.BSR_WINDOWS.equals((Object)type)) {
            label = "Bare System Recovery";
        } else if (BackupType.LOTUS_NOTES.equals((Object)type)) {
            label = "HCL Domino";
        }
        return label;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getShortName() {
        return this.shortName;
    }

    @Generated
    public String getBackupCmd() {
        return this.backupCmd;
    }

    @Generated
    public String getBackupOptions() {
        return this.backupOptions;
    }

    @Generated
    public PrePost getPrepost() {
        return this.prepost;
    }

    @Generated
    public String getPrepostCmd() {
        return this.prepostCmd;
    }

    @Generated
    public String getRestoreCmd() {
        return this.restoreCmd;
    }

    @Generated
    public String getRestoreOptions() {
        return this.restoreOptions;
    }

    @Generated
    public PrePost getRPrepost() {
        return this.rPrepost;
    }

    @Generated
    public String getRPrepostCmd() {
        return this.rPrepostCmd;
    }

    @Generated
    public String getSourcePrefix() {
        return this.sourcePrefix;
    }

    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getOperSystems() {
        return this.operSystems;
    }

    @Generated
    public Boolean getIsHypervisor() {
        return this.isHypervisor;
    }

    @Generated
    public ProxyType getProxy() {
        return this.proxy;
    }

    @Generated
    public String getFlags() {
        return this.flags;
    }

    @Generated
    public TaskTypesProtectionType getSuitablePlatform() {
        return this.suitablePlatform;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    @Generated
    public String getMultiSource() {
        return this.multiSource;
    }

    @Generated
    public Boolean getBackupExtern() {
        return this.backupExtern;
    }

    @Generated
    public Boolean getRestoreExtern() {
        return this.restoreExtern;
    }

    @Generated
    public String getExternalTool() {
        return this.externalTool;
    }

    @Generated
    public Boolean getRestoreAsPath() {
        return this.restoreAsPath;
    }

    @Generated
    public Boolean getRestoreOnline() {
        return this.restoreOnline;
    }

    @Generated
    public Boolean getRestorePlain() {
        return this.restorePlain;
    }

    @Generated
    public Boolean getRestoreRecover() {
        return this.restoreRecover;
    }

    @Generated
    public Boolean getRestoreReloc() {
        return this.restoreReloc;
    }

    @Generated
    public Boolean getRestoreSelective() {
        return this.restoreSelective;
    }

    @Generated
    public Boolean getRestoreStart() {
        return this.restoreStart;
    }

    @Generated
    public Boolean getRestoreTargetstore() {
        return this.restoreTargetstore;
    }

    @Generated
    public String getSourceMatchAllow() {
        return this.sourceMatchAllow;
    }

    @Generated
    public String getSourceMatchDeny() {
        return this.sourceMatchDeny;
    }

    @Generated
    public Boolean getSourceAll() {
        return this.sourceAll;
    }

    @Generated
    public Boolean getSubtaskFlag() {
        return this.subtaskFlag;
    }

    @Generated
    public String getSubtaskTypes() {
        return this.subtaskTypes;
    }

    @Generated
    public Boolean getBackupOnline() {
        return this.backupOnline;
    }

    @Generated
    public TaskTypesMissingCFDI getMissingCfdi() {
        return this.missingCfdi;
    }

    @Generated
    public String getCryptCapable() {
        return this.cryptCapable;
    }

    @Generated
    public Boolean getLoginFlag() {
        return this.loginFlag;
    }

    @Generated
    public LoginType getLoginType() {
        return this.loginType;
    }

    @Generated
    public String getTaskNameTemplate() {
        return this.taskNameTemplate;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Generated
    public void setBackupCmd(String backupCmd) {
        this.backupCmd = backupCmd;
    }

    @Generated
    public void setBackupOptions(String backupOptions) {
        this.backupOptions = backupOptions;
    }

    @Generated
    public void setPrepost(PrePost prepost) {
        this.prepost = prepost;
    }

    @Generated
    public void setPrepostCmd(String prepostCmd) {
        this.prepostCmd = prepostCmd;
    }

    @Generated
    public void setRestoreCmd(String restoreCmd) {
        this.restoreCmd = restoreCmd;
    }

    @Generated
    public void setRestoreOptions(String restoreOptions) {
        this.restoreOptions = restoreOptions;
    }

    @Generated
    public void setRPrepost(PrePost rPrepost) {
        this.rPrepost = rPrepost;
    }

    @Generated
    public void setRPrepostCmd(String rPrepostCmd) {
        this.rPrepostCmd = rPrepostCmd;
    }

    @Generated
    public void setSourcePrefix(String sourcePrefix) {
        this.sourcePrefix = sourcePrefix;
    }

    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setOperSystems(String operSystems) {
        this.operSystems = operSystems;
    }

    @Generated
    public void setIsHypervisor(Boolean isHypervisor) {
        this.isHypervisor = isHypervisor;
    }

    @Generated
    public void setProxy(ProxyType proxy) {
        this.proxy = proxy;
    }

    @Generated
    public void setFlags(String flags) {
        this.flags = flags;
    }

    @Generated
    public void setSuitablePlatform(TaskTypesProtectionType suitablePlatform) {
        this.suitablePlatform = suitablePlatform;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Generated
    public void setMultiSource(String multiSource) {
        this.multiSource = multiSource;
    }

    @Generated
    public void setBackupExtern(Boolean backupExtern) {
        this.backupExtern = backupExtern;
    }

    @Generated
    public void setRestoreExtern(Boolean restoreExtern) {
        this.restoreExtern = restoreExtern;
    }

    @Generated
    public void setExternalTool(String externalTool) {
        this.externalTool = externalTool;
    }

    @Generated
    public void setRestoreAsPath(Boolean restoreAsPath) {
        this.restoreAsPath = restoreAsPath;
    }

    @Generated
    public void setRestoreOnline(Boolean restoreOnline) {
        this.restoreOnline = restoreOnline;
    }

    @Generated
    public void setRestorePlain(Boolean restorePlain) {
        this.restorePlain = restorePlain;
    }

    @Generated
    public void setRestoreRecover(Boolean restoreRecover) {
        this.restoreRecover = restoreRecover;
    }

    @Generated
    public void setRestoreReloc(Boolean restoreReloc) {
        this.restoreReloc = restoreReloc;
    }

    @Generated
    public void setRestoreSelective(Boolean restoreSelective) {
        this.restoreSelective = restoreSelective;
    }

    @Generated
    public void setRestoreStart(Boolean restoreStart) {
        this.restoreStart = restoreStart;
    }

    @Generated
    public void setRestoreTargetstore(Boolean restoreTargetstore) {
        this.restoreTargetstore = restoreTargetstore;
    }

    @Generated
    public void setSourceMatchAllow(String sourceMatchAllow) {
        this.sourceMatchAllow = sourceMatchAllow;
    }

    @Generated
    public void setSourceMatchDeny(String sourceMatchDeny) {
        this.sourceMatchDeny = sourceMatchDeny;
    }

    @Generated
    public void setSourceAll(Boolean sourceAll) {
        this.sourceAll = sourceAll;
    }

    @Generated
    public void setSubtaskFlag(Boolean subtaskFlag) {
        this.subtaskFlag = subtaskFlag;
    }

    @Generated
    public void setSubtaskTypes(String subtaskTypes) {
        this.subtaskTypes = subtaskTypes;
    }

    @Generated
    public void setBackupOnline(Boolean backupOnline) {
        this.backupOnline = backupOnline;
    }

    @Generated
    public void setMissingCfdi(TaskTypesMissingCFDI missingCfdi) {
        this.missingCfdi = missingCfdi;
    }

    @Generated
    public void setCryptCapable(String cryptCapable) {
        this.cryptCapable = cryptCapable;
    }

    @Generated
    public void setLoginFlag(Boolean loginFlag) {
        this.loginFlag = loginFlag;
    }

    @Generated
    public void setLoginType(LoginType loginType) {
        this.loginType = loginType;
    }

    @Generated
    public void setTaskNameTemplate(String taskNameTemplate) {
        this.taskNameTemplate = taskNameTemplate;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public TaskTypes() {
    }
}

