/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.Schedules;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.PrePost;
import de.sep.sesam.model.type.StateType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;
import net.sf.oval.constraint.NotNull;

public class TaskGroups
extends AbstractModelEntity<String>
implements IStringEntity,
IDisplayLabelProvider,
MtimeEntity<String>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = -8802572946522321424L;
    @JsonIgnore
    private static final Comparator<TaskGroups> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @NotNull
    @Length(max=64)
    @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"})
    @Schema(description="The name of the task group.", example="backup-group")
    private @NotNull @Length(max=64) @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"}) String name;
    @Length(max=1024)
    @Schema(description="The comment or note from Sesam.")
    private @Length(max=1024) String sepcomment;
    @Schema(description="If set, then parallel execution of backup tasks in a backup group is limited to the\nspecified number. If the specified number is set to 1, then backup tasks are\nexecuted sequentially.\n", example="1")
    private Long concurrency;
    @Schema(description="The status of the last backup run. Valid values are \u20180\u2019 (success), \u20182\u2019 (error), \u2018a\u2019 (active),\n\u2018q\u2019 (in queue) and more. This property is set by the Sesam kernel.", example="2")
    private StateType resultsSts;
    @Schema(description="A 4 character string controlling the pre/post backup behavior. The valid values for each\ncharacter are \u2018y\u2019 (yes) or \u2018n\u2019 (no). The meaning of the characters are:\n1. activate pre interface\n2. execute backup despite pre error\n3. activate post interface\n4. execute post despite backup error\n", example="y")
    private PrePost prepost;
    @Length(max=1)
    @Schema(description="Flag to indicate if the pre/post backup behavior is active or not.", example="y")
    private @Length(max=1) String prepostSwitch;
    @Schema(description="Flag to indicate if the backup group is enabled for execution.", example="true", defaultValue="true")
    private Boolean exec = Boolean.TRUE;
    @Length(max=1024)
    @Schema(description="The execution options.")
    private @Length(max=1024) String options;
    @Length(max=32)
    @Schema(description="The name of the associated backup type.", example="full")
    private @Length(max=32) String backupType;
    @Length(max=64)
    @Schema(description="The type of the task group.")
    private @Length(max=64) String groupType;
    @Length(max=255)
    @Schema(description="The name of the associated data mover.", example="backup-mover")
    private @Length(max=255) String dataMover;
    @Schema(description="The id of the associated data mover.", example="1234567890")
    private Long dataMoverId;
    @Schema(description="The ID of the data mover group to use. If set, the data mover group is used instead of a single data mover provided by the \u2018dataMover\u2019 property", example="1234567890")
    private Long dataMoverGroupId;
    @Schema(description="The ID of the client group to use.", example="1234567890")
    private Long clientGroupId;
    @Schema(description="The ID of the client to use.", example="1234567890")
    private Long clientId;
    @Length(max=2048)
    @Schema(description="The folder to use for the backup.")
    private @Length(max=2048) String folder;
    @Length(max=1024)
    @Schema(description="A comma separated list of paths to exclude from the backup.")
    private @Length(max=1024) String exclude;
    @Length(max=1024)
    @Schema(description="A comma separated list of paths to include in the backup. If not set, all paths are included.")
    private @Length(max=1024) String include;
    @Length(max=1024)
    private @Length(max=1024) String appAttributes;
    @Length(max=1024)
    @Schema(description="The comment or note from the user.", example="This is a test comment.")
    private @Length(max=1024) String usercomment;
    @Schema(description="The list of tasks which have to be added to the task group. At the moment only used in CLI.", example="[\"task1\", \"task2\"]")
    private String[] tasks;
    @Schema(description="The list of schedules which have to be added to the task group.", example="[\"schedule1\", \"schedule2\"]")
    private List<Schedules> schedules;
    @Schema(description="The start order for tasks which have to be added to the task group. At the moment only used in CLI.", example="1")
    private Long startOrder;
    @Schema(description="The unique identifier (UUID) for the task group.", example="f6a7b8c9-d0e1-2345-6789-0abcdef12345")
    @Length(max=40)
    private @Length(max=40) String uuid;
    @Schema(description="The modification time of the task group record from the database.", example="1720077461")
    private Date mtime;

    @JsonIgnore
    public static Comparator<TaskGroups> sorter() {
        return comparator;
    }

    public TaskGroups(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public Long getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public StateType getResultsSts() {
        return this.resultsSts;
    }

    @Generated
    public PrePost getPrepost() {
        return this.prepost;
    }

    @Generated
    public String getPrepostSwitch() {
        return this.prepostSwitch;
    }

    @Generated
    public Boolean getExec() {
        return this.exec;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public String getBackupType() {
        return this.backupType;
    }

    @Generated
    public String getGroupType() {
        return this.groupType;
    }

    @Generated
    public String getDataMover() {
        return this.dataMover;
    }

    @Generated
    public Long getDataMoverId() {
        return this.dataMoverId;
    }

    @Generated
    public Long getDataMoverGroupId() {
        return this.dataMoverGroupId;
    }

    @Generated
    public Long getClientGroupId() {
        return this.clientGroupId;
    }

    @Generated
    public Long getClientId() {
        return this.clientId;
    }

    @Generated
    public String getFolder() {
        return this.folder;
    }

    @Generated
    public String getExclude() {
        return this.exclude;
    }

    @Generated
    public String getInclude() {
        return this.include;
    }

    @Generated
    public String getAppAttributes() {
        return this.appAttributes;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public String[] getTasks() {
        return this.tasks;
    }

    @Generated
    public List<Schedules> getSchedules() {
        return this.schedules;
    }

    @Generated
    public Long getStartOrder() {
        return this.startOrder;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setConcurrency(Long concurrency) {
        this.concurrency = concurrency;
    }

    @Generated
    public void setResultsSts(StateType resultsSts) {
        this.resultsSts = resultsSts;
    }

    @Generated
    public void setPrepost(PrePost prepost) {
        this.prepost = prepost;
    }

    @Generated
    public void setPrepostSwitch(String prepostSwitch) {
        this.prepostSwitch = prepostSwitch;
    }

    @Generated
    public void setExec(Boolean exec) {
        this.exec = exec;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setBackupType(String backupType) {
        this.backupType = backupType;
    }

    @Generated
    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    @Generated
    public void setDataMover(String dataMover) {
        this.dataMover = dataMover;
    }

    @Generated
    public void setDataMoverId(Long dataMoverId) {
        this.dataMoverId = dataMoverId;
    }

    @Generated
    public void setDataMoverGroupId(Long dataMoverGroupId) {
        this.dataMoverGroupId = dataMoverGroupId;
    }

    @Generated
    public void setClientGroupId(Long clientGroupId) {
        this.clientGroupId = clientGroupId;
    }

    @Generated
    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setFolder(String folder) {
        this.folder = folder;
    }

    @Generated
    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    @Generated
    public void setInclude(String include) {
        this.include = include;
    }

    @Generated
    public void setAppAttributes(String appAttributes) {
        this.appAttributes = appAttributes;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setTasks(String[] tasks) {
        this.tasks = tasks;
    }

    @Generated
    public void setSchedules(List<Schedules> schedules) {
        this.schedules = schedules;
    }

    @Generated
    public void setStartOrder(Long startOrder) {
        this.startOrder = startOrder;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public TaskGroups() {
    }
}

