/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.sep.sesam.model.AllEvents;
import de.sep.sesam.model.HwDrives;
import de.sep.sesam.model.Interfaces;
import de.sep.sesam.model.MediaPools;
import de.sep.sesam.model.MigrationTasks;
import de.sep.sesam.model.core.AbstractEventsEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.dto.FileRow;
import de.sep.sesam.model.runtime.interfaces.IAllEventsAdaptable;
import de.sep.sesam.model.type.AllEventFlag;
import de.sep.sesam.model.type.CfdiType;
import de.sep.sesam.model.type.GroupMode;
import de.sep.sesam.model.type.ReferenceType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class TaskEvents
extends AbstractEventsEntity
implements IDisplayLabelProvider,
IAllEventsAdaptable,
MtimeEntity<Long>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 5936893221903055917L;
    @JsonIgnore
    private static final Comparator<TaskEvents> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        return o1.getId().compareTo(o2.getId());
    };
    @JsonIgnore
    private static final Comparator<TaskEvents> comparatorByName = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @NotNull
    @JsonSerialize(using=ToStringSerializer.class)
    @JsonDeserialize(as=Long.class)
    @Schema(description="The id of the task event.", example="20250512110710459")
    private Long id;
    @Length(max=255)
    @Schema(description="The name of the backup event. The name can contain only letters, digits, the \u2018-\u2018 and the \u2018_\u2019 character.", example="TestTask")
    private @Length(max=255) String name;
    @Length(max=64)
    @Schema(description="The name of the associated backup task.", example="TestTask")
    private @Length(max=64) String object;
    @Schema(description="Indicates whether the backup event is executed or not.", example="true")
    private Boolean exec;
    @Schema(description="The end of life of the backup event.", example="20250512110710459")
    private Long eol;
    @Length(max=30)
    @Schema(description="The name of the schedule the backup event is associated with.", example="TestSchedule")
    private @Length(max=30) String scheduleName;
    @Schema(description="The priority of the backup event.", example="1")
    private Long priority;
    @Schema(description="Flag to indicate if the backup event is a blocking event.", example="false")
    private Boolean suppress;
    @Length(max=1024)
    @Schema(description="The follow up actions to execute when the backup event finished successfully.")
    private @Length(max=1024) String followUp;
    @Schema(description="Flag to indicate if the associated object is a backup task (false) or a backup group (true).", example="false")
    private Boolean grpFlag;
    @Length(max=30)
    @Schema(description="The owner of the backup event.", example="TestUser")
    private @Length(max=30) String owner = System.getProperty("user.name");
    @Schema(description="The CFDI type to match.", example="D")
    private CfdiType fdiType;
    @Length(max=16)
    @Schema(description="The media pool to use for the backup event.", example="MP-Si3-Store")
    private @Length(max=16) String mediaPool;
    @Length(max=30)
    @Schema(description="The media label of the backup event.")
    private @Length(max=30) String mediaLabel;
    @Schema(description="The drive number of the backup event.", example="1")
    private Long driveNum;
    @Length(max=255)
    @Schema(description="The name of the client interface to use.")
    private @Length(max=255) String ifaceName;
    @Length(max=255)
    @Schema(description="The name of the server interface to use.")
    private @Length(max=255) String srvIfaceName;
    @Length(max=255)
    @Schema(description="The name of the data mover to use.", example="Test_Client")
    private @Length(max=255) String dataMover;
    @Schema(description="The id of the data mover to use.", example="1")
    private Long dataMoverId;
    @Length(max=21)
    @Schema(description="The maximum number of DIFF and/or INCREMENT backups before another FULL backup is forced.", example="1")
    private @Length(max=21) String maxSinceFull;
    @Schema(description="Flag to indicate if a FULL backup will be enforced. If set to true, this property does override the maxSinceFull property.", example="false")
    private Boolean enforceFull;
    @Length(max=49)
    @Schema(description="The name of the migration task to execute once the backup finished successfully.", example="TestMigrationTask")
    private @Length(max=49) String migrationTask;
    @Length(max=64)
    @Schema(description="The id of the backup.", example="20250512110710459")
    private @Length(max=64) String backupId;
    @Schema(description="The reference type. Valid values are \u2018START\u2019 and \u2018RESTART\u2019.", example="START")
    private ReferenceType referenceType;
    @Length(max=255)
    @Schema(description="The SSID of the reference backup event.", example="20250512110710459")
    private @Length(max=255) String referenceSsid;
    @Schema(description="Flag to indicate to backup the backup source, even if currently in use.", example="false")
    private Boolean onlineFlag;
    @Schema(description="Flag to indicate if source side deduplication is used for the backup.", example="false")
    private Boolean ssddFlag;
    @Length(max=128)
    @Schema(description="The options to use for the event.")
    private @Length(max=128) String options;
    @Length(max=1024)
    @Schema(description="The comment or note from Sesam.")
    private @Length(max=1024) String sepcomment;
    @Length(max=1024)
    @Schema(description="The comment or note from the user.")
    private @Length(max=1024) String usercomment;
    @Schema(description="Flag to indicate if the backup event is visible to the user or not.", example="true")
    private Boolean visible;
    @Schema(description="The time at which the sesam events object was modified at last.", example="20250512110710459")
    private Date mtime;
    @Schema(description="Flag to indicate if the backup event is an immediate backup or not.", example="false")
    private Boolean immediateFlag;
    @Schema(description="The list of directories to backup.")
    private List<FileRow> directoryList = new ArrayList<FileRow>();
    @JsonIgnore
    private MediaPools mediaPoolEntity;
    @JsonIgnore
    private HwDrives driveEntity;
    @JsonIgnore
    private Interfaces interfaceEntity;
    @JsonIgnore
    private MigrationTasks migrationTaskEntity;

    @JsonIgnore
    public static Comparator<TaskEvents> sorter() {
        return comparator;
    }

    @JsonIgnore
    public static Comparator<TaskEvents> sorterName() {
        return comparatorByName;
    }

    public TaskEvents(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public MediaPools getMediaPoolEntity() {
        if (this.mediaPoolEntity == null && StringUtils.isNotBlank(this.mediaPool)) {
            this.mediaPoolEntity = new MediaPools(this.mediaPool);
        }
        return this.mediaPoolEntity;
    }

    @JsonIgnore
    public void setMediaPoolEntity(MediaPools mediaPool) {
        this.mediaPoolEntity = mediaPool;
        this.mediaPool = mediaPool != null ? mediaPool.getName() : null;
    }

    @JsonIgnore
    public HwDrives getDriveEntity() {
        if (this.driveEntity == null && this.driveNum != null) {
            this.driveEntity = new HwDrives(this.driveNum);
        }
        return this.driveEntity;
    }

    @JsonIgnore
    public void setDriveEntity(HwDrives drive) {
        this.driveEntity = drive;
        this.driveNum = drive != null ? drive.getId() : null;
    }

    @JsonIgnore
    public Interfaces getInterfaceEntity() {
        if (this.interfaceEntity == null && StringUtils.isNotBlank(this.ifaceName)) {
            this.interfaceEntity = new Interfaces(this.ifaceName);
        }
        return this.interfaceEntity;
    }

    @JsonIgnore
    public void setInterfaceEntity(Interfaces iface) {
        this.interfaceEntity = iface;
        this.ifaceName = iface != null ? iface.getName() : null;
    }

    @JsonIgnore
    public MigrationTasks getMigrationTaskEntity() {
        if (this.migrationTaskEntity == null && StringUtils.isNotBlank(this.migrationTask)) {
            this.migrationTaskEntity = new MigrationTasks(this.migrationTask);
        }
        return this.migrationTaskEntity;
    }

    @JsonIgnore
    public void setMigrationTaskEntity(MigrationTasks migrationTask) {
        this.migrationTaskEntity = migrationTask;
        this.migrationTask = migrationTask != null ? migrationTask.getName() : null;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getObjectLabel() {
        return StringUtils.isNotBlank(this.object) ? this.object : "";
    }

    @Override
    @JsonIgnore
    public void fill(AllEvents event) {
        assert (event != null);
        event.setExec(this.getExec());
        event.setEol(this.getEol());
        event.setFollowUp(this.getFollowUp());
        event.setId(this.getId());
        event.setImmediateFlag(this.getImmediateFlag());
        event.setName(this.getName());
        event.setOwner(this.getOwner());
        event.setPriority(this.getPriority());
        event.setSuppress(this.getSuppress());
        event.setDriveNum(this.getDriveNum());
        event.setPoolName(this.getMediaPool());
        event.setIfaceName(this.getIfaceName());
        event.setDataMover(this.getDataMover());
        AllEventFlag type = new AllEventFlag(this.getFdiType().toString());
        type.setGroupMode(Boolean.TRUE.equals(this.getGrpFlag()) ? GroupMode.ENABLED : null);
        event.setType(type);
        event.setGrpFlag(this.getGrpFlag());
        event.setObject(this.getObject());
        if (type.getGroupMode() == null) {
            event.setSubTaskName(this.getObject());
        }
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Override
    @Generated
    public Boolean getExec() {
        return this.exec;
    }

    @Generated
    public Long getEol() {
        return this.eol;
    }

    @Override
    @Generated
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Override
    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public Boolean getSuppress() {
        return this.suppress;
    }

    @Generated
    public String getFollowUp() {
        return this.followUp;
    }

    @Generated
    public Boolean getGrpFlag() {
        return this.grpFlag;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public CfdiType getFdiType() {
        return this.fdiType;
    }

    @Generated
    public String getMediaPool() {
        return this.mediaPool;
    }

    @Generated
    public String getMediaLabel() {
        return this.mediaLabel;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public String getIfaceName() {
        return this.ifaceName;
    }

    @Generated
    public String getSrvIfaceName() {
        return this.srvIfaceName;
    }

    @Generated
    public String getDataMover() {
        return this.dataMover;
    }

    @Generated
    public Long getDataMoverId() {
        return this.dataMoverId;
    }

    @Generated
    public String getMaxSinceFull() {
        return this.maxSinceFull;
    }

    @Generated
    public Boolean getEnforceFull() {
        return this.enforceFull;
    }

    @Generated
    public String getMigrationTask() {
        return this.migrationTask;
    }

    @Generated
    public String getBackupId() {
        return this.backupId;
    }

    @Generated
    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public String getReferenceSsid() {
        return this.referenceSsid;
    }

    @Generated
    public Boolean getOnlineFlag() {
        return this.onlineFlag;
    }

    @Generated
    public Boolean getSsddFlag() {
        return this.ssddFlag;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Override
    @Generated
    public Boolean getVisible() {
        return this.visible;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @Generated
    public Boolean getImmediateFlag() {
        return this.immediateFlag;
    }

    @Generated
    public List<FileRow> getDirectoryList() {
        return this.directoryList;
    }

    @Override
    @JsonDeserialize(as=Long.class)
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Override
    @Generated
    public void setExec(Boolean exec) {
        this.exec = exec;
    }

    @Generated
    public void setEol(Long eol) {
        this.eol = eol;
    }

    @Override
    @Generated
    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setSuppress(Boolean suppress) {
        this.suppress = suppress;
    }

    @Generated
    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    @Generated
    public void setGrpFlag(Boolean grpFlag) {
        this.grpFlag = grpFlag;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setFdiType(CfdiType fdiType) {
        this.fdiType = fdiType;
    }

    @Generated
    public void setMediaPool(String mediaPool) {
        this.mediaPool = mediaPool;
    }

    @Generated
    public void setMediaLabel(String mediaLabel) {
        this.mediaLabel = mediaLabel;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setIfaceName(String ifaceName) {
        this.ifaceName = ifaceName;
    }

    @Generated
    public void setSrvIfaceName(String srvIfaceName) {
        this.srvIfaceName = srvIfaceName;
    }

    @Generated
    public void setDataMover(String dataMover) {
        this.dataMover = dataMover;
    }

    @Generated
    public void setDataMoverId(Long dataMoverId) {
        this.dataMoverId = dataMoverId;
    }

    @Generated
    public void setMaxSinceFull(String maxSinceFull) {
        this.maxSinceFull = maxSinceFull;
    }

    @Generated
    public void setEnforceFull(Boolean enforceFull) {
        this.enforceFull = enforceFull;
    }

    @Generated
    public void setMigrationTask(String migrationTask) {
        this.migrationTask = migrationTask;
    }

    @Generated
    public void setBackupId(String backupId) {
        this.backupId = backupId;
    }

    @Generated
    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setReferenceSsid(String referenceSsid) {
        this.referenceSsid = referenceSsid;
    }

    @Generated
    public void setOnlineFlag(Boolean onlineFlag) {
        this.onlineFlag = onlineFlag;
    }

    @Generated
    public void setSsddFlag(Boolean ssddFlag) {
        this.ssddFlag = ssddFlag;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Override
    @Generated
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Override
    @Generated
    public void setImmediateFlag(Boolean immediateFlag) {
        this.immediateFlag = immediateFlag;
    }

    @Generated
    public void setDirectoryList(List<FileRow> directoryList) {
        this.directoryList = directoryList;
    }

    @Generated
    public TaskEvents() {
    }
}

