/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSerializableObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class SyntaxesKey
extends AbstractSerializableObject {
    private static final long serialVersionUID = 838752423516374921L;
    @JsonIgnore
    private static final Comparator<SyntaxesKey> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getCommand() == null && o2 != null && o2.getCommand() == null) {
            return 0;
        }
        if (o1 == null || o1.getCommand() == null) {
            return -1;
        }
        if (o2 == null || o2.getCommand() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getCommand().compareToIgnoreCase(o2.getCommand()) : o1.getCommand().compareTo(o2.getCommand());
    };
    @NotNull
    @Schema(description="The operating system for which the syntax is valid.", example="Windows")
    private String operSystem;
    @NotNull
    @Length(max=32)
    @Schema(description="The command to execute.", example="SNAPSHOT-cmd")
    private @NotNull @Length(max=32) String command;

    @JsonIgnore
    public static Comparator<SyntaxesKey> sorter() {
        return comparator;
    }

    public String getDisplayLabel() {
        return this.command;
    }

    @Generated
    public String getOperSystem() {
        return this.operSystem;
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public void setOperSystem(String operSystem) {
        this.operSystem = operSystem;
    }

    @Generated
    public void setCommand(String command) {
        this.command = command;
    }

    @Generated
    public SyntaxesKey() {
    }
}

