/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.SyntaxesKey;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class Syntaxes
extends AbstractModelEntity<SyntaxesKey>
implements MtimeEntity<SyntaxesKey> {
    private static final long serialVersionUID = 5348360932303622832L;
    @JsonIgnore
    private static final Comparator<Syntaxes> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getSyntax() == null && o2 != null && o2.getSyntax() == null) {
            return 0;
        }
        if (o1 == null || o1.getSyntax() == null) {
            return -1;
        }
        if (o2 == null || o2.getSyntax() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getSyntax().compareToIgnoreCase(o2.getSyntax()) : o1.getSyntax().compareTo(o2.getSyntax());
    };
    @JsonIgnore
    private final SyntaxesKey pk = new SyntaxesKey();
    @NotNull
    @Length(max=64)
    @Schema(description="The syntax", example="mount")
    private @NotNull @Length(max=64) String syntax;
    @Schema(description="The time at which the sesam events object was modified at last.", example="2025-04-15 14:01:44")
    private Date mtime;

    @JsonIgnore
    public static Comparator<Syntaxes> sorter() {
        return comparator;
    }

    public final String getOperSystem() {
        return this.pk.getOperSystem();
    }

    public final void setOperSystem(String os) {
        this.pk.setOperSystem(os);
    }

    public final String getCommand() {
        return this.pk.getCommand();
    }

    public final void setCommand(String command) {
        this.pk.setCommand(command);
    }

    @Override
    @JsonIgnore
    public SyntaxesKey getPK() {
        return this.pk;
    }

    public String getDisplayLabel() {
        return this.pk.getCommand();
    }

    @Generated
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public Syntaxes() {
    }
}

