/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.SesamVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class SesamEvents
extends AbstractModelEntity<String>
implements IDisplayLabelProvider,
MtimeEntity<String> {
    @JsonIgnore
    private static final long serialVersionUID = -6579484965181125764L;
    @JsonIgnore
    private static final Comparator<SesamEvents> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getUuid() == null && o2 != null && o2.getUuid() == null) {
            return 0;
        }
        if (o1 == null || o1.getUuid() == null) {
            return -1;
        }
        if (o2 == null || o2.getUuid() == null) {
            return 1;
        }
        return o1.getUuid().compareTo(o2.getUuid());
    };
    @NotNull
    @Length(max=40)
    @Schema(description="The unique ID of the sesam event.", example="a1b2c3d4-e5f6-7890-1234-567890abcdef")
    private @NotNull @Length(max=40) String uuid;
    @Length(max=128)
    @Schema(description="The event ID.")
    private @Length(max=128) String eventId;
    @Length(max=32)
    @Schema(description="The object type. Values are among others \u2018TASK-BACKUP\u2019, \u2018MEDIA\u2019 or \u2018SAVESET\u2019.", example="MEDIA")
    private @Length(max=32) String objectType;
    @Length(max=64)
    @Schema(description="The name of the object.", example="20250619124917983@0EiNU1f4fbr")
    private @Length(max=64) String object;
    @Length(max=64)
    @Schema(description="The ID of the object.", example="20250619124917983@0EiNU1f4fbr")
    private @Length(max=64) String objectId;
    @Length(max=64)
    @Schema(description="The UUID of the object.", example="20250619124917983@0EiNU1f4fbr")
    private @Length(max=64) String objectUuid;
    @Length(max=32)
    @Schema(description="The object sub type. Values are among others \u2018SEP Migration\u2019 or \u2018SEP Si3 Replication. ", example="SEP Migration")
    private @Length(max=32) String objectSubType;
    @Length(max=64)
    @Schema(description="The action executed. Values are among others \u2018backup\u2019, \u2018fsck\u2019 or \u2018remove\u2019. ", example="backup")
    private @Length(max=64) String action;
    @Length(max=16)
    @Schema(description="The action type. In case the action is \u2018backup\u2019, the action type contains the FDI level", example="I")
    private @Length(max=16) String actionType;
    @Length(max=16)
    @Schema(description="The action sub type.")
    private @Length(max=16) String actionSubType;
    @Length(max=64)
    @Schema(description="The session ID.")
    private @Length(max=64) String sessionId;
    @Length(max=8)
    @Schema(description="The reference type.")
    private @Length(max=8) String referenceType;
    @Length(max=64)
    @Schema(description="The reference ID.")
    private @Length(max=64) String referenceId;
    @Length(max=40)
    @Schema(description="The reference UUID.", example="20250619124917983@0EiNU1f4fbr")
    private @Length(max=40) String referenceUuid;
    @Schema(description="The version of the Sesam server.", example="server,5.2.0.9,20250703090832")
    private SesamVersion sesamVersion;
    @Schema(description="The sesam date when the sesam event occurred.", example="20250703090832")
    private Date sesamDate;
    @Schema(description="The start time of the sesam event.", example="20250703090832")
    private Date startTime;
    @Schema(description="The stop time of the sesam event.", example="20250703090832")
    private Date stopTime;
    @Schema(description="The delete time of the sesam event.", example="20250703090832")
    private Date deleteTime;
    @Schema(description="The start time of the action.", example="20250703090832")
    private Date actionStartTime;
    @Schema(description="The duration of the sesam event.")
    private Long duration;
    @Schema(description="The end of life of the sesam event.", example="20250703090832")
    private Date eol;
    @Length(max=1)
    @Schema(description="The state. The most common states are \u20180\u2019 (successful) and \u2018X\u2019 (error).", example="0")
    private @Length(max=1) String state;
    @Length(max=1024)
    @Schema(description="The comment or note from SEP sesam.")
    private @Length(max=1024) String sepcomment;
    @Schema(description="The severity of the sesam event.", example="0")
    private Long severity;
    @Schema(description="The priority of the sesam event.", example="0")
    private Long priority;
    @Schema(description="The locked state of the sesam event.", example="false")
    private Boolean locked;
    @Schema(description="The entry number of the sesam event.", example="0")
    private Long entry;
    @Length(max=30)
    @Schema(description="The name of the schedule which triggered the sesam event to be created.")
    private @Length(max=30) String schedule;
    @Length(max=128)
    @Schema(description="The saveset ID of the sesam event.", example="20250619124917983@0EiNU1f4fbr")
    private @Length(max=128) String saveset;
    @Schema(description="The size of the sesam event.", example="1024")
    private Long size;
    @Length(max=4096)
    @Schema(description="The source. This can be in case of a backup task the backup task source. Or in case of\na migration or replication, the source media pool.")
    private @Length(max=4096) String source;
    @Length(max=40)
    @Schema(description="The source Uuid")
    private @Length(max=40) String sourceUuid;
    @Length(max=4096)
    @Schema(description="The target. This can be in case of a migration or replication the target media pool.", example="MP-Si3-Restore-S")
    private @Length(max=4096) String target;
    @Length(max=40)
    @Schema(description="The target Uuid")
    private @Length(max=40) String targetUuid;
    @Schema(description="The client ID of the sesam event.", example="1")
    private Long clientId;
    @Length(max=255)
    @Schema(description="The client name of the sesam event.", example="Test_Client")
    private @Length(max=255) String client;
    @Length(max=40)
    @Schema(description="The client Uuid")
    private @Length(max=40) String clientUuid;
    @Length(max=40)
    @Schema(description="The client OS of the sesam event.", example="Windows 10")
    private @Length(max=40) String clientOs;
    @Length(max=50)
    @Schema(description="The task name of the sesam event.", example="Test_Task")
    private @Length(max=50) String task;
    @Length(max=40)
    @Schema(description="The task Uuid")
    private @Length(max=40) String taskUuid;
    @Length(max=32)
    @Schema(description="The task type.")
    private @Length(max=32) String taskType;
    @Length(max=32)
    @Schema(description="The task sub type.")
    private @Length(max=32) String taskSubType;
    @Length(max=32)
    @Schema(description="The pool name of the sesam event.", example="MP-Si3-Store")
    private @Length(max=32) String pool;
    @Length(max=32)
    @Schema(description="The media label of the sesam event.", example="Test_Label")
    private @Length(max=32) String label;
    @Schema(description="The drive number of the sesam event.", example="1")
    private Long driveNum;
    @Length(max=32)
    @Schema(description="The storage name. In most cases, this is the data store name.", example="MP-Si3-Store")
    private @Length(max=32) String storage;
    @Length(max=32)
    @Schema(description="The storage type.")
    private @Length(max=32) String storageType;
    @Length(max=1024)
    @Schema(description="The user comment.")
    private @Length(max=1024) String usercomment;
    @Length(max=255)
    @Schema(description="The user name.")
    private @Length(max=255) String userName;
    @Schema(description="The last modified date of the sesam event.", example="20250703090832")
    private Date mtime;

    @JsonIgnore
    public static Comparator<SesamEvents> sorter() {
        return comparator;
    }

    public SesamEvents(String uuid) {
        assert (StringUtils.isNotBlank(uuid));
        this.uuid = uuid;
    }

    @Override
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.uuid;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.uuid;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getEventId() {
        return this.eventId;
    }

    @Generated
    public String getObjectType() {
        return this.objectType;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getObjectId() {
        return this.objectId;
    }

    @Generated
    public String getObjectUuid() {
        return this.objectUuid;
    }

    @Generated
    public String getObjectSubType() {
        return this.objectSubType;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public String getActionType() {
        return this.actionType;
    }

    @Generated
    public String getActionSubType() {
        return this.actionSubType;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public String getReferenceUuid() {
        return this.referenceUuid;
    }

    @Generated
    public SesamVersion getSesamVersion() {
        return this.sesamVersion;
    }

    @Generated
    public Date getSesamDate() {
        return this.sesamDate;
    }

    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getStopTime() {
        return this.stopTime;
    }

    @Generated
    public Date getDeleteTime() {
        return this.deleteTime;
    }

    @Generated
    public Date getActionStartTime() {
        return this.actionStartTime;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public Date getEol() {
        return this.eol;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public Long getSeverity() {
        return this.severity;
    }

    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public Boolean getLocked() {
        return this.locked;
    }

    @Generated
    public Long getEntry() {
        return this.entry;
    }

    @Generated
    public String getSchedule() {
        return this.schedule;
    }

    @Generated
    public String getSaveset() {
        return this.saveset;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getSourceUuid() {
        return this.sourceUuid;
    }

    @Generated
    public String getTarget() {
        return this.target;
    }

    @Generated
    public String getTargetUuid() {
        return this.targetUuid;
    }

    @Generated
    public Long getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClient() {
        return this.client;
    }

    @Generated
    public String getClientUuid() {
        return this.clientUuid;
    }

    @Generated
    public String getClientOs() {
        return this.clientOs;
    }

    @Generated
    public String getTask() {
        return this.task;
    }

    @Generated
    public String getTaskUuid() {
        return this.taskUuid;
    }

    @Generated
    public String getTaskType() {
        return this.taskType;
    }

    @Generated
    public String getTaskSubType() {
        return this.taskSubType;
    }

    @Generated
    public String getPool() {
        return this.pool;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public String getStorage() {
        return this.storage;
    }

    @Generated
    public String getStorageType() {
        return this.storageType;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    @Generated
    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @Generated
    public void setObjectUuid(String objectUuid) {
        this.objectUuid = objectUuid;
    }

    @Generated
    public void setObjectSubType(String objectSubType) {
        this.objectSubType = objectSubType;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    @Generated
    public void setActionSubType(String actionSubType) {
        this.actionSubType = actionSubType;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setReferenceUuid(String referenceUuid) {
        this.referenceUuid = referenceUuid;
    }

    @Generated
    public void setSesamVersion(SesamVersion sesamVersion) {
        this.sesamVersion = sesamVersion;
    }

    @Generated
    public void setSesamDate(Date sesamDate) {
        this.sesamDate = sesamDate;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }

    @Generated
    public void setDeleteTime(Date deleteTime) {
        this.deleteTime = deleteTime;
    }

    @Generated
    public void setActionStartTime(Date actionStartTime) {
        this.actionStartTime = actionStartTime;
    }

    @Generated
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Generated
    public void setEol(Date eol) {
        this.eol = eol;
    }

    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setSeverity(Long severity) {
        this.severity = severity;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    @Generated
    public void setEntry(Long entry) {
        this.entry = entry;
    }

    @Generated
    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setSaveset(String saveset) {
        this.saveset = saveset;
    }

    @Generated
    public void setSize(Long size) {
        this.size = size;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setSourceUuid(String sourceUuid) {
        this.sourceUuid = sourceUuid;
    }

    @Generated
    public void setTarget(String target) {
        this.target = target;
    }

    @Generated
    public void setTargetUuid(String targetUuid) {
        this.targetUuid = targetUuid;
    }

    @Generated
    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setClient(String client) {
        this.client = client;
    }

    @Generated
    public void setClientUuid(String clientUuid) {
        this.clientUuid = clientUuid;
    }

    @Generated
    public void setClientOs(String clientOs) {
        this.clientOs = clientOs;
    }

    @Generated
    public void setTask(String task) {
        this.task = task;
    }

    @Generated
    public void setTaskUuid(String taskUuid) {
        this.taskUuid = taskUuid;
    }

    @Generated
    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    @Generated
    public void setTaskSubType(String taskSubType) {
        this.taskSubType = taskSubType;
    }

    @Generated
    public void setPool(String pool) {
        this.pool = pool;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setStorage(String storage) {
        this.storage = storage;
    }

    @Generated
    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public SesamEvents() {
    }
}

