/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.date.DateUtils;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;

public class SepDate
extends AbstractModelEntity<Date>
implements IDisplayLabelProvider {
    @JsonIgnore
    private static final long serialVersionUID = 164732699551372909L;
    @JsonIgnore
    private static final Comparator<SepDate> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getDate() == null && o2 != null && o2.getDate() == null) {
            return 0;
        }
        if (o1 == null || o1.getDate() == null) {
            return -1;
        }
        if (o2 == null || o2.getDate() == null) {
            return 1;
        }
        return o1.getDate().compareTo(o2.getDate()) * -1;
    };
    private final Date date;
    private final String label;

    @JsonIgnore
    public static Comparator<SepDate> sorter() {
        return comparator;
    }

    public SepDate(Date date) {
        this.date = date;
        this.label = DateUtils.dateToDateStr(date);
    }

    @Override
    public Date getPK() {
        return this.date;
    }

    @Override
    public String getDisplayLabel() {
        return this.label;
    }

    @Override
    public String toString() {
        return this.label;
    }

    @Generated
    public Date getDate() {
        return this.date;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }
}

