/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.date.DateUtils;
import de.sep.sesam.model.core.AbstractSchedulesEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.DayOfWeek;
import de.sep.sesam.model.type.ScheduleType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;
import net.sf.oval.constraint.NotNull;

public class Schedules
extends AbstractSchedulesEntity<String>
implements IStringEntity,
IDisplayLabelProvider,
MtimeEntity<String>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 8607013205904618259L;
    @JsonIgnore
    private static final Comparator<Schedules> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @NotNull
    @Length(max=30)
    @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"})
    @Schema(description="The unique name of the schedule. The name can contain only letters, digits, \u2018-\u2018 and the \u2018_\u2019 character.", example="Daily-2200")
    private @NotNull @Length(max=30) @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"}) String name;
    @NotNull
    @Schema(description="Indicates if the schedule is a cyclic schedule.", example="true")
    private Boolean cycFlag;
    @NotNull
    @Schema(description="Flag to mark if the schedule is executed at a relative or absolute point in time", example="true")
    private Boolean absFlag;
    @Schema(description="The relative or absolute offset.", example="1")
    private Long pCount;
    @Schema(description="The number of hours or minutes after the schedule is executed again.", example="0")
    private Long pSubCount;
    @Schema(description="The schedule type.", example="DAY")
    private ScheduleType pBase;
    @Schema(description="The schedule sub type.", example="HOUR")
    private ScheduleType pSubBase;
    @Schema(description="Flag to mark if the schedule executes at Mondays.", example="true")
    private Boolean mo;
    @Schema(description="Flag to mark if the schedule executes at Tuesdays.", example="true")
    private Boolean tu;
    @Schema(description="Flag to mark if the schedule executes at Wednesdays.", example="true")
    private Boolean we;
    @Schema(description="Flag to mark if the schedule executes at Thursdays.", example="true")
    private Boolean th;
    @Schema(description="Flag to mark if the schedule executes at Fridays.", example="true")
    private Boolean fr;
    @Schema(description="Flag to mark if the schedule executes at Saturdays.", example="true")
    private Boolean sa;
    @Schema(description="Flag to mark if the schedule executes at Sundays.", example="true")
    private Boolean su;
    @Schema(description="The day of the month.", example="1")
    private Long dayOfMth;
    @Schema(description="The month of the year.", example="1")
    private Long mthOfYea;
    @Schema(description="The week of the month.", example="1")
    private Long wkOfMth;
    @Schema(description="The day of the week. The maximum length of the day of the week is 10 characters.\nValid values are \u2018day\u2019, \u2018weekday\u2019, \u2018weekendday\u2019, \u2018mo\u2019, \u2018tu\u2019, \u2018we\u2019, \u2018th\u2019, \u2018fr\u2019, \u2018sa\u2019 and \u2018su\u2019.", example="1")
    private DayOfWeek dayOfWk;
    @Schema(description="Flag to mark if the schedule is executed.", example="true")
    private Boolean exec;
    @Schema(description="The offset during the day.", example="1")
    private Long dayOffset;
    @Length(max=1024)
    @Schema(description="The last Sesam system message.")
    private @Length(max=1024) String sepcomment;
    private Long generated;
    @Length(max=40)
    @Schema(description="The UUID of the referenced user defined calendar.", example="12345678-1234-1234-1234-123456789012")
    private @Length(max=40) String calendarUuid;
    @Schema(description="The name of the referenced user defined calendar.", example="Daily-2200")
    private String calendarName;
    @Schema(description="The comment of the schedule.")
    @Length(max=1024)
    private @Length(max=1024) String comment;
    @Length(max=1024)
    @Schema(description="The comment or note from the user.")
    private @Length(max=1024) String usercomment;
    @Schema(description="Flag to mark if the schedule is visible.", example="true")
    private Boolean visible;
    @Schema(description="The time the schedule will be executed up next. (output only)", example="2025-04-15 10:00:00")
    private Date nextExec;
    @Schema(description="The time the schedule was last modified. (output only)", example="2025-04-15 10:00:00")
    private Date mtime;

    @JsonIgnore
    public static Comparator<Schedules> sorter() {
        return comparator;
    }

    public Schedules(String name) {
        this.name = name;
    }

    public Long getpCount() {
        return this.pCount;
    }

    public void setpCount(Long pCount) {
        this.pCount = pCount;
    }

    public Long getpSubCount() {
        return this.pSubCount;
    }

    public void setpSubCount(Long pSubCount) {
        this.pSubCount = pSubCount;
    }

    public ScheduleType getpBase() {
        if (this.pBase == null) {
            return ScheduleType.ONCE;
        }
        return this.pBase;
    }

    public void setpBase(ScheduleType pBase) {
        this.pBase = pBase;
    }

    public ScheduleType getpSubBase() {
        return this.pSubBase;
    }

    public void setpSubBase(ScheduleType pSubBase) {
        this.pSubBase = pSubBase;
    }

    @JsonIgnore
    public String getRunOnDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.pBase != null) {
            switch (this.pBase) {
                case ONCE: {
                    sb.append("once");
                    break;
                }
                case HOURLY: {
                    sb.append("hourly");
                    break;
                }
                case WEEKLY: {
                    sb.append("weekly on");
                    if (this.mo.booleanValue()) {
                        sb.append(" mo");
                    }
                    if (this.tu.booleanValue()) {
                        sb.append(" tu");
                    }
                    if (this.we.booleanValue()) {
                        sb.append(" we");
                    }
                    if (this.th.booleanValue()) {
                        sb.append(" th");
                    }
                    if (this.fr.booleanValue()) {
                        sb.append(" fr");
                    }
                    if (this.sa.booleanValue()) {
                        sb.append(" sa");
                    }
                    if (this.su.booleanValue()) {
                        sb.append(" su");
                    }
                    sb.append(" at ");
                    sb.append(DateUtils.dateToTimeNoSecondsStr(this.getStartTime()));
                    break;
                }
                case DAILY: {
                    sb.append("daily at ");
                    sb.append(DateUtils.dateToTimeNoSecondsStr(this.getStartTime()));
                    break;
                }
                default: {
                    if (this.pBase == ScheduleType.MONTHLY) {
                        sb.append("monthly");
                    }
                    if (this.pBase != ScheduleType.YEARLY) break;
                    sb.append("yearly");
                }
            }
        }
        return sb.toString();
    }

    public void setWeeklyFlags(boolean state) {
        this.setMo(state);
        this.setTu(state);
        this.setWe(state);
        this.setTh(state);
        this.setFr(state);
        this.setSa(state);
        this.setSu(state);
    }

    public boolean isDayActive(int day) {
        if (day <= 0) {
            day = 1;
        }
        switch (day) {
            case 1: {
                return Boolean.TRUE.equals(this.su);
            }
            case 2: {
                return Boolean.TRUE.equals(this.mo);
            }
            case 3: {
                return Boolean.TRUE.equals(this.tu);
            }
            case 4: {
                return Boolean.TRUE.equals(this.we);
            }
            case 5: {
                return Boolean.TRUE.equals(this.th);
            }
            case 6: {
                return Boolean.TRUE.equals(this.fr);
            }
            case 7: {
                return Boolean.TRUE.equals(this.sa);
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean isWeekDaySelected() {
        for (int i = 0; i < 7; ++i) {
            if (!this.isDayActive(1 + i)) continue;
            return true;
        }
        return false;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getCycFlag() {
        return this.cycFlag;
    }

    @Generated
    public Boolean getAbsFlag() {
        return this.absFlag;
    }

    @Generated
    public Boolean getMo() {
        return this.mo;
    }

    @Generated
    public Boolean getTu() {
        return this.tu;
    }

    @Generated
    public Boolean getWe() {
        return this.we;
    }

    @Generated
    public Boolean getTh() {
        return this.th;
    }

    @Generated
    public Boolean getFr() {
        return this.fr;
    }

    @Generated
    public Boolean getSa() {
        return this.sa;
    }

    @Generated
    public Boolean getSu() {
        return this.su;
    }

    @Generated
    public Long getDayOfMth() {
        return this.dayOfMth;
    }

    @Generated
    public Long getMthOfYea() {
        return this.mthOfYea;
    }

    @Generated
    public Long getWkOfMth() {
        return this.wkOfMth;
    }

    @Generated
    public DayOfWeek getDayOfWk() {
        return this.dayOfWk;
    }

    @Generated
    public Boolean getExec() {
        return this.exec;
    }

    @Generated
    public Long getDayOffset() {
        return this.dayOffset;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public Long getGenerated() {
        return this.generated;
    }

    @Generated
    public String getCalendarUuid() {
        return this.calendarUuid;
    }

    @Generated
    public String getCalendarName() {
        return this.calendarName;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public Boolean getVisible() {
        return this.visible;
    }

    @Generated
    public Date getNextExec() {
        return this.nextExec;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCycFlag(Boolean cycFlag) {
        this.cycFlag = cycFlag;
    }

    @Generated
    public void setAbsFlag(Boolean absFlag) {
        this.absFlag = absFlag;
    }

    @Generated
    public void setMo(Boolean mo) {
        this.mo = mo;
    }

    @Generated
    public void setTu(Boolean tu) {
        this.tu = tu;
    }

    @Generated
    public void setWe(Boolean we) {
        this.we = we;
    }

    @Generated
    public void setTh(Boolean th) {
        this.th = th;
    }

    @Generated
    public void setFr(Boolean fr) {
        this.fr = fr;
    }

    @Generated
    public void setSa(Boolean sa) {
        this.sa = sa;
    }

    @Generated
    public void setSu(Boolean su) {
        this.su = su;
    }

    @Generated
    public void setDayOfMth(Long dayOfMth) {
        this.dayOfMth = dayOfMth;
    }

    @Generated
    public void setMthOfYea(Long mthOfYea) {
        this.mthOfYea = mthOfYea;
    }

    @Generated
    public void setWkOfMth(Long wkOfMth) {
        this.wkOfMth = wkOfMth;
    }

    @Generated
    public void setDayOfWk(DayOfWeek dayOfWk) {
        this.dayOfWk = dayOfWk;
    }

    @Generated
    public void setExec(Boolean exec) {
        this.exec = exec;
    }

    @Generated
    public void setDayOffset(Long dayOffset) {
        this.dayOffset = dayOffset;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setGenerated(Long generated) {
        this.generated = generated;
    }

    @Generated
    public void setCalendarUuid(String calendarUuid) {
        this.calendarUuid = calendarUuid;
    }

    @Generated
    public void setCalendarName(String calendarName) {
        this.calendarName = calendarName;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Generated
    public void setNextExec(Date nextExec) {
        this.nextExec = nextExec;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public Schedules() {
    }
}

