/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.types.BackupSubType;
import de.sep.sesam.model.core.types.BackupType;
import de.sep.sesam.model.runtime.interfaces.IResultsModel;
import de.sep.sesam.model.type.BackupLockUpdateMode;
import de.sep.sesam.model.type.CryptFlagType;
import de.sep.sesam.model.type.EventFlag;
import de.sep.sesam.model.type.ExcludeType;
import de.sep.sesam.model.type.Interpreter;
import de.sep.sesam.model.type.OnlineFlag;
import de.sep.sesam.model.type.ReferenceType;
import de.sep.sesam.model.type.SavesetExists;
import de.sep.sesam.model.type.SesamVersion;
import de.sep.sesam.model.type.StateType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class Results
extends AbstractModelEntity<String>
implements IResultsModel<String>,
IDisplayLabelProvider,
IStringEntity,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = -8100618367421039703L;
    @JsonIgnore
    private static final Comparator<Results> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @NotNull
    @Length(max=64)
    @Schema(description="The unique name of the backup. The name is the ID of the save set where the backup\ndata is stored.", example="20250702080004323@NZrHUEHP29T")
    private @NotNull @Length(max=64) String name;
    @Schema(description="The name of the client backed up.", example="Test_Client")
    @Length(max=255)
    private @Length(max=255) String client;
    @Schema(description="The id of the client backed up.", example="1")
    private Long clientId;
    @Schema(description="The ID of the drive used to write the backup data.", example="1")
    private Long driveNum;
    @Schema(description="The name of the drive used to write the backup data.", example="DS@Test-Store_1")
    private String driveName;
    @Schema(description="The name of the backup group the corresponding backup task belongs to", example="Test_Group")
    private String groupName;
    @Schema(description="Value for the weather icon, it is used to make the isLastTaskState", example="1")
    private Double weather;
    @Schema(description="The duration of the backup in seconds.", example="7792")
    private Long duration;
    @Schema(description="The entry number of the backup.", example="50")
    private Long entry;
    @Length(max=255)
    @Schema(description="The name of the interface used to write the backup data.", example="http://Test_Client:11000")
    private @Length(max=255) String ifaceName;
    @Length(max=1024)
    @Schema(description="The backup message from the sesam kernel.", example="15 Sicherungen beendet mit 2 abgebrochenen und 13 erfolgreichen.")
    private @Length(max=1024) String sepcomment;
    @Schema(description="The PID of the backup as long the backup is still executing.", example="1")
    private Long pid;
    @Schema(description="The priority of the backup.", example="1")
    private Long priority;
    @Schema(description="The schedule name of the backup.", example="daily")
    @Length(max=30)
    private @Length(max=30) String schedule;
    @Schema(description="The sesam date when the backup executed.", example="2020-07-02 08:00:04")
    @NotNull
    private Date sesamDate;
    @Length(max=64)
    @Schema(description="The ID of the parent backup or backup group. 'single' or NULL means no parent is assigned.", example="single")
    private @Length(max=64) String sessionId;
    @Schema(description="The size of the backup in bytes.", example="10737418240")
    private Double size;
    @Schema(description="Flag to mark if the data was backed up with source side deduplication.", example="true")
    private Boolean ssddFlag;
    @Schema(description="The progress of the backup in percent.", example="100")
    private Double progress;
    @Schema(description="The start time of the backup.", example="2020-07-02 08:00:04")
    private Date startTime;
    @Schema(description="The backup state. The most common values are \u20180\u2019 (OK) and \u2018X\u2019 or \u20182\u2019 (Error).", example="X")
    private StateType state;
    @Schema(description="The stop time of the backup.", example="2020-07-02 08:00:04")
    private Date stopTime;
    @Schema(description="The backup is terminated if it exceeds the specified date.", example="2020-07-02 08:00:04")
    private Date terminationTime;
    @Schema(description="Value is in MiB/h in DB and converted to B/s for the domain model.", example="100")
    private Double throughput;
    @Schema(description="The user comment of the backup.", example="Test comment")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="The name of the backup task the result belongs to.", example="Test_Task")
    @NotNull
    @Length(max=50)
    private @NotNull @Length(max=50) String task;
    @Length(max=40)
    @Schema(description="The unique ID of the backup task the result belongs to.", example="20250702080004323@NZrHUEHP29T")
    private @Length(max=40) String taskUuid;
    @NotNull
    @Schema(description="The consecutive backup number.", example="10")
    private Long cnt;
    @Schema(description="The backup level the backup has been executed with. Valid values are \u2018COPY\u2019, \u2018FULL\u2019,\n\u2018DIFF\u2019, \u2018INC\u2019, \u2018MIGRATION\u2019, \u2018NEWDAY\u2019, \u2018STARTUP\u2019 and \u2018EXECUTE.")
    private EventFlag fdiType;
    @Schema(description="The backup level originally configured for the backup. Valid values are \u2018COPY\u2019, \u2018FULL\u2019,\n\u2018DIFF\u2019 and \u2018INC\u2019.")
    private EventFlag fdiTypeSet;
    @Schema(description="Flag to mark if the backup is indeed a backup.", example="0")
    private Long isBackup;
    @Schema(description="The name of the media pool the backup data is stored in.", example="Test_Pool")
    @Length(max=16)
    private @Length(max=16) String mediaPool;
    @Length(max=32)
    @Schema(description="The label of the media where the first data of the backup is stored.", example="Test_Media")
    private @Length(max=32) String startMedia;
    @Schema(description="The number of labels associated with this backup.", example="10")
    private Long lblCnt;
    @Schema(description="The originally configured ID of the drive to use for writing the backup data.", example="1")
    private Long driveNumSet;
    @Length(max=40)
    @Schema(description="The unique ID of the client backed up.", example="248ecb8b-0286-43b0-8803-822f4cbd542a")
    private @Length(max=40) String clientUuid;
    @Length(max=32)
    @Schema(description="The operating system of the client backed up.", example="Windows 10")
    private @Length(max=32) String clientOs;
    @Length(max=255)
    @Schema(description="The name or ip of the data mover used to write the backup data.", example="Test_Client")
    private @Length(max=255) String dataMover;
    @Length(max=40)
    @Schema(description="The unique ID of the vcenter client backed up.", example="248ecb8b-0286-43b0-8803-822f4cbd542a")
    private @Length(max=40) String vclientUuid;
    @Schema(description="The version ID of the Sesam server used for the backup.", example="server,5.2.0.8,20250512072728")
    private SesamVersion sesamVersion;
    @Schema(description="The Sesam backup client version ID.", example="5.2.0.8,")
    @Length(max=64)
    private @Length(max=64) String sbcVersion;
    @Length(max=16)
    @Schema(description="The Sesam SMS version ID.", example="5.2")
    private @Length(max=16) String smsVersion;
    @Schema(description="The uniques ID of the location the client belongs too", example="2")
    private Long locationId;
    @Length(max=40)
    @Schema(description="The unique ID of the location the client belongs too", example="248ecb8b-0286-43b0-8803-822f4cbd542a")
    private @Length(max=40) String locationUuid;
    @Length(max=4096)
    @Schema(description="The comma separated list of backup source pattern to match.", example="all")
    private @Length(max=4096) String source;
    @Length(max=64)
    @Schema(description="The encoding of the backup source pattern.")
    private @Length(max=64) String sourceEncoding;
    @Length(max=128)
    @Schema(description="The backup source unique ID. Reserved for future use.", example="248ecb8b-0286-43b0-8803-822f4cbd542a")
    private @Length(max=128) String sourceUuid;
    @Length(max=4096)
    @Schema(description="Additional information about the backup source.", example="all")
    private @Length(max=4096) String additionalSourceInfo;
    @Length(max=1024)
    @Schema(description="The comma separated list of backup source pattern to exclude.", example="H:, I:, P:, S:, U:, Volume{60cf3502-3685-4c69-a746-d66ad049d2f0}, Volume{831d4403-8d72-4366-bd51-f52cbd913e48}, Z:")
    private @Length(max=1024) String exclude;
    @Schema(description="The type of the backup source exclude pattern. Valid values are \u2018pattern\u2019 and \u2018regexp\u2019.", example="pattern")
    private ExcludeType excludeType;
    @Schema(description="The version ID of the Sesam server used for the backup.", example="server,5.2.0.8,20250512072728")
    private Long versionId;
    @Schema(description="Flag to mark if the backup is locked.", example="false")
    private Boolean locked;
    @Schema(description="The end of life date of the backup.", example="2020-07-02 08:00:04")
    private Date eol;
    @Length(max=64)
    @Schema(description="The object or action which changed the backup end-of-life date last.", example="SD20250627140001441@PR5SupM9dhx")
    private @Length(max=64) String eolChangedBy;
    @Length(max=255)
    @Schema(description="The user which changed the backup end-of-life date last.", example="SEPsesam")
    private @Length(max=255) String eolChangedByUser;
    @Schema(description="The message set when the backup end-of-life date changed last", example="EOL adapted for 4 savesets")
    @Length(max=254)
    private @Length(max=254) String eolChangedByMsg;
    @Schema(description="The number of blocks written to the backup data.", example="32197824")
    private Double blocks;
    @Schema(description="The estimated size of the backup data in bytes.", example="10737418240")
    private Double estimatedSize;
    @Schema(description="The size of the backup data in bytes.", example="6680207360")
    private Double dataSize;
    @Schema(description="The size of the skipped backup data in bytes.", example="10737418240")
    private Double skippedSize;
    @Schema(description="The size of the stored backup data in bytes.", example="6680207360")
    private Double storedSize;
    @Schema(description="The size of the total backup data in bytes.", example="13360416640")
    private Double totalSize;
    @Length(max=1)
    @Schema(description="The SMS flag.", example="1")
    private @Length(max=1) String smsFlag;
    @Schema(description="The date and time when the SBC started to back up the data.", example="2020-07-02 08:00:04")
    private Date sbcStart;
    @Schema(description="The save set exist marker.")
    private SavesetExists savesetExist;
    @Length(max=32)
    @Schema(description="The state of the backup.")
    private @Length(max=32) String resultsState;
    @Length(max=20)
    @Schema(description="The backup command.", example="sbc")
    private @Length(max=20) String backupCmd;
    @Schema(description="The backup type.", example="Path")
    private BackupType backupType;
    @Schema(description="The backup sub type.", example="_CBS")
    private BackupSubType backupSubType;
    @Length(max=255)
    @Schema(description="The checkpoint.")
    private @Length(max=255) String checkpoint;
    @Schema(description="The interpreter to use.", example="dump")
    private Interpreter interpreter;
    @Length(max=255)
    @Schema(description="The backup options.")
    private @Length(max=255) String backupOptions;
    @Length(max=255)
    @Schema(description="The restore options.")
    private @Length(max=255) String restoreOptions;
    @Schema(description="Flag to indicate if the backup is a BSR backup.", example="true")
    private Boolean bsrFlag;
    @Schema(description="Flag to indicate if the backup is an extern backup.", example="false")
    private Boolean externFlag;
    @Schema(description="The backup online type. Valid values are \u2018HOT\u2019, \u2018WARM\u2019 and \u2018COLD\u2019. ", example="warm")
    private OnlineFlag onlineFlag;
    @Length(max=2)
    @Schema(description="Flag to indicate of the backup is a sub task of a parent backup.", example="0")
    private @Length(max=2) String subtaskFlag;
    @Schema(description="Flag to indicate if the backup is compressed.", example="true")
    private Boolean compressFlag;
    @Schema(description="Flag to control if the backup data will be encrypted. Valid values are \u2018a\u2019 (AES256) or \u2018b\u2019\n(Blowfish64).", example="a")
    private CryptFlagType cryptFlag;
    @Length(max=128)
    @Schema(description="The encrypted encryption key to encrypt the backup data with.")
    private @Length(max=128) String cryptKey;
    @Schema(description="Flag to indicate if the backup media will be encrypted. Valid values are \u2018a\u2019 (AES256) or\n\u2018b\u2019 (Blowfish64).", example="b")
    private CryptFlagType cryptFlagMedia;
    @Length(max=128)
    @Schema(description="The backup media encryption key.")
    private @Length(max=128) String cryptKeyMedia;
    @Schema(description="The backup verify state. The most common values are \u20180\u2019 (OK) and \u2018X\u2019 or \u20182\u2019 (Error).", example="0")
    private StateType verifyState;
    @Schema(description="The date and time when the backup was verified.", example="2020-07-02 08:00:04")
    private Date verifyDate;
    @Length(max=128)
    @Schema(description="The checksum of the backup.", example="adler32:3331663175")
    private @Length(max=128) String checksum;
    @Length(max=80)
    @Schema(description="The original saveset ID.", example="SI20250512110712525@ls9xZvPTvo0")
    private @Length(max=80) String originalSaveset;
    @Length(max=80)
    @Schema(description="The ID of the backup from which the backup was copied.", example="SI20250512110712525@ls9xZvPTvo0")
    private @Length(max=80) String copyFrom;
    @Schema(description="The reference type. Valid values are \u2018start\u2019 and \u2018restart\u2019.", example="start")
    private ReferenceType referenceType;
    @Schema(description="The reference SSID.", example="SI20250512110712525@ls9xZvPTvo0")
    @Length(max=80)
    private @Length(max=80) String referenceSsid;
    @Schema(description="The save set ID of the FULL backup, a DIFF or INC backup is based on.", example="SF20250512110712525@ls9xZvPTvo0")
    @Length(max=64)
    private @Length(max=64) String basedOnFull;
    @Schema(description="The save set ID of the backup, a DIFF or INC backup is based on.", example="SD20250523140004546@1NyQgjH3f08")
    @Length(max=64)
    private @Length(max=64) String basedOn;
    @Length(max=64)
    @Schema(description="The multi source flag. Valid values are \u20181\u2019 (e_child_submit), \u20182\u2019 (e_child_exec), \u20183\u2019 (e_parent_submit) and \u20184\u2019 (e_parent_exec).", example="1")
    private @Length(max=64) String multiSource;
    @Schema(description="The number of processed items.", example="1000000")
    private Long processed;
    @Schema(description="The number of not processed items.", example="1000000")
    private Long notprocessed;
    @Schema(description="The number of excluded items.", example="1000000")
    private Long excluded;
    @Schema(description="The number of skipped items.", example="1000000")
    private Long skipped;
    @Schema(description="The number of copies of the backup.", example="2")
    private Long totalSavesetCount;
    @Schema(description="The label of the media where the backup is stored.", example="MP-Si3-Store00001")
    @Length(max=30)
    private @Length(max=30) String label;
    @Length(max=64)
    @Schema(description="The ID of the save set where the backup data is stored in.", example="SI20250512110712525@ls9xZvPTvo0")
    private @Length(max=64) String savesetId;
    @Schema(description="The end-of-life date and time of the save set.", example="2020-07-02 08:00:04")
    private Date savesetEol;
    @Schema(description="The object or action which changed the saveset end-of-life date last.", example="SD20250627140001441@PR5SupM9dhx")
    private String savesetEolChangedBy;
    @Length(max=32)
    @Schema(description="The pool where the save set is stored in.", example="MP-Si3-Store00001")
    private @Length(max=32) String savesetPool;
    @Schema(description="The zero based consecutive number of the save set.", example="1")
    private Long savesetCount;
    @Schema(description="The state of the save set.", example="0")
    private StateType savesetState;
    @Schema(description="The date and time when the save set was created.", example="2020-07-02 08:00:04")
    private Date creationTime;
    @Schema(description="The total number of records matched by the query executed to fetch the results object.", example="1000000")
    private Long totalCount;
    @Schema(description="The fraction of the saveset that is currently processed.", example="0.5")
    private Long savesetFraction;
    @JsonIgnore
    private String originServer;
    @Schema(description="Flag that shows if the result is live in the DB or a historic value.", example="true")
    private Boolean live;
    @Schema(description="The date of the last full backup of the based task.", example="2020-07-02 08:00:04")
    private Date lastFullBackup;
    @Schema(description="The date of the last successful run of the backup.", example="2020-07-02 08:00:04")
    private Date lastSuccessfulBackup;
    @Schema(description="The backup of the currently active backup of the same task.", example="SI20250512110712525@ls9xZvPTvo0")
    private String activeBackup;
    @Schema(description="The state of the currently active backup of the same task.", example="0")
    private StateType activeBackupState;
    @Schema(description="The progress of the currently active backup of the same task.", example="0.5")
    private Double activeBackupProgress;
    @Schema(description="Use last successful result entry, if only task is set", example="true")
    private Boolean uselastSuccessfulBackup;
    @Schema(description="The update mode to control the behavior when the \"locked\" flag of a backup changes.", example="CHAIN")
    private BackupLockUpdateMode lockUpdateMode;
    @Schema(description="The date and time when the backup was last modified.", example="2020-07-02 08:00:04")
    private Date mtime;
    @Length(max=40)
    @Schema(description="The unique ID of the backup.", example="5b1901f7-2b7a-457e-ad1b-c18ec4f6b855")
    private @Length(max=40) String uuid;
    @Schema(description="Follow up event that is triggered once the initial backup has been completed.")
    private String followUp;
    @Schema(description="This field is at the moment only used and filled in delete savesets API")
    private String datastoreName;

    @JsonIgnore
    public static Comparator<Results> sorter() {
        return comparator;
    }

    public Results(String name) {
        this.name = name;
    }

    public Double getBlocks() {
        if (this.blocks == null) {
            return 0.0;
        }
        return this.blocks;
    }

    public Double getDedupCompression() {
        if (this.getStoredSize() != null && this.getDataSize() != null) {
            if (this.getStoredSize() < 0.0 || this.getDataSize() <= 0.0) {
                return null;
            }
            if (this.getStoredSize() > this.getDataSize()) {
                return this.getStoredSize() / this.getDataSize() * 100.0;
            }
            return 100.0 - this.getStoredSize() / this.getDataSize() * 100.0;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getClient() {
        return this.client;
    }

    @Override
    @Generated
    public Long getClientId() {
        return this.clientId;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public String getDriveName() {
        return this.driveName;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @Generated
    public Double getWeather() {
        return this.weather;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public Long getEntry() {
        return this.entry;
    }

    @Generated
    public String getIfaceName() {
        return this.ifaceName;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public Long getPid() {
        return this.pid;
    }

    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public String getSchedule() {
        return this.schedule;
    }

    @Override
    @Generated
    public Date getSesamDate() {
        return this.sesamDate;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public Double getSize() {
        return this.size;
    }

    @Generated
    public Boolean getSsddFlag() {
        return this.ssddFlag;
    }

    @Generated
    public Double getProgress() {
        return this.progress;
    }

    @Override
    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public StateType getState() {
        return this.state;
    }

    @Generated
    public Date getStopTime() {
        return this.stopTime;
    }

    @Generated
    public Date getTerminationTime() {
        return this.terminationTime;
    }

    @Generated
    public Double getThroughput() {
        return this.throughput;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public String getTask() {
        return this.task;
    }

    @Generated
    public String getTaskUuid() {
        return this.taskUuid;
    }

    @Generated
    public Long getCnt() {
        return this.cnt;
    }

    @Generated
    public EventFlag getFdiType() {
        return this.fdiType;
    }

    @Generated
    public EventFlag getFdiTypeSet() {
        return this.fdiTypeSet;
    }

    @Generated
    public Long getIsBackup() {
        return this.isBackup;
    }

    @Generated
    public String getMediaPool() {
        return this.mediaPool;
    }

    @Generated
    public String getStartMedia() {
        return this.startMedia;
    }

    @Generated
    public Long getLblCnt() {
        return this.lblCnt;
    }

    @Generated
    public Long getDriveNumSet() {
        return this.driveNumSet;
    }

    @Generated
    public String getClientUuid() {
        return this.clientUuid;
    }

    @Generated
    public String getClientOs() {
        return this.clientOs;
    }

    @Generated
    public String getDataMover() {
        return this.dataMover;
    }

    @Generated
    public String getVclientUuid() {
        return this.vclientUuid;
    }

    @Generated
    public SesamVersion getSesamVersion() {
        return this.sesamVersion;
    }

    @Generated
    public String getSbcVersion() {
        return this.sbcVersion;
    }

    @Generated
    public String getSmsVersion() {
        return this.smsVersion;
    }

    @Generated
    public Long getLocationId() {
        return this.locationId;
    }

    @Generated
    public String getLocationUuid() {
        return this.locationUuid;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    @Generated
    public String getSourceUuid() {
        return this.sourceUuid;
    }

    @Generated
    public String getAdditionalSourceInfo() {
        return this.additionalSourceInfo;
    }

    @Generated
    public String getExclude() {
        return this.exclude;
    }

    @Generated
    public ExcludeType getExcludeType() {
        return this.excludeType;
    }

    @Generated
    public Long getVersionId() {
        return this.versionId;
    }

    @Generated
    public Boolean getLocked() {
        return this.locked;
    }

    @Generated
    public Date getEol() {
        return this.eol;
    }

    @Generated
    public String getEolChangedBy() {
        return this.eolChangedBy;
    }

    @Generated
    public String getEolChangedByUser() {
        return this.eolChangedByUser;
    }

    @Generated
    public String getEolChangedByMsg() {
        return this.eolChangedByMsg;
    }

    @Generated
    public Double getEstimatedSize() {
        return this.estimatedSize;
    }

    @Generated
    public Double getDataSize() {
        return this.dataSize;
    }

    @Generated
    public Double getSkippedSize() {
        return this.skippedSize;
    }

    @Generated
    public Double getStoredSize() {
        return this.storedSize;
    }

    @Generated
    public Double getTotalSize() {
        return this.totalSize;
    }

    @Generated
    public String getSmsFlag() {
        return this.smsFlag;
    }

    @Generated
    public Date getSbcStart() {
        return this.sbcStart;
    }

    @Generated
    public SavesetExists getSavesetExist() {
        return this.savesetExist;
    }

    @Generated
    public String getResultsState() {
        return this.resultsState;
    }

    @Generated
    public String getBackupCmd() {
        return this.backupCmd;
    }

    @Generated
    public BackupType getBackupType() {
        return this.backupType;
    }

    @Generated
    public BackupSubType getBackupSubType() {
        return this.backupSubType;
    }

    @Generated
    public String getCheckpoint() {
        return this.checkpoint;
    }

    @Generated
    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    @Generated
    public String getBackupOptions() {
        return this.backupOptions;
    }

    @Generated
    public String getRestoreOptions() {
        return this.restoreOptions;
    }

    @Generated
    public Boolean getBsrFlag() {
        return this.bsrFlag;
    }

    @Generated
    public Boolean getExternFlag() {
        return this.externFlag;
    }

    @Generated
    public OnlineFlag getOnlineFlag() {
        return this.onlineFlag;
    }

    @Generated
    public String getSubtaskFlag() {
        return this.subtaskFlag;
    }

    @Generated
    public Boolean getCompressFlag() {
        return this.compressFlag;
    }

    @Generated
    public CryptFlagType getCryptFlag() {
        return this.cryptFlag;
    }

    @Generated
    public String getCryptKey() {
        return this.cryptKey;
    }

    @Generated
    public CryptFlagType getCryptFlagMedia() {
        return this.cryptFlagMedia;
    }

    @Generated
    public String getCryptKeyMedia() {
        return this.cryptKeyMedia;
    }

    @Generated
    public StateType getVerifyState() {
        return this.verifyState;
    }

    @Generated
    public Date getVerifyDate() {
        return this.verifyDate;
    }

    @Generated
    public String getChecksum() {
        return this.checksum;
    }

    @Generated
    public String getOriginalSaveset() {
        return this.originalSaveset;
    }

    @Generated
    public String getCopyFrom() {
        return this.copyFrom;
    }

    @Generated
    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public String getReferenceSsid() {
        return this.referenceSsid;
    }

    @Generated
    public String getBasedOnFull() {
        return this.basedOnFull;
    }

    @Generated
    public String getBasedOn() {
        return this.basedOn;
    }

    @Generated
    public String getMultiSource() {
        return this.multiSource;
    }

    @Generated
    public Long getProcessed() {
        return this.processed;
    }

    @Generated
    public Long getNotprocessed() {
        return this.notprocessed;
    }

    @Generated
    public Long getExcluded() {
        return this.excluded;
    }

    @Generated
    public Long getSkipped() {
        return this.skipped;
    }

    @Generated
    public Long getTotalSavesetCount() {
        return this.totalSavesetCount;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getSavesetId() {
        return this.savesetId;
    }

    @Generated
    public Date getSavesetEol() {
        return this.savesetEol;
    }

    @Generated
    public String getSavesetEolChangedBy() {
        return this.savesetEolChangedBy;
    }

    @Generated
    public String getSavesetPool() {
        return this.savesetPool;
    }

    @Generated
    public Long getSavesetCount() {
        return this.savesetCount;
    }

    @Generated
    public StateType getSavesetState() {
        return this.savesetState;
    }

    @Generated
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Long getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public Long getSavesetFraction() {
        return this.savesetFraction;
    }

    @Override
    @Generated
    public String getOriginServer() {
        return this.originServer;
    }

    @Generated
    public Boolean getLive() {
        return this.live;
    }

    @Generated
    public Date getLastFullBackup() {
        return this.lastFullBackup;
    }

    @Generated
    public Date getLastSuccessfulBackup() {
        return this.lastSuccessfulBackup;
    }

    @Generated
    public String getActiveBackup() {
        return this.activeBackup;
    }

    @Generated
    public StateType getActiveBackupState() {
        return this.activeBackupState;
    }

    @Generated
    public Double getActiveBackupProgress() {
        return this.activeBackupProgress;
    }

    @Generated
    public Boolean getUselastSuccessfulBackup() {
        return this.uselastSuccessfulBackup;
    }

    @Generated
    public BackupLockUpdateMode getLockUpdateMode() {
        return this.lockUpdateMode;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getFollowUp() {
        return this.followUp;
    }

    @Generated
    public String getDatastoreName() {
        return this.datastoreName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Generated
    public void setClient(String client) {
        this.client = client;
    }

    @Override
    @Generated
    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setDriveName(String driveName) {
        this.driveName = driveName;
    }

    @Generated
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Generated
    public void setWeather(Double weather) {
        this.weather = weather;
    }

    @Generated
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Generated
    public void setEntry(Long entry) {
        this.entry = entry;
    }

    @Generated
    public void setIfaceName(String ifaceName) {
        this.ifaceName = ifaceName;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setSesamDate(Date sesamDate) {
        this.sesamDate = sesamDate;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setSize(Double size) {
        this.size = size;
    }

    @Generated
    public void setSsddFlag(Boolean ssddFlag) {
        this.ssddFlag = ssddFlag;
    }

    @Generated
    public void setProgress(Double progress) {
        this.progress = progress;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setState(StateType state) {
        this.state = state;
    }

    @Generated
    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }

    @Generated
    public void setTerminationTime(Date terminationTime) {
        this.terminationTime = terminationTime;
    }

    @Generated
    public void setThroughput(Double throughput) {
        this.throughput = throughput;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setTask(String task) {
        this.task = task;
    }

    @Generated
    public void setTaskUuid(String taskUuid) {
        this.taskUuid = taskUuid;
    }

    @Generated
    public void setCnt(Long cnt) {
        this.cnt = cnt;
    }

    @Generated
    public void setFdiType(EventFlag fdiType) {
        this.fdiType = fdiType;
    }

    @Generated
    public void setFdiTypeSet(EventFlag fdiTypeSet) {
        this.fdiTypeSet = fdiTypeSet;
    }

    @Generated
    public void setIsBackup(Long isBackup) {
        this.isBackup = isBackup;
    }

    @Generated
    public void setMediaPool(String mediaPool) {
        this.mediaPool = mediaPool;
    }

    @Generated
    public void setStartMedia(String startMedia) {
        this.startMedia = startMedia;
    }

    @Generated
    public void setLblCnt(Long lblCnt) {
        this.lblCnt = lblCnt;
    }

    @Generated
    public void setDriveNumSet(Long driveNumSet) {
        this.driveNumSet = driveNumSet;
    }

    @Generated
    public void setClientUuid(String clientUuid) {
        this.clientUuid = clientUuid;
    }

    @Generated
    public void setClientOs(String clientOs) {
        this.clientOs = clientOs;
    }

    @Generated
    public void setDataMover(String dataMover) {
        this.dataMover = dataMover;
    }

    @Generated
    public void setVclientUuid(String vclientUuid) {
        this.vclientUuid = vclientUuid;
    }

    @Generated
    public void setSesamVersion(SesamVersion sesamVersion) {
        this.sesamVersion = sesamVersion;
    }

    @Generated
    public void setSbcVersion(String sbcVersion) {
        this.sbcVersion = sbcVersion;
    }

    @Generated
    public void setSmsVersion(String smsVersion) {
        this.smsVersion = smsVersion;
    }

    @Generated
    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }

    @Generated
    public void setLocationUuid(String locationUuid) {
        this.locationUuid = locationUuid;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    @Generated
    public void setSourceUuid(String sourceUuid) {
        this.sourceUuid = sourceUuid;
    }

    @Generated
    public void setAdditionalSourceInfo(String additionalSourceInfo) {
        this.additionalSourceInfo = additionalSourceInfo;
    }

    @Generated
    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    @Generated
    public void setExcludeType(ExcludeType excludeType) {
        this.excludeType = excludeType;
    }

    @Generated
    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    @Generated
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    @Generated
    public void setEol(Date eol) {
        this.eol = eol;
    }

    @Generated
    public void setEolChangedBy(String eolChangedBy) {
        this.eolChangedBy = eolChangedBy;
    }

    @Generated
    public void setEolChangedByUser(String eolChangedByUser) {
        this.eolChangedByUser = eolChangedByUser;
    }

    @Generated
    public void setEolChangedByMsg(String eolChangedByMsg) {
        this.eolChangedByMsg = eolChangedByMsg;
    }

    @Generated
    public void setBlocks(Double blocks) {
        this.blocks = blocks;
    }

    @Generated
    public void setEstimatedSize(Double estimatedSize) {
        this.estimatedSize = estimatedSize;
    }

    @Generated
    public void setDataSize(Double dataSize) {
        this.dataSize = dataSize;
    }

    @Generated
    public void setSkippedSize(Double skippedSize) {
        this.skippedSize = skippedSize;
    }

    @Generated
    public void setStoredSize(Double storedSize) {
        this.storedSize = storedSize;
    }

    @Generated
    public void setTotalSize(Double totalSize) {
        this.totalSize = totalSize;
    }

    @Generated
    public void setSmsFlag(String smsFlag) {
        this.smsFlag = smsFlag;
    }

    @Generated
    public void setSbcStart(Date sbcStart) {
        this.sbcStart = sbcStart;
    }

    @Generated
    public void setSavesetExist(SavesetExists savesetExist) {
        this.savesetExist = savesetExist;
    }

    @Generated
    public void setResultsState(String resultsState) {
        this.resultsState = resultsState;
    }

    @Generated
    public void setBackupCmd(String backupCmd) {
        this.backupCmd = backupCmd;
    }

    @Generated
    public void setBackupType(BackupType backupType) {
        this.backupType = backupType;
    }

    @Generated
    public void setBackupSubType(BackupSubType backupSubType) {
        this.backupSubType = backupSubType;
    }

    @Generated
    public void setCheckpoint(String checkpoint) {
        this.checkpoint = checkpoint;
    }

    @Generated
    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Generated
    public void setBackupOptions(String backupOptions) {
        this.backupOptions = backupOptions;
    }

    @Generated
    public void setRestoreOptions(String restoreOptions) {
        this.restoreOptions = restoreOptions;
    }

    @Generated
    public void setBsrFlag(Boolean bsrFlag) {
        this.bsrFlag = bsrFlag;
    }

    @Generated
    public void setExternFlag(Boolean externFlag) {
        this.externFlag = externFlag;
    }

    @Generated
    public void setOnlineFlag(OnlineFlag onlineFlag) {
        this.onlineFlag = onlineFlag;
    }

    @Generated
    public void setSubtaskFlag(String subtaskFlag) {
        this.subtaskFlag = subtaskFlag;
    }

    @Generated
    public void setCompressFlag(Boolean compressFlag) {
        this.compressFlag = compressFlag;
    }

    @Generated
    public void setCryptFlag(CryptFlagType cryptFlag) {
        this.cryptFlag = cryptFlag;
    }

    @Generated
    public void setCryptKey(String cryptKey) {
        this.cryptKey = cryptKey;
    }

    @Generated
    public void setCryptFlagMedia(CryptFlagType cryptFlagMedia) {
        this.cryptFlagMedia = cryptFlagMedia;
    }

    @Generated
    public void setCryptKeyMedia(String cryptKeyMedia) {
        this.cryptKeyMedia = cryptKeyMedia;
    }

    @Generated
    public void setVerifyState(StateType verifyState) {
        this.verifyState = verifyState;
    }

    @Generated
    public void setVerifyDate(Date verifyDate) {
        this.verifyDate = verifyDate;
    }

    @Generated
    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    @Generated
    public void setOriginalSaveset(String originalSaveset) {
        this.originalSaveset = originalSaveset;
    }

    @Generated
    public void setCopyFrom(String copyFrom) {
        this.copyFrom = copyFrom;
    }

    @Generated
    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setReferenceSsid(String referenceSsid) {
        this.referenceSsid = referenceSsid;
    }

    @Generated
    public void setBasedOnFull(String basedOnFull) {
        this.basedOnFull = basedOnFull;
    }

    @Generated
    public void setBasedOn(String basedOn) {
        this.basedOn = basedOn;
    }

    @Generated
    public void setMultiSource(String multiSource) {
        this.multiSource = multiSource;
    }

    @Generated
    public void setProcessed(Long processed) {
        this.processed = processed;
    }

    @Generated
    public void setNotprocessed(Long notprocessed) {
        this.notprocessed = notprocessed;
    }

    @Generated
    public void setExcluded(Long excluded) {
        this.excluded = excluded;
    }

    @Generated
    public void setSkipped(Long skipped) {
        this.skipped = skipped;
    }

    @Generated
    public void setTotalSavesetCount(Long totalSavesetCount) {
        this.totalSavesetCount = totalSavesetCount;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setSavesetId(String savesetId) {
        this.savesetId = savesetId;
    }

    @Generated
    public void setSavesetEol(Date savesetEol) {
        this.savesetEol = savesetEol;
    }

    @Generated
    public void setSavesetEolChangedBy(String savesetEolChangedBy) {
        this.savesetEolChangedBy = savesetEolChangedBy;
    }

    @Generated
    public void setSavesetPool(String savesetPool) {
        this.savesetPool = savesetPool;
    }

    @Generated
    public void setSavesetCount(Long savesetCount) {
        this.savesetCount = savesetCount;
    }

    @Generated
    public void setSavesetState(StateType savesetState) {
        this.savesetState = savesetState;
    }

    @Generated
    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    @Generated
    public void setSavesetFraction(Long savesetFraction) {
        this.savesetFraction = savesetFraction;
    }

    @Override
    @JsonIgnore
    @Generated
    public void setOriginServer(String originServer) {
        this.originServer = originServer;
    }

    @Generated
    public void setLive(Boolean live) {
        this.live = live;
    }

    @Generated
    public void setLastFullBackup(Date lastFullBackup) {
        this.lastFullBackup = lastFullBackup;
    }

    @Generated
    public void setLastSuccessfulBackup(Date lastSuccessfulBackup) {
        this.lastSuccessfulBackup = lastSuccessfulBackup;
    }

    @Generated
    public void setActiveBackup(String activeBackup) {
        this.activeBackup = activeBackup;
    }

    @Generated
    public void setActiveBackupState(StateType activeBackupState) {
        this.activeBackupState = activeBackupState;
    }

    @Generated
    public void setActiveBackupProgress(Double activeBackupProgress) {
        this.activeBackupProgress = activeBackupProgress;
    }

    @Generated
    public void setUselastSuccessfulBackup(Boolean uselastSuccessfulBackup) {
        this.uselastSuccessfulBackup = uselastSuccessfulBackup;
    }

    @Generated
    public void setLockUpdateMode(BackupLockUpdateMode lockUpdateMode) {
        this.lockUpdateMode = lockUpdateMode;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    @Generated
    public void setDatastoreName(String datastoreName) {
        this.datastoreName = datastoreName;
    }

    @Generated
    public Results() {
    }
}

